/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.services.lookup.BatchLookupResultCache;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public class BatchLookupNormalizer {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BatchLookupNormalizer.class);
    private int m_originalLength;
    private int[] m_forwardMapping;
    private LookupCall[] m_normalizedCalls;

    public LookupCall[] normalizeCalls(LookupCall[] calls) throws ProcessingException {
        this.m_originalLength = 0;
        this.m_forwardMapping = null;
        this.m_normalizedCalls = null;
        if (calls == null || calls.length == 0) {
            return new LookupCall[0];
        }
        this.m_originalLength = calls.length;
        this.m_forwardMapping = new int[this.m_originalLength];
        HashMap<LookupCall, Integer> normMap = new HashMap<LookupCall, Integer>();
        ArrayList<LookupCall> normList = new ArrayList<LookupCall>(this.m_originalLength / 2);
        int normIndex = 0;
        int i = 0;
        while (i < this.m_originalLength) {
            LookupCall call = calls[i];
            if (call == null) {
                this.m_forwardMapping[i] = -1;
            } else if (!BatchLookupResultCache.isCacheable(call.getClass())) {
                this.m_forwardMapping[i] = normIndex++;
                normList.add(call);
            } else {
                Integer existingIndex = (Integer)normMap.get(call);
                if (existingIndex != null) {
                    this.m_forwardMapping[i] = existingIndex;
                } else {
                    this.m_forwardMapping[i] = normIndex;
                    normList.add(call);
                    normMap.put(call, normIndex);
                    ++normIndex;
                }
            }
            ++i;
        }
        normMap = null;
        this.m_normalizedCalls = normList.toArray(new LookupCall[normList.size()]);
        return this.m_normalizedCalls;
    }

    public LookupRow[][] denormalizeResults(LookupRow[][] normalizedResults) throws ProcessingException {
        if (this.m_originalLength == 0 || normalizedResults == null) {
            return new LookupRow[0][];
        }
        if (normalizedResults.length != this.m_normalizedCalls.length) {
            throw new IllegalArgumentException("normalized result array must have length " + this.m_normalizedCalls.length + " (" + normalizedResults.length + ")");
        }
        LookupRow[][] result = new LookupRow[this.m_originalLength][];
        int i = 0;
        while (i < this.m_originalLength) {
            int mapIndex = this.m_forwardMapping[i];
            if (mapIndex >= 0) {
                result[i] = normalizedResults[mapIndex];
            }
            ++i;
        }
        return result;
    }
}

