/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.shared.services.common.code.CODES;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.ICodeVisitor;
import org.eclipse.scout.rt.shared.services.lookup.ICodeLookupCallFactoryService;
import org.eclipse.scout.rt.shared.services.lookup.ICodeLookupCallVisitor;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

public class CodeLookupCall
extends LocalLookupCall
implements Serializable {
    private static final long serialVersionUID = 0L;
    private Class<? extends ICodeType> m_codeTypeClass;
    private ICodeLookupCallVisitor m_filter;
    private Comparator<LookupRow> m_sortComparator;

    public static CodeLookupCall newInstanceByService(Class<? extends ICodeType> codeTypeClass) {
        return ((ICodeLookupCallFactoryService)SERVICES.getService(ICodeLookupCallFactoryService.class)).newInstance(codeTypeClass);
    }

    public CodeLookupCall(Class<? extends ICodeType> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
    }

    public Comparator<LookupRow> getSortComparator() {
        return this.m_sortComparator;
    }

    public void setSortComparator(Comparator<LookupRow> comp) {
        this.m_sortComparator = comp;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CodeLookupCall other = (CodeLookupCall)obj;
        if (this.m_codeTypeClass != other.m_codeTypeClass) {
            return false;
        }
        return this.m_filter == other.m_filter;
    }

    public Class<? extends ICodeType> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    public void setFilter(ICodeLookupCallVisitor filter) {
        this.m_filter = filter;
    }

    public ICodeLookupCallVisitor getFilter() {
        return this.m_filter;
    }

    protected LookupRow[] execCreateLookupRowsFromCodes(List<? extends ICode<?>> codes) {
        LookupRow[] a = new LookupRow[codes.size()];
        int i = 0;
        while (i < a.length) {
            a[i] = this.execCreateLookupRowFromCode(codes.get(i));
            ++i;
        }
        return a;
    }

    protected LookupRow execCreateLookupRowFromCode(ICode<?> code) {
        return CodeLookupCall.createLookupRow(code);
    }

    public static LookupRow[] createLookupRowArray(List<? extends ICode> codes) {
        LookupRow[] a = new LookupRow[codes.size()];
        int i = 0;
        while (i < a.length) {
            a[i] = CodeLookupCall.createLookupRow(codes.get(i));
            ++i;
        }
        return a;
    }

    public static LookupRow createLookupRow(ICode<?> c) {
        Object parentId = null;
        if (c.getParentCode() != null) {
            parentId = c.getParentCode().getId();
        }
        return new LookupRow(c.getId(), c.getText(), c.getIconId(), c.getTooltipText(), c.getBackgroundColor(), c.getForegroundColor(), c.getFont(), c.isEnabled(), parentId, c.isActive());
    }

    public static Pattern getSearchPattern(String s) {
        if (s == null) {
            s = "";
        }
        if (!(s = s.toLowerCase()).endsWith("*")) {
            s = String.valueOf(s) + "*";
        }
        return Pattern.compile(StringUtility.toRegExPattern((String)s), 32);
    }

    @Override
    public LookupRow[] getDataByKey() throws ProcessingException {
        ArrayList list = new ArrayList(1);
        ICode<?> c = this.resolveCodeByKey();
        if (c != null) {
            list.add(c);
        }
        return this.execCreateLookupRowsFromCodes(list);
    }

    @Override
    public LookupRow[] getDataByText() throws ProcessingException {
        Comparator<LookupRow> comparator;
        final Pattern pat = CodeLookupCall.getSearchPattern(this.getText());
        AbstractLookupRowCollector v = new AbstractLookupRowCollector(){

            @Override
            public boolean visit(ICode code, int treeLevel) {
                LookupRow row;
                if (CodeLookupCall.this.m_filter != null && !CodeLookupCall.this.m_filter.visit(CodeLookupCall.this, code, treeLevel)) {
                    return true;
                }
                if ((CodeLookupCall.this.getActive().isUndefined() || CodeLookupCall.this.getActive().getBooleanValue().booleanValue() == code.isActive()) && (row = CodeLookupCall.this.execCreateLookupRowFromCode(code)) != null && row.getText() != null && pat.matcher(row.getText().toLowerCase()).matches()) {
                    this.add(row);
                }
                return true;
            }
        };
        this.resolveCodes(v);
        List<LookupRow> result = v.getLookupRows();
        if (result.size() > 1 && (comparator = this.getSortComparator()) != null) {
            Collections.sort(result, comparator);
        }
        return result.toArray(new LookupRow[result.size()]);
    }

    @Override
    public LookupRow[] getDataByAll() throws ProcessingException {
        Comparator<LookupRow> comparator;
        final Pattern pat = CodeLookupCall.getSearchPattern(this.getAll());
        AbstractLookupRowCollector v = new AbstractLookupRowCollector(){

            @Override
            public boolean visit(ICode code, int treeLevel) {
                LookupRow row;
                if (CodeLookupCall.this.m_filter != null && !CodeLookupCall.this.m_filter.visit(CodeLookupCall.this, code, treeLevel)) {
                    return true;
                }
                if ((CodeLookupCall.this.getActive().isUndefined() || CodeLookupCall.this.getActive().getBooleanValue().booleanValue() == code.isActive()) && (row = CodeLookupCall.this.execCreateLookupRowFromCode(code)) != null && row.getText() != null && pat.matcher(row.getText().toLowerCase()).matches()) {
                    this.add(row);
                }
                return true;
            }
        };
        this.resolveCodes(v);
        List<LookupRow> result = v.getLookupRows();
        if (result.size() > 1 && (comparator = this.getSortComparator()) != null) {
            Collections.sort(result, comparator);
        }
        return result.toArray(new LookupRow[result.size()]);
    }

    @Override
    public LookupRow[] getDataByRec() throws ProcessingException {
        Comparator<LookupRow> comparator;
        Object recValue = this.getRec();
        if (recValue instanceof Number && ((Number)recValue).longValue() == 0L) {
            recValue = null;
        }
        final Object key = recValue;
        AbstractLookupRowCollector v = new AbstractLookupRowCollector(){

            @Override
            public boolean visit(ICode code, int treeLevel) {
                LookupRow row;
                if (CodeLookupCall.this.m_filter != null && !CodeLookupCall.this.m_filter.visit(CodeLookupCall.this, code, treeLevel)) {
                    return true;
                }
                ICode parentCode = code.getParentCode();
                if ((CodeLookupCall.this.getActive().isUndefined() || CodeLookupCall.this.getActive().getBooleanValue().booleanValue() == code.isActive()) && (parentCode == null && key == null || parentCode != null && parentCode.getId() != null && parentCode.getId().equals(key)) && (row = CodeLookupCall.this.execCreateLookupRowFromCode(code)) != null) {
                    this.add(row);
                }
                return true;
            }
        };
        this.resolveCodes(v);
        List<LookupRow> result = v.getLookupRows();
        if (result.size() > 1 && (comparator = this.getSortComparator()) != null) {
            Collections.sort(result, comparator);
        }
        return result.toArray(new LookupRow[result.size()]);
    }

    protected ICode<?> resolveCodeByKey() throws ProcessingException {
        Object key = this.getKey();
        ICodeType t = CODES.getCodeType(this.m_codeTypeClass);
        if (t == null) {
            return null;
        }
        return t.getCode(key);
    }

    protected void resolveCodes(ICodeVisitor v) throws ProcessingException {
        ICodeType t = CODES.getCodeType(this.m_codeTypeClass);
        if (t != null) {
            t.visit(v, false);
        }
    }

    private static abstract class AbstractLookupRowCollector
    implements ICodeVisitor {
        private ArrayList<LookupRow> m_list = new ArrayList();

        public void add(LookupRow row) {
            this.m_list.add(row);
        }

        public List<LookupRow> getLookupRows() {
            return this.m_list;
        }
    }
}

