/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.action;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;

public class RwtScoutAction {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutAction.class);
    private static final Map<String, String> KEY_STROKE_MAP = new HashMap<String, String>(12);
    private final IAction m_scoutAction;
    private final Action m_uiAction;
    private final IRwtEnvironment m_uiEnvironment;
    private boolean m_handleActionPending;

    static {
        int i = 1;
        while (i <= 12) {
            KEY_STROKE_MAP.put("SHIFT-F" + i, "Shift-F" + i);
            ++i;
        }
    }

    public RwtScoutAction(IAction scoutAction, IRwtEnvironment uiEnvironment) {
        this(scoutAction, uiEnvironment, 8);
    }

    public RwtScoutAction(IAction scoutAction, IRwtEnvironment uiEnvironment, int style) {
        this.m_scoutAction = scoutAction;
        this.m_uiEnvironment = uiEnvironment;
        this.m_uiAction = new P_RwtAction(style);
        String keyStroke = this.m_scoutAction.getKeyStroke();
        if (StringUtility.hasText((String)keyStroke)) {
            this.m_uiAction.setText(String.valueOf(this.m_scoutAction.getText()) + "@" + this.lookupKeyStrokeText(keyStroke));
        } else {
            this.m_uiAction.setText(this.m_scoutAction.getText());
        }
        this.m_uiAction.setToolTipText(this.m_scoutAction.getTooltipText());
        this.m_uiAction.setImageDescriptor(this.getUiEnvironment().getImageDescriptor(this.m_scoutAction.getIconId()));
        this.m_uiAction.setEnabled(scoutAction.isEnabled());
        this.setKeyStrokeFromScout(keyStroke);
    }

    protected void handleUiAction() {
        if (!this.m_handleActionPending) {
            this.m_handleActionPending = true;
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    try {
                        RwtScoutAction.this.getScoutAction().getUIFacade().fireActionFromUI();
                    }
                    finally {
                        RwtScoutAction.this.m_handleActionPending = false;
                    }
                }
            };
            this.getUiEnvironment().invokeScoutLater(job, 0L);
        }
    }

    public IAction getScoutAction() {
        return this.m_scoutAction;
    }

    public Action getUiAction() {
        return this.m_uiAction;
    }

    protected IRwtEnvironment getUiEnvironment() {
        return this.m_uiEnvironment;
    }

    private void setKeyStrokeFromScout(String keyStroke) {
        if (keyStroke != null) {
            int keyCode = RwtUtility.getRwtKeyCode((IKeyStroke)new KeyStroke(keyStroke));
            int stateMask = RwtUtility.getRwtStateMask((IKeyStroke)new KeyStroke(keyStroke));
            this.getUiAction().setAccelerator(stateMask | keyCode);
        } else {
            this.getUiAction().setAccelerator(0);
        }
    }

    private String lookupKeyStrokeText(String keyStroke) {
        return KEY_STROKE_MAP.get(keyStroke.toUpperCase());
    }

    private class P_RwtAction
    extends Action {
        private static final long serialVersionUID = 1L;

        P_RwtAction(int style) {
            super("", style);
        }

        public void run() {
            RwtScoutAction.this.handleUiAction();
        }
    }
}

