/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.basic.table;

import java.util.HashMap;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scout.commons.HTMLUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn;
import org.eclipse.scout.rt.ui.rap.basic.table.IRwtScoutTableForPatch;
import org.eclipse.scout.rt.ui.rap.basic.table.RwtScoutTableEvent;
import org.eclipse.scout.rt.ui.rap.basic.table.TableColumnManager;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.rap.util.HtmlTextUtility;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class RwtScoutColumnModel
extends ColumnLabelProvider {
    private static final long serialVersionUID = 1L;
    private static final int HTML_ROW_LINE_HIGHT = 19;
    private static final int NEWLINE_LINE_HIGHT = 15;
    private transient ListenerList listenerList = null;
    private final ITable m_scoutTable;
    private HashMap<ITableRow, HashMap<IColumn<?>, ICell>> m_cachedCells;
    private final IRwtScoutTableForPatch m_uiTable;
    private final TableColumnManager m_columnManager;
    private Image m_imgCheckboxFalse;
    private Image m_imgCheckboxTrue;
    private Color m_disabledForegroundColor;
    private int m_defaultRowHeight;

    public RwtScoutColumnModel(ITable scoutTable, IRwtScoutTableForPatch uiTable, TableColumnManager columnManager) {
        this.m_scoutTable = scoutTable;
        this.m_uiTable = uiTable;
        this.m_columnManager = columnManager;
        this.m_imgCheckboxTrue = this.getUiTable().getUiEnvironment().getIcon("checkbox_yes");
        this.m_imgCheckboxFalse = this.getUiTable().getUiEnvironment().getIcon("checkbox_no");
        this.m_disabledForegroundColor = this.getUiTable().getUiEnvironment().getColor(UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled());
        this.rebuildCache();
    }

    protected ITable getScoutTable() {
        return this.m_scoutTable;
    }

    public IRwtScoutTableForPatch getUiTable() {
        return this.m_uiTable;
    }

    public void update(ViewerCell cell) {
        ITableRow element = (ITableRow)cell.getElement();
        int columnIndex = cell.getColumnIndex();
        cell.setText(this.getColumnText(element, columnIndex));
        cell.setImage(this.getColumnImage(element, columnIndex));
        cell.setBackground(this.getBackground(element, columnIndex));
        cell.setForeground(this.getForeground(element, columnIndex));
        cell.setFont(this.getFont(element, columnIndex));
    }

    public String getColumnText(ITableRow element, int columnIndex) {
        ICell cell = this.getCell(element, columnIndex);
        if (cell == null) {
            return "";
        }
        String text = cell.getText();
        if (text == null) {
            text = "";
        } else if (HtmlTextUtility.isTextWithHtmlMarkup(text)) {
            text = this.getUiTable().getUiEnvironment().adaptHtmlCell(this.getUiTable(), text);
            text = this.getUiTable().getUiEnvironment().convertLinksWithLocalUrlsInHtmlCell(this.getUiTable(), text);
        } else {
            boolean markupEnabled;
            boolean multiline = false;
            if (text.indexOf("\n") >= 0 && !(multiline = this.getScoutTable().isMultilineText())) {
                text = StringUtility.replaceNewLines((String)text, (String)" ");
            }
            if ((markupEnabled = Boolean.TRUE.equals(this.getUiTable().getUiField().getData("org.eclipse.rap.rwt.markupEnabled"))) || multiline) {
                text = HtmlTextUtility.transformPlainTextToHtml(text);
            }
        }
        return text;
    }

    protected int getDefaultRowHeight() {
        return this.m_defaultRowHeight;
    }

    public Image getColumnImage(ITableRow element, int columnIndex) {
        int[] columnOrder = this.getUiTable().getUiField().getColumnOrder();
        if (columnOrder.length <= 1) {
            return null;
        }
        IColumn<?> col = this.m_columnManager.getColumnByModelIndex(columnIndex - 1);
        ICell cell = this.getCell(element, columnIndex);
        Image checkBoxImage = null;
        if (columnOrder[1] == columnIndex && this.getUiTable().getScoutObject() != null && ((ITable)this.getUiTable().getScoutObject()).isCheckable()) {
            checkBoxImage = element.isChecked() ? this.m_imgCheckboxTrue : this.m_imgCheckboxFalse;
        } else if (!(col == null || cell == null || col.getDataType() != Boolean.class || col instanceof ISmartColumn && ((ISmartColumn)col).getLookupCall() != null)) {
            Boolean b = (Boolean)cell.getValue();
            checkBoxImage = b != null && b != false ? this.m_imgCheckboxTrue : this.m_imgCheckboxFalse;
        }
        String iconId = null;
        if (cell != null && cell.getIconId() != null) {
            iconId = cell.getIconId();
        } else if (columnOrder[1] == columnIndex) {
            iconId = element.getIconId();
        }
        Image decoImage = this.getUiTable().getUiEnvironment().getIcon(iconId);
        if (checkBoxImage != null && decoImage != null) {
            return checkBoxImage;
        }
        if (checkBoxImage != null) {
            return checkBoxImage;
        }
        if (decoImage != null) {
            return decoImage;
        }
        return null;
    }

    public Color getBackground(ITableRow element, int columnIndex) {
        ICell cell;
        if (columnIndex > 0 && (cell = this.getCell(element, columnIndex)) != null) {
            return this.getUiTable().getUiEnvironment().getColor(cell.getBackgroundColor());
        }
        return null;
    }

    public Color getForeground(ITableRow element, int columnIndex) {
        ICell cell;
        if (columnIndex > 0 && (cell = this.getCell(element, columnIndex)) != null) {
            Color col = this.getUiTable().getUiEnvironment().getColor(cell.getForegroundColor());
            if (!(col != null || element.isEnabled() && cell.isEnabled())) {
                col = this.m_disabledForegroundColor;
            }
            return col;
        }
        return null;
    }

    public Font getFont(ITableRow element, int columnIndex) {
        ICell cell;
        if (columnIndex > 0 && (cell = this.getCell(element, columnIndex)) != null) {
            return this.getUiTable().getUiEnvironment().getFont(cell.getFont(), this.getUiTable().getUiField().getFont());
        }
        return null;
    }

    public String getToolTipText(Object element) {
        Display display = this.getUiTable().getUiEnvironment().getDisplay();
        Point cursorOnTable = display.map(null, (Control)this.getUiTable().getUiField(), display.getCursorLocation());
        ViewerCell uiCell = this.getUiTable().getUiTableViewer().getCell(cursorOnTable);
        String text = "";
        if (uiCell != null) {
            int columnIndex = uiCell.getColumnIndex();
            ICell cell = this.getCell(element, columnIndex);
            if (cell != null && (text = cell.getTooltipText()) == null) {
                text = cell.getText();
                if (HtmlTextUtility.isTextWithHtmlMarkup(text)) {
                    text = HTMLUtility.getPlainText((String)text);
                }
                if (text == null || text.indexOf("\n") <= 0) {
                    text = "";
                }
            }
            text = StringUtility.wrapWord((String)text, (int)80);
        }
        return text;
    }

    public void consumeColumnModelEvent(RwtScoutTableEvent uiTableEvent) {
        this.rebuildCache();
    }

    protected ICell getCell(Object row, int colIndex) {
        IColumn<?> column = this.m_columnManager.getColumnByModelIndex(colIndex - 1);
        if (column != null) {
            if (this.m_cachedCells == null || this.m_cachedCells.get(row) == null) {
                this.rebuildCache();
            }
            return this.m_cachedCells.get(row).get(column);
        }
        return null;
    }

    private void rebuildCache() {
        this.m_cachedCells = new HashMap();
        if (this.getScoutTable() != null) {
            ITableRow[] iTableRowArray = this.getScoutTable().getRows();
            int n = iTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITableRow scoutRow = iTableRowArray[n2];
                HashMap<IColumn, ICell> cells = new HashMap<IColumn, ICell>();
                IColumn[] iColumnArray = this.getScoutTable().getColumnSet().getVisibleColumns();
                int n3 = iColumnArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IColumn col = iColumnArray[n4];
                    cells.put(col, this.getScoutTable().getCell(scoutRow, col));
                    ++n4;
                }
                this.m_cachedCells.put(scoutRow, cells);
                ++n2;
            }
        }
    }
}

