/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.busy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.busy.BusyJob;
import org.eclipse.scout.rt.client.busy.IBusyHandler;
import org.eclipse.scout.rt.ui.rap.busy.RwtBusyHandler;
import org.eclipse.scout.rt.ui.rap.busy.RwtScoutPartBlockingDecorator;
import org.eclipse.scout.rt.ui.rap.window.IRwtScoutPart;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class BlockPartsJob
extends BusyJob {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BlockPartsJob.class);
    private final List<IRwtScoutPart> m_parts;

    public BlockPartsJob(String name, RwtBusyHandler handler, List<IRwtScoutPart> parts) {
        super(name, (IBusyHandler)handler);
        this.setSystem(true);
        this.m_parts = parts;
    }

    protected RwtBusyHandler getBusyHandler() {
        return (RwtBusyHandler)super.getBusyHandler();
    }

    protected void runBusy(IProgressMonitor monitor) {
    }

    protected void runBlocking(final IProgressMonitor monitor) {
        if (this.m_parts == null || this.m_parts.size() == 0) {
            return;
        }
        final ArrayList decoList = new ArrayList();
        Display display = this.getBusyHandler().getDisplay();
        final Control busyControl = (Control)this.getBusyHandler().getUiEnvironment().getClientSession().getData("RwtBusyHandler.busyControl");
        try {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (busyControl != null && !busyControl.isDisposed()) {
                        busyControl.setVisible(true);
                    }
                    IRwtScoutPart activePart = (IRwtScoutPart)BlockPartsJob.this.m_parts.get(0);
                    for (IRwtScoutPart p : BlockPartsJob.this.m_parts) {
                        if (p == null) continue;
                        decoList.add(new RwtScoutPartBlockingDecorator(p, p == activePart, BlockPartsJob.this.getBusyHandler().getUiEnvironment()));
                    }
                    for (RwtScoutPartBlockingDecorator deco : decoList) {
                        try {
                            deco.attach(monitor);
                        }
                        catch (Exception e1) {
                            LOG.warn("attach", (Throwable)e1);
                        }
                    }
                }
            });
            BlockPartsJob.super.runBlocking(monitor);
        }
        catch (Throwable throwable) {
            display.asyncExec(new Runnable(busyControl, decoList){
                private final /* synthetic */ Control val$busyControl;
                private final /* synthetic */ ArrayList val$decoList;
                {
                    this.val$busyControl = control;
                    this.val$decoList = arrayList;
                }

                @Override
                public void run() {
                    if (this.val$busyControl != null && !this.val$busyControl.isDisposed()) {
                        this.val$busyControl.setVisible(false);
                    }
                    for (RwtScoutPartBlockingDecorator deco : this.val$decoList) {
                        try {
                            deco.detach();
                        }
                        catch (Exception e1) {
                            LOG.warn("detach", (Throwable)e1);
                        }
                    }
                }
            });
            throw throwable;
        }
        display.asyncExec(new /* invalid duplicate definition of identical inner class */);
    }
}

