/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.extension.internal;

import java.util.HashMap;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.rap.extension.ILookAndFeelProperties;

public class LookAndFeelProperties
implements ILookAndFeelProperties {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(LookAndFeelProperties.class);
    private String m_contributor;
    private int m_scope;
    private String m_deviceTypeIdentifier;
    private HashMap<String, String> m_values = new HashMap();

    @Override
    public int getScope() {
        return this.m_scope;
    }

    public void setScope(int scope) {
        this.m_scope = scope;
    }

    @Override
    public String getDeviceTypeIdentifier() {
        return this.m_deviceTypeIdentifier;
    }

    public void setDeviceTypeIdentifier(String deviceTypeIdentifier) {
        this.m_deviceTypeIdentifier = deviceTypeIdentifier;
    }

    @Override
    public int getPropertyInt(String name) {
        String value = this.m_values.get(name);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error("Could not parse extension look and feel of contributor '" + this.m_contributor + "' property name='" + name + "' value='" + value + "'");
            return 0;
        }
    }

    public void setPropertyString(String name, String value) {
        this.m_values.put(name, value);
    }

    public void setContributor(String contributor) {
        this.m_contributor = contributor;
    }

    public String getContributor() {
        return this.m_contributor;
    }

    @Override
    public boolean getPropertyBool(String name) {
        String value = this.m_values.get(name);
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public boolean existsProperty(String name) {
        return this.m_values.containsKey(name);
    }

    public void setProperty(String name, String value) {
        this.m_values.put(name, value);
    }

    @Override
    public String getPropertyString(String name) {
        return this.m_values.get(name);
    }
}

