/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.internal.servletfilter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.scout.http.servletfilter.FilterConfigInjection;

public class LogoutFilter
implements Filter {
    public static String LOGOUT_PARAM = "doLogout";
    private FilterConfigInjection m_injection;

    public void init(FilterConfig config0) throws ServletException {
        this.m_injection = new FilterConfigInjection(config0, this.getClass());
    }

    public void destroy() {
        this.m_injection = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterConfigInjection.FilterConfig config = this.m_injection.getConfig(request);
        if (!config.isActive()) {
            chain.doFilter(request, response);
            return;
        }
        String logoutParam = request.getParameter(LOGOUT_PARAM);
        if (logoutParam == null) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(false);
        if (session == null) {
            chain.doFilter(request, response);
            return;
        }
        session.invalidate();
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String servletPath = this.getRedirectUrl(httpRequest);
        httpResponse.sendRedirect(httpResponse.encodeRedirectURL(servletPath));
    }

    protected String getRedirectUrl(HttpServletRequest httpRequest) {
        String servletPath = httpRequest.getServletPath();
        if (servletPath.length() > 0 && '/' == servletPath.charAt(0)) {
            servletPath = servletPath.substring(1);
        }
        return servletPath;
    }
}

