/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.keystroke;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.keystroke.IKeyStrokeManager;
import org.eclipse.scout.rt.ui.rap.keystroke.IRwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class KeyStrokeManager
implements IKeyStrokeManager {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(KeyStrokeManager.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private Listener m_keyListener;
    private KeyAdapter m_keyAdapter;
    private List<IRwtKeyStroke> m_globalKeyStrokes;
    private List<String> m_globalCancelKeyList;
    private Map<Widget, List<String>> m_widgetActiveKeys;
    private Map<Widget, List<String>> m_widgetCancelKeys;
    private P_KeyEventHandler m_keyEventHandler;
    private boolean m_globalKeyStrokesActivated = false;
    private Object m_globalKeyStrokeListLock;
    private final IRwtEnvironment m_environment;

    public KeyStrokeManager(IRwtEnvironment environment) {
        this.m_environment = environment;
        this.m_globalKeyStrokeListLock = new Object();
        this.m_globalKeyStrokes = new ArrayList<IRwtKeyStroke>();
        this.m_globalCancelKeyList = new ArrayList<String>();
        this.m_widgetActiveKeys = new HashMap<Widget, List<String>>();
        this.m_widgetCancelKeys = new HashMap<Widget, List<String>>();
        this.m_keyEventHandler = new P_KeyEventHandler();
        this.m_keyAdapter = new KeyAdapter(){
            private static final long serialVersionUID = 1L;

            public void keyPressed(KeyEvent e) {
                if (e.keyCode > 0 && e.display != null) {
                    KeyStrokeManager.this.m_keyEventHandler.addEvent(e);
                    e.display.asyncExec((Runnable)KeyStrokeManager.this.m_keyEventHandler);
                }
            }
        };
        this.m_keyListener = new Listener(){
            private static final long serialVersionUID = 1L;

            public void handleEvent(Event e) {
                if (e.keyCode > 0 && e.display != null) {
                    KeyStrokeManager.this.m_keyEventHandler.addEvent(e);
                    e.display.asyncExec((Runnable)KeyStrokeManager.this.m_keyEventHandler);
                }
            }
        };
        environment.getDisplay().addFilter(1, this.m_keyListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGlobalKeyStroke(IRwtKeyStroke stroke, boolean exclusive) {
        Object object = this.m_globalKeyStrokeListLock;
        synchronized (object) {
            this.m_globalKeyStrokes.add(stroke);
            if (exclusive && stroke.isRegisterActiveKey()) {
                this.m_globalCancelKeyList.add(this.resolveKeyString(stroke));
            }
            this.updateGlobalKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeGlobalKeyStroke(IRwtKeyStroke stroke) {
        Object object = this.m_globalKeyStrokeListLock;
        synchronized (object) {
            boolean retVal = this.m_globalKeyStrokes.remove(stroke);
            this.m_globalCancelKeyList.remove(this.resolveKeyString(stroke));
            this.updateGlobalKeys();
            return retVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IRwtKeyStroke> getGlobalKeyStrokes() {
        Object object = this.m_globalKeyStrokeListLock;
        synchronized (object) {
            return this.m_globalKeyStrokes;
        }
    }

    @Override
    public void addKeyStroke(Control control, IRwtKeyStroke stroke, boolean exclusive) {
        ArrayList<IRwtKeyStroke> keyStrokes = (ArrayList<IRwtKeyStroke>)control.getData("org.eclipse.scout.rt.ui.rap.keyStrokes");
        if (keyStrokes == null) {
            keyStrokes = new ArrayList<IRwtKeyStroke>();
        }
        keyStrokes.add(stroke);
        control.setData("org.eclipse.scout.rt.ui.rap.keyStrokes", keyStrokes);
        List<String> widgetActiveKeys = this.m_widgetActiveKeys.get(control);
        if (widgetActiveKeys == null) {
            widgetActiveKeys = new ArrayList<String>();
        }
        if (stroke.isRegisterActiveKey()) {
            widgetActiveKeys.add(this.resolveKeyString(stroke));
        }
        this.m_widgetActiveKeys.put((Widget)control, widgetActiveKeys);
        if (exclusive) {
            List<String> widgetCancelKeys = this.m_widgetCancelKeys.get(control);
            if (widgetCancelKeys == null) {
                widgetCancelKeys = new ArrayList<String>();
            }
            if (stroke.isRegisterActiveKey()) {
                widgetCancelKeys.add(this.resolveKeyString(stroke));
            }
            this.m_widgetCancelKeys.put((Widget)control, widgetCancelKeys);
        }
        this.updateControlKeys(control);
    }

    @Override
    public boolean removeKeyStroke(Control control, IRwtKeyStroke stroke) {
        List<String> widgetCancelKeys;
        List<String> widgetActiveKeys;
        boolean retVal = false;
        if (control == null || control.isDisposed()) {
            this.m_widgetActiveKeys.remove(control);
            this.m_widgetCancelKeys.remove(control);
            return retVal;
        }
        List keyStrokes = (List)control.getData("org.eclipse.scout.rt.ui.rap.keyStrokes");
        if (keyStrokes != null) {
            retVal = keyStrokes.remove(stroke);
            control.setData("org.eclipse.scout.rt.ui.rap.keyStrokes", (Object)keyStrokes);
        }
        if ((widgetActiveKeys = this.m_widgetActiveKeys.get(control)) != null) {
            widgetActiveKeys.remove(this.resolveKeyString(stroke));
            if (widgetActiveKeys.size() == 0) {
                this.m_widgetActiveKeys.remove(control);
            }
        }
        if ((widgetCancelKeys = this.m_widgetCancelKeys.get(control)) != null) {
            widgetCancelKeys.remove(this.resolveKeyString(stroke));
            if (widgetCancelKeys.size() == 0) {
                this.m_widgetCancelKeys.remove(control);
            }
        }
        this.updateControlKeys(control);
        return retVal;
    }

    @Override
    public boolean removeKeyStrokes(Control control) {
        boolean retVal = false;
        if (control != null && !control.isDisposed()) {
            for (IRwtKeyStroke stroke : new ArrayList<IRwtKeyStroke>(this.getKeyStrokes((Widget)control))) {
                retVal &= this.removeKeyStroke(control, stroke);
            }
            control.setData("org.eclipse.scout.rt.ui.rap.keyStrokes", null);
        }
        this.m_widgetActiveKeys.remove(control);
        this.m_widgetCancelKeys.remove(control);
        return retVal;
    }

    protected List<IRwtKeyStroke> getKeyStrokes(Widget widget) {
        Object data;
        List keyStrokes = null;
        if (widget != null && (data = widget.getData("org.eclipse.scout.rt.ui.rap.keyStrokes")) instanceof List && ((List)data).size() > 0) {
            keyStrokes = CollectionUtility.copyList((Collection)((List)data));
        }
        if (keyStrokes == null) {
            keyStrokes = Collections.emptyList();
        }
        return keyStrokes;
    }

    private void updateGlobalKeys() {
        HashSet<String> activeKeys = new HashSet<String>(this.m_globalKeyStrokes.size());
        for (IRwtKeyStroke stroke : this.m_globalKeyStrokes) {
            if (!stroke.isRegisterActiveKey()) continue;
            String activeKey = this.resolveKeyString(stroke);
            activeKeys.add(activeKey);
        }
        if (activeKeys.size() == 0) {
            this.m_environment.getDisplay().setData("org.eclipse.rap.rwt.activeKeys", (Object)EMPTY_STRING_ARRAY);
        } else {
            String[] activeKeyArray = activeKeys.toArray(new String[activeKeys.size()]);
            this.m_environment.getDisplay().setData("org.eclipse.rap.rwt.activeKeys", (Object)activeKeyArray);
        }
        if (this.m_globalCancelKeyList == null || this.m_globalCancelKeyList.size() == 0) {
            this.m_environment.getDisplay().setData("org.eclipse.rap.rwt.cancelKeys", (Object)EMPTY_STRING_ARRAY);
        } else {
            String[] cancelKeyArray = this.m_globalCancelKeyList.toArray(new String[this.m_globalCancelKeyList.size()]);
            this.m_environment.getDisplay().setData("org.eclipse.rap.rwt.cancelKeys", (Object)cancelKeyArray);
        }
    }

    private void updateControlKeys(Control control) {
        control.removeKeyListener((KeyListener)this.m_keyAdapter);
        boolean requireListener = false;
        List<String> activeKeys = this.m_widgetActiveKeys.get(control);
        if (activeKeys == null || activeKeys.size() == 0) {
            control.setData("org.eclipse.rap.rwt.activeKeys", (Object)EMPTY_STRING_ARRAY);
        } else {
            String[] activeKeyArray = activeKeys.toArray(new String[activeKeys.size()]);
            control.setData("org.eclipse.rap.rwt.activeKeys", (Object)activeKeyArray);
            requireListener = true;
        }
        List<String> widgetCancelKeys = this.m_widgetCancelKeys.get(control);
        if (widgetCancelKeys == null || widgetCancelKeys.size() == 0) {
            control.setData("org.eclipse.rap.rwt.cancelKeys", (Object)EMPTY_STRING_ARRAY);
        } else {
            String[] cancelKeyArray = widgetCancelKeys.toArray(new String[widgetCancelKeys.size()]);
            control.setData("org.eclipse.rap.rwt.cancelKeys", (Object)cancelKeyArray);
            requireListener = true;
        }
        if (requireListener) {
            control.addKeyListener((KeyListener)this.m_keyAdapter);
        }
    }

    private String resolveKeyString(IRwtKeyStroke stroke) {
        String modifier = "";
        if (stroke.getStateMask() > 0) {
            ArrayList<String> modifiers = new ArrayList<String>();
            if ((stroke.getStateMask() & 0x20000) == 131072) {
                modifiers.add("SHIFT");
            }
            if ((stroke.getStateMask() & 0x10000) == 65536) {
                modifiers.add("ALT");
            }
            if ((stroke.getStateMask() & 0x40000) == 262144 || (stroke.getStateMask() & 0x400000) == 0x400000) {
                modifiers.add("CTRL");
            }
            modifier = StringUtility.join((String)"+", (String[])((String[])CollectionUtility.toArray(modifiers, String.class)));
        }
        String key = RwtUtility.getKeyTextUpper(stroke.getKeyCode());
        String keyString = StringUtility.join((String)"+", (Object[])new Object[]{modifier, key});
        return keyString;
    }

    public boolean isGlobalKeyStrokesActivated() {
        return this.m_globalKeyStrokesActivated;
    }

    public void setGlobalKeyStrokesActivated(boolean globalKeyStrokesActivated) {
        this.m_globalKeyStrokesActivated = globalKeyStrokesActivated;
    }

    private void handleKeyEvent(Event event) {
        if (event.doit && event.display != null) {
            this.handleKeyEventHierarchical(event, (Widget)event.display.getFocusControl());
        }
        if (event.doit && this.isGlobalKeyStrokesActivated()) {
            for (IRwtKeyStroke keyStroke : this.getGlobalKeyStrokes()) {
                if (keyStroke.getKeyCode() != event.keyCode || keyStroke.getStateMask() != event.stateMask) continue;
                keyStroke.handleUiAction(event);
                if (!event.doit) break;
            }
        }
    }

    private boolean isWidgetModalDialog(Widget widget) {
        Dialog dialog;
        Object data;
        return widget instanceof Shell && (data = widget.getData()) instanceof Dialog && ((dialog = (Dialog)data).getShell().getStyle() & 0x10000) == 65536;
    }

    private void handleKeyEventHierarchical(Event event, Widget widget) {
        if (widget == null || widget.isDisposed()) {
            return;
        }
        for (IRwtKeyStroke keyStroke : this.getKeyStrokes(widget)) {
            if (!RwtUtility.getKeyTextUpper(event.keyCode).equals(RwtUtility.getKeyTextUpper(keyStroke.getKeyCode())) || keyStroke.getStateMask() != event.stateMask) continue;
            keyStroke.handleUiAction(event);
            if (event.doit) continue;
            return;
        }
        if (this.isWidgetModalDialog(widget)) {
            event.doit = false;
            return;
        }
        if (widget instanceof Control) {
            this.handleKeyEventHierarchical(event, (Widget)((Control)widget).getParent());
        }
    }

    private class P_KeyEventHandler
    implements Runnable {
        private Map<CompositeObject, List<Event>> m_eventListMap = null;

        private P_KeyEventHandler() {
        }

        public void addEvent(KeyEvent e) {
            Event eventCopy = new Event();
            eventCopy.character = e.character;
            eventCopy.data = e.data;
            eventCopy.display = e.display;
            eventCopy.doit = e.doit;
            eventCopy.keyCode = e.keyCode;
            eventCopy.stateMask = e.stateMask;
            eventCopy.widget = e.widget;
            this.addEventInternal(eventCopy);
        }

        public void addEvent(Event e) {
            Event eventCopy = new Event();
            eventCopy.button = e.button;
            eventCopy.character = e.character;
            eventCopy.count = e.count;
            eventCopy.data = e.data;
            eventCopy.detail = e.detail;
            eventCopy.display = e.display;
            eventCopy.doit = e.doit;
            eventCopy.end = e.end;
            eventCopy.gc = e.gc;
            eventCopy.height = e.height;
            eventCopy.index = e.index;
            eventCopy.item = e.item;
            eventCopy.keyCode = e.keyCode;
            eventCopy.start = e.start;
            eventCopy.stateMask = e.stateMask;
            eventCopy.text = e.text;
            eventCopy.time = e.time;
            eventCopy.type = e.type;
            eventCopy.widget = e.widget;
            eventCopy.width = e.width;
            eventCopy.x = e.x;
            eventCopy.y = e.y;
            this.addEventInternal(eventCopy);
        }

        private void addEventInternal(Event e) {
            CompositeObject key = new CompositeObject(new Object[]{e.keyCode, e.stateMask});
            List eventList = (List)CollectionUtility.getObject(this.m_eventListMap, (Object)key);
            eventList = CollectionUtility.appendList((List)eventList, (Object)e);
            this.m_eventListMap = CollectionUtility.putObject(this.m_eventListMap, (Object)key, (Object)eventList);
        }

        @Override
        public void run() {
            CompositeObject[] keys;
            CompositeObject[] compositeObjectArray = keys = (CompositeObject[])CollectionUtility.getKeyArray(this.m_eventListMap, CompositeObject.class);
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                CompositeObject key = compositeObjectArray[n2];
                List eventList = (List)CollectionUtility.getObject(this.m_eventListMap, (Object)key);
                boolean doit = true;
                Iterator iterator = eventList.iterator();
                while (iterator.hasNext()) {
                    Event event = (Event)iterator.next();
                    iterator.remove();
                    event.doit = doit;
                    KeyStrokeManager.this.handleKeyEvent(event);
                    doit = event.doit;
                }
                this.m_eventListMap = CollectionUtility.putObject(this.m_eventListMap, (Object)key, (Object)eventList);
                ++n2;
            }
        }
    }
}

