/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.desktop;

import java.util.EventListener;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.window.desktop.IViewTabSelectionListener;
import org.eclipse.scout.rt.ui.rap.window.desktop.ViewTabSelectionEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ViewStackTabButton
extends Composite {
    private static final long serialVersionUID = 1L;
    private static final String VARIANT_ACIVATE_BUTTON = "formTabActivate";
    private static final String VARIANT_ACIVATE_BUTTON_ACTIVE = "formTabActivate-active";
    private static final String VARIANT_FORM_CLOSE_BUTTON = "formTabClose";
    private static final String VARIANT_TAB = "formTab";
    private static final String VARIANT_TAB_ACTIVE = "formTab-active";
    private Button m_activateButton;
    private Button m_closeButton;
    private EventListenerList m_eventListeners = new EventListenerList();
    private boolean m_closable = false;
    private boolean m_active = false;

    public ViewStackTabButton(Composite parent) {
        super(parent, 0);
        this.createContent(this);
        this.setData("org.eclipse.rwt.themeVariant", VARIANT_TAB);
    }

    private IRwtEnvironment getUiEnvironment() {
        return (IRwtEnvironment)this.getDisplay().getData(IRwtEnvironment.class.getName());
    }

    protected void createContent(Composite parent) {
        this.m_activateButton = this.getUiEnvironment().getFormToolkit().createButton(parent, "", 8);
        this.m_activateButton.setData("org.eclipse.rwt.themeVariant", (Object)VARIANT_ACIVATE_BUTTON_ACTIVE);
        this.m_activateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                ViewStackTabButton.this.fireViewTabEvent(new ViewTabSelectionEvent(ViewStackTabButton.this, 1));
            }
        });
        this.m_closeButton = this.getUiEnvironment().getFormToolkit().createButton(parent, "", 8);
        this.m_closeButton.setData("org.eclipse.rwt.themeVariant", (Object)VARIANT_FORM_CLOSE_BUTTON);
        this.m_closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                ViewStackTabButton.this.fireViewTabEvent(new ViewTabSelectionEvent(ViewStackTabButton.this, 2));
            }
        });
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        GridData activateButtonData = new GridData();
        activateButtonData.horizontalAlignment = 0x1000000;
        activateButtonData.verticalAlignment = 0x1000000;
        this.m_activateButton.setLayoutData((Object)activateButtonData);
        GridData closeButtonData = new GridData();
        closeButtonData.horizontalAlignment = 0x1000000;
        closeButtonData.verticalAlignment = 0x1000000;
        closeButtonData.heightHint = 12;
        closeButtonData.widthHint = 12;
        this.m_closeButton.setLayoutData((Object)closeButtonData);
    }

    public void setActive(boolean active) {
        this.m_active = active;
        this.updateStylesAndButtons();
    }

    private void updateStylesAndButtons() {
        if (this.m_active) {
            this.setData("org.eclipse.rwt.themeVariant", VARIANT_TAB_ACTIVE);
            this.m_activateButton.setData("org.eclipse.rwt.themeVariant", (Object)VARIANT_ACIVATE_BUTTON_ACTIVE);
        } else {
            this.setData("org.eclipse.rwt.themeVariant", VARIANT_TAB);
            this.m_activateButton.setData("org.eclipse.rwt.themeVariant", (Object)VARIANT_ACIVATE_BUTTON);
        }
        GridData closeButtonData = (GridData)this.m_closeButton.getLayoutData();
        if (this.m_active && this.m_closable) {
            this.m_closeButton.setVisible(true);
            closeButtonData.exclude = false;
        } else {
            this.m_closeButton.setVisible(false);
            closeButtonData.exclude = true;
        }
        this.layout(true);
    }

    public void setLabel(String label) {
        this.m_activateButton.setText(label);
        this.getParent().layout();
    }

    public String getLabel() {
        return this.m_activateButton.getText();
    }

    public void setImage(Image img) {
        this.m_activateButton.setImage(img);
        this.getParent().layout();
    }

    public Image getImage() {
        return this.m_activateButton.getImage();
    }

    public void setShowClose(boolean closable) {
        this.m_closable = closable;
        this.updateStylesAndButtons();
    }

    public void addViewTabListener(IViewTabSelectionListener listener) {
        this.m_eventListeners.add(IViewTabSelectionListener.class, (EventListener)listener);
    }

    public void removeViewTabListener(IViewTabSelectionListener listener) {
        this.m_eventListeners.remove(IViewTabSelectionListener.class, (EventListener)listener);
    }

    protected void fireViewTabEvent(ViewTabSelectionEvent event) {
        IViewTabSelectionListener[] iViewTabSelectionListenerArray = (IViewTabSelectionListener[])this.m_eventListeners.getListeners(IViewTabSelectionListener.class);
        int n = iViewTabSelectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewTabSelectionListener l = iViewTabSelectionListenerArray[n2];
            l.handleEvent(event);
            ++n2;
        }
    }
}

