/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.ext;

import java.util.EventListener;
import org.eclipse.rwt.widgets.FileUpload;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.ext.IDropDownFileUploadForPatch;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;

public class DropDownFileUpload
extends FileUpload
implements IDropDownFileUploadForPatch {
    private static final long serialVersionUID = 1L;
    private Rectangle m_buttonArea = new Rectangle(1, 1, 13, 17);
    private Rectangle m_dropDownArea = new Rectangle(14, 1, 10, 17);
    private EventListenerList m_eventListeners = new EventListenerList();
    private boolean m_dropdownEnabled = true;
    private boolean m_buttonEnabled = true;
    private String m_originalVariant = "";

    public DropDownFileUpload(Composite parent, int style) {
        super(parent, style | 0x20000000);
        super.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                DropDownFileUpload.this.handleSelectionInternal(e);
            }
        });
    }

    @Override
    public boolean forceFocus() {
        if ((this.getStyle() & 0x80000) != 0) {
            return false;
        }
        return super.forceFocus();
    }

    protected void handleSelectionInternal(SelectionEvent event) {
        this.fireSelectionEvent(event);
    }

    protected Menu createMenu() {
        Menu contextMenu = this.getMenu();
        if (this.getMenu() == null) {
            contextMenu = new Menu((Decorations)this.getShell(), 8);
            MenuListener[] menuListenerArray = (MenuListener[])this.m_eventListeners.getListeners(MenuListener.class);
            int n = menuListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuListener listener = menuListenerArray[n2];
                contextMenu.addMenuListener(listener);
                ++n2;
            }
            this.setMenu(contextMenu);
        }
        return contextMenu;
    }

    @Override
    public void fireSelectionEvent(SelectionEvent e) {
        if (this.isButtonEnabled()) {
            SelectionListener[] selectionListenerArray = (SelectionListener[])this.m_eventListeners.getListeners(SelectionListener.class);
            int n = selectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SelectionListener l = selectionListenerArray[n2];
                l.widgetSelected(e);
                ++n2;
            }
        }
    }

    @Override
    public void addSelectionListener(SelectionListener listener) {
        this.m_eventListeners.add(SelectionListener.class, (EventListener)listener);
    }

    @Override
    public void removeSelectionListener(SelectionListener listener) {
        this.m_eventListeners.remove(SelectionListener.class, (EventListener)listener);
    }

    @Override
    public void addMenuListener(MenuListener listener) {
        this.m_eventListeners.add(MenuListener.class, (EventListener)listener);
    }

    @Override
    public void removeMenuListener(MenuListener listener) {
        this.m_eventListeners.remove(MenuListener.class, (EventListener)listener);
    }

    @Override
    public void setDropdownEnabled(boolean enabled) {
        this.m_dropdownEnabled = enabled;
        if (!StringUtility.hasText((String)this.m_originalVariant)) {
            this.m_originalVariant = (String)this.getData("org.eclipse.rwt.themeVariant");
        }
        String customVariant = this.m_dropdownEnabled ? String.valueOf(this.m_originalVariant) + "_menu" : this.m_originalVariant;
        this.setData("org.eclipse.rwt.themeVariant", customVariant);
        super.setEnabled(this.isButtonEnabled());
    }

    @Override
    public boolean isDropdownEnabled() {
        return this.m_dropdownEnabled;
    }

    @Override
    public void setButtonEnabled(boolean enabled) {
        this.m_buttonEnabled = enabled;
        super.setEnabled(this.isButtonEnabled());
    }

    @Override
    public boolean isButtonEnabled() {
        return this.m_buttonEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_buttonEnabled = enabled;
        this.m_dropdownEnabled = enabled;
    }

    protected void checkSubclass() {
    }

    private IRwtEnvironment getUiEnvironment() {
        return (IRwtEnvironment)this.getDisplay().getData(IRwtEnvironment.class.getName());
    }
}

