/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.ext.gc;

import java.util.Arrays;
import org.eclipse.scout.rt.ui.rap.ext.gc.Transform;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class AdvancedGC {
    private GC m_gc;
    private Transform m_txRef;
    private final float[] m_matrix = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};

    public AdvancedGC(GC gc) {
        this.m_gc = gc;
    }

    public void setTransform(Transform t) {
        this.m_txRef = t;
        if (this.m_txRef != null) {
            this.m_txRef.getElements(this.m_matrix);
        } else {
            Arrays.fill(this.m_matrix, 0.0f);
            this.m_matrix[0] = 1.0f;
            this.m_matrix[3] = 1.0f;
        }
    }

    public Transform getTransform() {
        return this.m_txRef;
    }

    public boolean isDisposed() {
        return this.m_gc.isDisposed();
    }

    public void dispose() {
        this.m_gc.dispose();
    }

    public void setBackground(Color c) {
        this.m_gc.setBackground(c);
    }

    public void setForeground(Color c) {
        this.m_gc.setForeground(c);
    }

    public void setFont(Font f) {
        this.m_gc.setFont(f);
    }

    public void setAlpha(int alpha) {
        this.m_gc.setAlpha(alpha);
    }

    public void drawOval(int x, int y, int w, int h) {
        this.m_gc.drawOval(this.tx(x), this.ty(y), this.tw(w), this.th(h));
    }

    public void drawRectangle(int x, int y, int w, int h) {
        this.m_gc.drawRectangle(this.tx(x), this.ty(y), this.tw(w), this.th(h));
    }

    public void drawPolygon(int[] pointArray) {
        int[] p = new int[pointArray.length];
        int i = 0;
        while (i < p.length) {
            p[i] = this.tx(pointArray[i]);
            p[i + 1] = this.ty(pointArray[i + 1]);
            i += 2;
        }
        this.m_gc.drawPolygon(p);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        this.m_gc.drawImage(image, srcX, srcY, srcWidth, srcHeight, this.tx(destX), this.ty(destY), this.tw(destWidth), this.th(destHeight));
    }

    public void drawString(String s, int x, int y, boolean transparent) {
        this.m_gc.drawString(s, this.tx(x), this.ty(y), transparent);
    }

    public void fillOval(int x, int y, int w, int h) {
        this.m_gc.fillOval(this.tx(x), this.ty(y), this.tw(w), this.th(h));
    }

    public void fillRectangle(int x, int y, int w, int h) {
        this.m_gc.fillRectangle(this.tx(x), this.ty(y), this.tw(w), this.th(h));
    }

    public void fillPolygon(int[] pointArray) {
        int[] p = new int[pointArray.length];
        int i = 0;
        while (i < p.length) {
            p[i] = this.tx(pointArray[i]);
            p[i + 1] = this.ty(pointArray[i + 1]);
            i += 2;
        }
        this.m_gc.fillPolygon(p);
    }

    private int tx(int x) {
        return (int)(this.m_matrix[0] * (float)x + this.m_matrix[4]);
    }

    private int ty(int y) {
        return (int)(this.m_matrix[3] * (float)y + this.m_matrix[5]);
    }

    private int tw(int w) {
        return (int)(this.m_matrix[0] * (float)w);
    }

    private int th(int h) {
        return (int)(this.m_matrix[3] * (float)h);
    }
}

