/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.datefield;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rwt.Adaptable;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField;
import org.eclipse.scout.rt.ui.rap.LogicalGridLayout;
import org.eclipse.scout.rt.ui.rap.ext.ButtonEx;
import org.eclipse.scout.rt.ui.rap.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.rap.ext.StyledTextEx;
import org.eclipse.scout.rt.ui.rap.form.fields.IPopupSupport;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.datefield.IRwtScoutDateField;
import org.eclipse.scout.rt.ui.rap.form.fields.datefield.chooser.DateChooserDialog;
import org.eclipse.scout.rt.ui.rap.internal.TextFieldEditableSupport;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class RwtScoutDateField
extends RwtScoutValueFieldComposite<IDateField>
implements IRwtScoutDateField,
IPopupSupport {
    private Button m_dropDownButton;
    private TextFieldEditableSupport m_editableSupport;
    private Set<IPopupSupport.IPopupSupportListener> m_popupEventListeners;
    private Object m_popupEventListenerLock;
    private boolean m_ignoreLabel = false;
    private Composite m_dateContainer;
    private boolean m_dateTimeCompositeMember;
    private String m_displayTextToVerify;
    private DateChooserDialog m_dateChooserDialog = null;
    private FocusAdapter m_textFieldFocusAdapter = null;

    @Override
    public void setIgnoreLabel(boolean ignoreLabel) {
        this.m_ignoreLabel = ignoreLabel;
        if (ignoreLabel) {
            this.getUiLabel().setVisible(false);
        } else {
            this.getUiLabel().setVisible(((IDateField)this.getScoutObject()).isLabelVisible());
        }
    }

    public boolean isIgnoreLabel() {
        return this.m_ignoreLabel;
    }

    public boolean isDateTimeCompositeMember() {
        return this.m_dateTimeCompositeMember;
    }

    @Override
    public void setDateTimeCompositeMember(boolean dateTimeCompositeMember) {
        this.m_dateTimeCompositeMember = dateTimeCompositeMember;
    }

    @Override
    protected void initializeUi(Composite parent) {
        this.m_popupEventListeners = new HashSet<IPopupSupport.IPopupSupportListener>();
        this.m_popupEventListenerLock = new Object();
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getUiEnvironment().getFormToolkit().createStatusLabel(container, (IFormField)this.getScoutObject());
        this.m_dateContainer = this.getUiEnvironment().getFormToolkit().createComposite(container, 2048);
        this.m_dateContainer.setData("org.eclipse.rwt.themeVariant", (Object)"datefield");
        StyledTextEx textField = new StyledTextEx(this.m_dateContainer, 4);
        this.getUiEnvironment().getFormToolkit().adapt((Control)textField, false, false);
        textField.setData("org.eclipse.rwt.themeVariant", "datefield");
        ButtonEx dateChooserButton = this.getUiEnvironment().getFormToolkit().createButtonEx(this.m_dateContainer, 524296);
        dateChooserButton.setData("org.eclipse.rwt.themeVariant", "datefield");
        this.m_dateContainer.setTabList(new Control[]{textField});
        container.setTabList(new Control[]{this.m_dateContainer});
        this.getUiEnvironment().addKeyStroke((Control)container, new P_DateChooserOpenKeyStroke(), false);
        this.getUiEnvironment().addKeyStroke((Control)textField, new P_ShiftDayUpKeyStroke(), false);
        this.getUiEnvironment().addKeyStroke((Control)textField, new P_ShiftDayDownKeyStroke(), false);
        this.getUiEnvironment().addKeyStroke((Control)textField, new P_ShiftMonthUpKeyStroke(), false);
        this.getUiEnvironment().addKeyStroke((Control)textField, new P_ShiftMonthDownKeyStroke(), false);
        this.getUiEnvironment().addKeyStroke((Control)textField, new P_ShiftYearUpKeyStroke(), false);
        this.getUiEnvironment().addKeyStroke((Control)textField, new P_ShiftYearDownKeyStroke(), false);
        dateChooserButton.addListener(44, new P_RwtBrowseButtonListener());
        this.attachFocusListener((Control)textField, true);
        textField.addMouseListener((MouseListener)new MouseAdapter(){
            private static final long serialVersionUID = 1L;

            public void mouseUp(MouseEvent e) {
                RwtScoutDateField.this.handleUiDateChooserAction();
            }
        });
        this.setUiContainer(container);
        this.setUiLabel(label);
        this.setDropDownButton(dateChooserButton);
        this.setUiField((Control)textField);
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
        this.m_dateContainer.setLayoutData((Object)LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData()));
        this.m_dateContainer.setLayout((Layout)RwtLayoutUtility.createGridLayoutNoSpacing(2, false));
        GridData textLayoutData = new GridData(4, 4, true, true);
        textField.setLayoutData(textLayoutData);
        GridData buttonLayoutData = new GridData(0x1000000, 0x1000000, false, false);
        buttonLayoutData.heightHint = 20;
        buttonLayoutData.widthHint = 20;
        dateChooserButton.setLayoutData(buttonLayoutData);
    }

    @Override
    public Button getDropDownButton() {
        return this.m_dropDownButton;
    }

    public void setDropDownButton(ButtonEx b) {
        this.m_dropDownButton = b;
    }

    public StyledTextEx getUiField() {
        return (StyledTextEx)super.getUiField();
    }

    public boolean isFocusInDatePicker() {
        if (this.m_dateChooserDialog == null) {
            return false;
        }
        Control focusControl = this.getUiEnvironment().getDisplay().getFocusControl();
        boolean isFocusInDatePicker = RwtUtility.isAncestorOf((Control)this.m_dateChooserDialog.getShell(), focusControl);
        return isFocusInDatePicker;
    }

    private void installFocusListenerOnTextField() {
        if (this.getUiField().isDisposed()) {
            return;
        }
        this.getUiField().setFocus();
        if (this.m_textFieldFocusAdapter == null) {
            this.m_textFieldFocusAdapter = new FocusAdapter(){
                private static final long serialVersionUID = 1L;

                public void focusLost(FocusEvent e) {
                    RwtScoutDateField.this.handleUiFocusLostOnDatePickerPopup(e);
                }
            };
        }
        this.getUiField().addFocusListener((FocusListener)this.m_textFieldFocusAdapter);
    }

    protected void handleUiFocusLostOnDatePickerPopup(FocusEvent event) {
        if (this.isFocusInDatePicker()) {
            this.getUiEnvironment().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RwtScoutDateField.this.getUiField().setFocus();
                }
            });
        } else {
            this.getUiEnvironment().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RwtScoutDateField.this.makeSureDateChooserIsClosed();
                }
            });
        }
    }

    private void uninstallFocusListenerOnTextField() {
        if (!this.getUiField().isDisposed() && this.m_textFieldFocusAdapter != null) {
            this.getUiField().removeFocusListener((FocusListener)this.m_textFieldFocusAdapter);
        }
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.m_dropDownButton.setEnabled(b);
        if (b) {
            this.m_dateContainer.setData("org.eclipse.rwt.themeVariant", (Object)"datefield");
        } else {
            this.m_dateContainer.setData("org.eclipse.rwt.themeVariant", (Object)"datefield-disabled");
        }
    }

    @Override
    protected void setLabelVisibleFromScout() {
        if (!this.isIgnoreLabel()) {
            super.setLabelVisibleFromScout();
        }
    }

    @Override
    protected void setFieldEnabled(Control rwtField, boolean enabled) {
        if (this.m_editableSupport == null) {
            this.m_editableSupport = new TextFieldEditableSupport(this.getUiField());
        }
        this.m_editableSupport.setEditable(enabled);
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        DateFormat format;
        IDateField scoutField = (IDateField)this.getScoutObject();
        if (s == null) {
            s = "";
        }
        this.m_displayTextToVerify = s;
        Date value = (Date)scoutField.getValue();
        if (value != null && (format = scoutField.getIsolatedDateFormat()) != null) {
            this.m_displayTextToVerify = format.format(value);
        }
        this.getUiField().setText(this.m_displayTextToVerify);
        this.getUiField().setCaretOffset(0);
    }

    @Override
    protected void setBackgroundFromScout(String scoutColor) {
        this.setBackgroundFromScout(scoutColor, (Control)this.m_dateContainer);
    }

    @Override
    protected void handleUiInputVerifier(boolean doit) {
        if (!doit) {
            return;
        }
        final String text = this.getUiField().getText();
        if (CompareUtility.equals((Object)text, (Object)this.m_displayTextToVerify) && (this.isDateTimeCompositeMember() || ((IDateField)this.getScoutObject()).getErrorStatus() == null)) {
            return;
        }
        this.m_displayTextToVerify = text;
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IDateField)RwtScoutDateField.this.getScoutObject()).getUIFacade().setDateTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getUiEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {}
        this.getUiEnvironment().dispatchImmediateUiJobs();
    }

    @Override
    protected void handleUiFocusGained() {
        if (this.isSelectAllOnFocusEnabled()) {
            this.getUiField().setSelection(0, this.getUiField().getText().length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPopupEventListeners(int eventType) {
        IPopupSupport.IPopupSupportListener[] listeners;
        Object object = this.m_popupEventListenerLock;
        synchronized (object) {
            listeners = this.m_popupEventListeners.toArray(new IPopupSupport.IPopupSupportListener[this.m_popupEventListeners.size()]);
        }
        IPopupSupport.IPopupSupportListener[] iPopupSupportListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPopupSupport.IPopupSupportListener listener = iPopupSupportListenerArray[n2];
            listener.handleEvent(eventType);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPopupEventListener(IPopupSupport.IPopupSupportListener listener) {
        Object object = this.m_popupEventListenerLock;
        synchronized (object) {
            this.m_popupEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePopupEventListener(IPopupSupport.IPopupSupportListener listener) {
        Object object = this.m_popupEventListenerLock;
        synchronized (object) {
            this.m_popupEventListeners.remove(listener);
        }
    }

    protected void makeSureDateChooserIsClosed() {
        if (this.m_dateChooserDialog != null && this.m_dateChooserDialog.getShell() != null && !this.m_dateChooserDialog.getShell().isDisposed()) {
            this.m_dateChooserDialog.getShell().close();
        }
        this.uninstallFocusListenerOnTextField();
    }

    private void handleUiDateChooserAction() {
        if (!this.getDropDownButton().isVisible() || !this.getDropDownButton().isEnabled()) {
            return;
        }
        Date oldDate = (Date)((IDateField)this.getScoutObject()).getValue();
        if (oldDate == null) {
            oldDate = new Date();
        }
        this.notifyPopupEventListeners(2);
        this.makeSureDateChooserIsClosed();
        this.m_dateChooserDialog = this.createDateChooserDialog(this.getUiField().getShell(), oldDate);
        if (this.m_dateChooserDialog != null) {
            this.m_dateChooserDialog.getShell().addDisposeListener(new DisposeListener(){
                private static final long serialVersionUID = 1L;

                public void widgetDisposed(DisposeEvent event) {
                    RwtScoutDateField.this.getDateFromClosedDateChooserDialog();
                    RwtScoutDateField.this.m_dateChooserDialog = null;
                }
            });
            this.m_dateChooserDialog.openDateChooser((Control)this.getUiField());
            this.installFocusListenerOnTextField();
        }
    }

    protected DateChooserDialog createDateChooserDialog(Shell parentShell, Date currentDate) {
        return new DateChooserDialog(parentShell, currentDate);
    }

    private void getDateFromClosedDateChooserDialog() {
        this.removeListenersFromDateChooserDialog();
        boolean setFocusToUiField = false;
        try {
            final Date newDate = this.m_dateChooserDialog.getReturnDate();
            if (newDate != null) {
                setFocusToUiField = true;
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ((IDateField)RwtScoutDateField.this.getScoutObject()).getUIFacade().setDateFromUI(newDate);
                    }
                };
                this.getUiEnvironment().invokeScoutLater(t, 0L);
            }
        }
        finally {
            this.notifyPopupEventListeners(4);
            this.uninstallFocusListenerOnTextField();
            if (setFocusToUiField && !this.getUiField().isDisposed()) {
                this.getUiField().setFocus();
            }
        }
    }

    private void removeListenersFromDateChooserDialog() {
        Object[] disposeListeners;
        Object[] shellListeners;
        Object[] objectArray = shellListeners = ShellEvent.getListeners((Adaptable)this.m_dateChooserDialog.getShell());
        int n = shellListeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object.getClass().isInstance(this) || object.getClass().getEnclosingClass() != null && object.getClass().getEnclosingClass().isInstance(this)) {
                this.m_dateChooserDialog.getShell().removeShellListener((ShellListener)object);
            }
            ++n2;
        }
        Object[] objectArray2 = disposeListeners = DisposeEvent.getListeners((Adaptable)this.m_dateChooserDialog.getShell());
        int n3 = disposeListeners.length;
        n = 0;
        while (n < n3) {
            Object object = objectArray2[n];
            if (object.getClass().isInstance(this) || object.getClass().getEnclosingClass() != null && object.getClass().getEnclosingClass().isInstance(this)) {
                this.m_dateChooserDialog.getShell().removeDisposeListener((DisposeListener)object);
            }
            ++n;
        }
    }

    private void shiftDate(final int level, final int value) {
        if (this.getUiField().isDisposed()) {
            return;
        }
        if (this.getUiField().isEnabled() && this.getUiField().getEditable() && this.getUiField().isVisible() && level >= 0) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((IDateField)RwtScoutDateField.this.getScoutObject()).getUIFacade().fireDateShiftActionFromUI(level, value);
                }
            };
            this.getUiEnvironment().invokeScoutLater(t, 0L);
        }
    }

    private class P_DateChooserOpenKeyStroke
    extends RwtKeyStroke {
        public P_DateChooserOpenKeyStroke() {
            super(0x100000B);
        }

        @Override
        public void handleUiAction(Event e) {
            RwtScoutDateField.this.handleUiDateChooserAction();
        }
    }

    private class P_RwtBrowseButtonListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        public void handleEvent(Event event) {
            switch (event.type) {
                case 44: {
                    RwtScoutDateField.this.getUiField().forceFocus();
                    RwtScoutDateField.this.handleUiDateChooserAction();
                    break;
                }
            }
        }
    }

    private class P_ShiftDayDownKeyStroke
    extends RwtKeyStroke {
        public P_ShiftDayDownKeyStroke() {
            super(0x1000002);
        }

        @Override
        public void handleUiAction(Event e) {
            int level = 0;
            int value = -1;
            RwtScoutDateField.this.shiftDate(level, value);
        }
    }

    private class P_ShiftDayUpKeyStroke
    extends RwtKeyStroke {
        public P_ShiftDayUpKeyStroke() {
            super(0x1000001);
        }

        @Override
        public void handleUiAction(Event e) {
            int level = 0;
            int value = 1;
            RwtScoutDateField.this.shiftDate(level, value);
        }
    }

    private class P_ShiftMonthDownKeyStroke
    extends RwtKeyStroke {
        public P_ShiftMonthDownKeyStroke() {
            super(0x1000002, 131072);
        }

        @Override
        public void handleUiAction(Event e) {
            int level = 1;
            int value = -1;
            RwtScoutDateField.this.shiftDate(level, value);
        }
    }

    private class P_ShiftMonthUpKeyStroke
    extends RwtKeyStroke {
        public P_ShiftMonthUpKeyStroke() {
            super(0x1000001, 131072);
        }

        @Override
        public void handleUiAction(Event e) {
            int level = 1;
            int value = 1;
            RwtScoutDateField.this.shiftDate(level, value);
        }
    }

    private class P_ShiftYearDownKeyStroke
    extends RwtKeyStroke {
        public P_ShiftYearDownKeyStroke() {
            super(0x1000002, 262144);
        }

        @Override
        public void handleUiAction(Event e) {
            int level = 2;
            int value = -1;
            RwtScoutDateField.this.shiftDate(level, value);
        }
    }

    private class P_ShiftYearUpKeyStroke
    extends RwtKeyStroke {
        public P_ShiftYearUpKeyStroke() {
            super(0x1000001, 262144);
        }

        @Override
        public void handleUiAction(Event e) {
            int level = 2;
            int value = 1;
            RwtScoutDateField.this.shiftDate(level, value);
        }
    }
}

