/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.tabbox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.RunnableWithData;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.ui.rap.form.fields.RwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.rap.form.fields.tabbox.IRwtScoutTabBox;
import org.eclipse.scout.rt.ui.rap.form.fields.tabbox.RwtScoutTabItem;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class RwtScoutTabBox
extends RwtScoutFieldComposite<ITabBox>
implements IRwtScoutTabBox {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutTabBox.class);
    private HashMap<Composite, RwtScoutTabItem> m_tabs;
    private Listener m_uiTabFocusListener;
    private P_TabListener m_tabListener = new P_TabListener();
    private OptimisticLock m_selectedTabLock;
    private OptimisticLock m_rebuildItemsLock = new OptimisticLock();
    private Composite m_tabboxButtonbar;
    private StackLayout m_stackLayout;
    private Composite m_tabboxContainer;
    private RwtScoutTabItem m_focusedItem;

    public RwtScoutTabBox() {
        this.m_selectedTabLock = new OptimisticLock();
    }

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent, 128);
        container.setData("org.eclipse.rwt.themeVariant", (Object)"tabboxContainer");
        this.m_tabboxButtonbar = this.createTabboxButtonBar(container);
        this.m_tabboxContainer = this.getUiEnvironment().getFormToolkit().createComposite(container, 0);
        container.setLayout((Layout)RwtLayoutUtility.createGridLayoutNoSpacing(1, false));
        GridData tabboxButtonBarLayoutdata = new GridData(552);
        this.m_tabboxButtonbar.setLayoutData((Object)tabboxButtonBarLayoutdata);
        this.m_tabboxContainer.setLayoutData((Object)new GridData(1808));
        this.m_stackLayout = new StackLayout();
        this.m_tabboxContainer.setLayout((Layout)this.m_stackLayout);
        this.setUiLabel(null);
        this.setUiField((Control)this.m_tabboxContainer);
        this.setUiContainer(container);
        IGroupBox[] iGroupBoxArray = ((ITabBox)this.getScoutObject()).getGroupBoxes();
        int n = iGroupBoxArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGroupBox box = iGroupBoxArray[n2];
            box.addPropertyChangeListener((PropertyChangeListener)this.m_tabListener);
            ++n2;
        }
        this.rebuildItems();
        if (this.m_uiTabFocusListener == null) {
            this.m_uiTabFocusListener = new P_RwtFocusListener();
        }
        this.m_tabboxContainer.addListener(15, this.m_uiTabFocusListener);
        this.m_tabboxContainer.addListener(16, this.m_uiTabFocusListener);
    }

    protected Composite createTabboxButtonBar(Composite parent) {
        Composite tabboxButtonBar = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        tabboxButtonBar.setData("org.eclipse.rwt.themeVariant", (Object)"tabboxContainer");
        RowLayout layout = new RowLayout(256);
        layout.marginBottom = 0;
        layout.marginTop = 5;
        layout.marginLeft = 10;
        tabboxButtonBar.setLayout((Layout)layout);
        return tabboxButtonBar;
    }

    @Override
    protected void disposeImpl() {
        super.disposeImpl();
        if (this.m_tabboxButtonbar != null && !this.m_tabboxButtonbar.isDisposed()) {
            this.m_tabboxButtonbar.dispose();
            this.m_tabboxButtonbar = null;
        }
    }

    protected void rebuildItems() {
        try {
            this.m_rebuildItemsLock.acquire();
            this.getUiContainer().setRedraw(false);
            if (this.m_tabs != null) {
                for (RwtScoutTabItem item : this.m_tabs.values()) {
                    item.dispose();
                }
            }
            this.m_tabs = new HashMap();
            LinkedList<RwtScoutTabItem> tabList = new LinkedList<RwtScoutTabItem>();
            IGroupBox[] iGroupBoxArray = ((ITabBox)this.getScoutObject()).getGroupBoxes();
            int n = iGroupBoxArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGroupBox box = iGroupBoxArray[n2];
                if (box.isVisible()) {
                    RwtScoutTabItem item = new RwtScoutTabItem((ITabBox)this.getScoutObject(), this.m_tabboxButtonbar, this.m_tabboxContainer, "tabboxButton", "tabboxButton-active", "tabboxButton-marked", "tabboxButton-active-marked");
                    item.createUiField(this.getUiField(), box, this.getUiEnvironment());
                    this.m_tabs.put(item.getTabItem(), item);
                    tabList.add(item);
                }
                ++n2;
            }
            if (tabList.size() > 0) {
                RwtScoutTabItem previousItem = null;
                for (RwtScoutTabItem curItem : tabList) {
                    if (previousItem != null) {
                        curItem.setPreviousTabItem(previousItem);
                        previousItem.setNextTabItem(curItem);
                    }
                    previousItem = curItem;
                }
                RwtScoutTabItem firstItem = (RwtScoutTabItem)tabList.getFirst();
                RwtScoutTabItem lastItem = (RwtScoutTabItem)tabList.getLast();
                firstItem.setPreviousTabItem(lastItem);
                lastItem.setNextTabItem(firstItem);
            }
            this.setSelectedTabFromScout();
        }
        finally {
            this.getUiContainer().setRedraw(true);
            this.m_rebuildItemsLock.release();
        }
    }

    public Composite getUiField() {
        return (Composite)super.getUiField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setSelectedTabFromScout();
    }

    @Override
    protected void detachScout() {
        IGroupBox[] iGroupBoxArray = ((ITabBox)this.getScoutObject()).getGroupBoxes();
        int n = iGroupBoxArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGroupBox b = iGroupBoxArray[n2];
            b.removePropertyChangeListener((PropertyChangeListener)this.m_tabListener);
            ++n2;
        }
        super.detachScout();
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
    }

    protected void setSelectedTabFromScout() {
        try {
            this.m_selectedTabLock.acquire();
            IGroupBox selectedTab = ((ITabBox)this.getScoutObject()).getSelectedTab();
            Composite foundItem = null;
            for (Map.Entry<Composite, RwtScoutTabItem> e : this.m_tabs.entrySet()) {
                IGroupBox test = (IGroupBox)e.getValue().getScoutObject();
                if (test != selectedTab) continue;
                foundItem = e.getKey();
                break;
            }
            if (foundItem != null) {
                this.m_stackLayout.topControl = foundItem;
                this.m_tabboxContainer.layout();
                this.m_focusedItem = this.m_tabs.get(foundItem);
                this.m_focusedItem.setUiFocus();
                this.m_tabboxButtonbar.layout();
            }
        }
        finally {
            this.m_selectedTabLock.release();
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("selectedTab")) {
            this.setSelectedTabFromScout();
        }
    }

    private class P_RwtFocusListener
    implements Listener {
        private static final long serialVersionUID = 1L;

        private P_RwtFocusListener() {
        }

        public void handleEvent(Event event) {
            RwtScoutTabItem item = (RwtScoutTabItem)RwtScoutTabBox.this.m_tabs.get(((RwtScoutTabBox)RwtScoutTabBox.this).m_stackLayout.topControl);
            switch (event.type) {
                case 16: {
                    if (RwtScoutTabBox.this.m_focusedItem == null) break;
                    RwtScoutTabBox.this.m_focusedItem = null;
                    break;
                }
                case 15: {
                    if (!item.setUiFocus()) break;
                    RwtScoutTabBox.this.m_focusedItem = item;
                    break;
                }
            }
        }
    }

    private class P_TabListener
    implements PropertyChangeListener {
        private P_TabListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("visible")) {
                try {
                    if (RwtScoutTabBox.this.m_rebuildItemsLock.acquire()) {
                        RunnableWithData t = new RunnableWithData(){

                            public void run() {
                                RwtScoutTabBox.this.rebuildItems();
                            }
                        };
                        RwtScoutTabBox.this.getUiEnvironment().invokeUiLater((Runnable)t);
                    }
                }
                finally {
                    RwtScoutTabBox.this.m_rebuildItemsLock.release();
                }
            }
        }
    }
}

