/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.login.internal;

import org.eclipse.scout.rt.ui.rap.login.internal.AuthStatus;
import org.eclipse.scout.rt.ui.rap.login.internal.InternalNetAuthenticator;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoginDialog
extends Dialog {
    private static final long serialVersionUID = 1L;
    private AuthStatus m_status;
    private Button m_saveCheckbox;
    private Button m_okButton;

    public LoginDialog(Shell parent, int style, AuthStatus status) {
        super(parent, style | 0x860 | 0x10000);
        this.setText(RwtUtility.getNlsText(Display.getCurrent(), "Login", new String[0]));
        this.m_status = status;
    }

    public void open() {
        Shell parent = this.getParent();
        parent.setText(this.getText());
        this.createContents(parent);
        this.updateOkButton();
        parent.setLocation(parent.getBounds().width / 2, parent.getBounds().height / 2);
        parent.pack();
        parent.open();
        Display display = this.getParent().getDisplay();
        while (!parent.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createContents(final Shell parent) {
        GridLayout gridLayout = new GridLayout(3, true);
        gridLayout.marginLeft = 10;
        gridLayout.marginRight = 10;
        gridLayout.marginTop = 10;
        gridLayout.marginBottom = 10;
        gridLayout.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)gridLayout);
        Label urlLabel = new Label((Composite)parent, 0);
        GridData data = new GridData(128);
        data.horizontalSpan = 1;
        urlLabel.setLayoutData((Object)data);
        Label url = new Label((Composite)parent, 0);
        data = new GridData(800);
        data.horizontalSpan = 2;
        data.widthHint = 120;
        url.setLayoutData((Object)data);
        if (this.m_status.isProxy()) {
            url.setText("PROXY " + this.m_status.getUrl().getHost());
        } else {
            url.setText(this.m_status.getUrl().getHost());
        }
        Label userLabel = new Label((Composite)parent, 0);
        userLabel.setText(RwtUtility.getNlsText(Display.getCurrent(), "Username", new String[0]));
        data = new GridData(128);
        data.horizontalSpan = 1;
        userLabel.setLayoutData((Object)data);
        final Text user = new Text((Composite)parent, 2048);
        data = new GridData(800);
        data.horizontalSpan = 2;
        data.widthHint = 120;
        user.setLayoutData((Object)data);
        if (this.m_status.getUsername() != null) {
            user.setText(this.m_status.getUsername());
        }
        user.addModifyListener(new ModifyListener(){
            private static final long serialVersionUID = 1L;

            public void modifyText(ModifyEvent e) {
                LoginDialog.this.m_status.setUsername(user.getText());
                LoginDialog.this.updateOkButton();
            }
        });
        Label passLabel = new Label((Composite)parent, 0);
        passLabel.setText(RwtUtility.getNlsText(Display.getCurrent(), "Password", new String[0]));
        data = new GridData(128);
        data.horizontalSpan = 1;
        passLabel.setLayoutData((Object)data);
        final Text pass = new Text((Composite)parent, 0x400800);
        data = new GridData(800);
        data.horizontalSpan = 2;
        data.widthHint = 120;
        pass.setLayoutData((Object)data);
        if (this.m_status.getPassword() != null) {
            pass.setText(this.m_status.getPassword());
        }
        pass.addModifyListener(new ModifyListener(){
            private static final long serialVersionUID = 1L;

            public void modifyText(ModifyEvent e) {
                LoginDialog.this.m_status.setPassword(pass.getText());
                LoginDialog.this.updateOkButton();
            }
        });
        if (InternalNetAuthenticator.NET_AUTHENTICATION_CACHE_ENABLED) {
            Label saveLabel = new Label((Composite)parent, 0);
            data = new GridData(128);
            data.horizontalSpan = 1;
            saveLabel.setLayoutData((Object)data);
            this.m_saveCheckbox = new Button((Composite)parent, 32);
            this.m_saveCheckbox.setText(RwtUtility.getNlsText(Display.getCurrent(), "SavePassword", new String[0]));
            this.m_saveCheckbox.setSelection(false);
            this.m_saveCheckbox.setVisible(this.m_status.isAllowSavePassword());
            data = new GridData(800);
            data.horizontalSpan = 2;
            data.widthHint = 120;
            this.m_saveCheckbox.setLayoutData((Object)data);
        }
        this.m_okButton = new Button((Composite)parent, 8);
        this.m_okButton.setText(RwtUtility.getNlsText(Display.getCurrent(), "Ok", new String[0]));
        data = new GridData(132);
        data.horizontalSpan = 2;
        data.widthHint = 60;
        this.m_okButton.setLayoutData((Object)data);
        this.m_okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                if (LoginDialog.this.m_saveCheckbox != null) {
                    LoginDialog.this.m_status.setSavePassword(LoginDialog.this.m_saveCheckbox.getSelection());
                }
                LoginDialog.this.m_status.setOk();
                LoginDialog.this.m_status = null;
                parent.close();
            }
        });
        this.m_okButton.setEnabled(false);
        Button cancel = new Button((Composite)parent, 8);
        cancel.setText(RwtUtility.getNlsText(Display.getCurrent(), "Cancel", new String[0]));
        data = new GridData(132);
        data.horizontalSpan = 1;
        data.widthHint = 60;
        cancel.setLayoutData((Object)data);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                LoginDialog.this.m_status.setCancel();
                LoginDialog.this.m_status = null;
                parent.close();
            }
        });
        parent.setDefaultButton(this.m_okButton);
    }

    private void updateOkButton() {
        if (this.m_status.getUsername() != null && this.m_status.getUsername().length() > 0 && this.m_status.getPassword() != null && this.m_status.getPassword().length() > 0) {
            this.m_okButton.setEnabled(true);
        } else {
            this.m_okButton.setEnabled(false);
        }
    }
}

