/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.util;

import java.util.regex.Pattern;

public final class HtmlTextUtility {
    private static final Pattern htmlMarkupIdentifierPattern = Pattern.compile("<html[^>]*>(.*)</html>.*", 34);
    private static final Pattern htmlBracketPattern = Pattern.compile("<html[^>]*>(.*)</html>", 34);
    private static final Pattern headBracketPattern = Pattern.compile("<head[^>]*>(.*)</head>", 34);
    private static final Pattern bodyBracketPattern = Pattern.compile("<body[^>]*>(.*)</body>", 34);
    private static final Pattern breakingTagsPattern = Pattern.compile("(<br>|<br/>|<p[^>]*>|<p[^>]*/>|</p>|</tr>|<ul[^>]*>|</ul>|<ol[^>]*>|</ol>|</li>)", 34);
    private static final Pattern allTagsPattern = Pattern.compile("(<[^>]+>)", 34);

    public static boolean isTextWithHtmlMarkup(String text) {
        return text != null && htmlMarkupIdentifierPattern.matcher(text).matches();
    }

    public static String transformMarkupTextToHtml(String markupText) {
        if (markupText == null) {
            return null;
        }
        String s = markupText.trim();
        boolean replaceNewlines = !HtmlTextUtility.isTextWithHtmlMarkup(s);
        s = htmlBracketPattern.matcher(s).replaceAll("$1");
        s = headBracketPattern.matcher(s).replaceAll("");
        s = bodyBracketPattern.matcher(s).replaceAll("$1");
        s = s.trim();
        if (replaceNewlines) {
            s = s.replaceAll("[\\n]", "<br/>");
        }
        return s;
    }

    public static String transformPlainTextToHtml(String plainText) {
        if (plainText == null) {
            return null;
        }
        String s = plainText;
        s = s.replaceAll("[&]", "&amp;");
        s = s.replaceAll("[\"]", "&quot;");
        s = s.replaceAll("[']", "&#39;");
        s = s.replaceAll("[<]", "&lt;");
        s = s.replaceAll("[>]", "&gt;");
        s = s.replaceAll("[\\n]", "<br/>");
        s = s.replaceAll("[\\s]", "&nbsp;");
        return s;
    }

    public static String transformHtmlToPlainText(String htmlText) {
        if (htmlText == null) {
            return null;
        }
        String s = htmlText;
        s = s.replaceAll("[\\n\\r]+", " ");
        s = breakingTagsPattern.matcher(s).replaceAll("\n");
        s = allTagsPattern.matcher(s).replaceAll(" ");
        s = s.replaceAll("[ ][ ]+", " ");
        s = s.trim();
        return s;
    }

    public static int countLineBreaks(String htmlText) {
        if (htmlText == null || htmlText.length() == 0) {
            return 0;
        }
        int l = 1;
        int pos = 0;
        while ((pos = htmlText.indexOf(10, pos)) >= 0) {
            ++l;
            ++pos;
        }
        pos = 0;
        while ((pos = htmlText.indexOf("<br/>", pos)) >= 0) {
            ++l;
            ++pos;
        }
        return l;
    }

    public static int countHtmlTableRows(String htmlText) {
        if (htmlText == null || htmlText.length() == 0) {
            return 0;
        }
        int r = 0;
        int pos = 0;
        while ((pos = htmlText.indexOf("<tr>", pos)) >= 0) {
            ++r;
            ++pos;
        }
        return r;
    }
}

