/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.desktop.nonmodalFormBar;

import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.window.desktop.nonmodalFormBar.IRwtScoutFormButtonForPatch;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RwtScoutFormButton
extends RwtScoutComposite<IAction>
implements IRwtScoutFormButtonForPatch {
    private final boolean m_iconVisible;
    private final boolean m_textVisible;
    private String m_variantInActive;
    private String m_variantActive;

    public RwtScoutFormButton(boolean textVisible, boolean iconVisible, String variantInActive, String variantActive) {
        this.m_textVisible = textVisible;
        this.m_iconVisible = iconVisible;
        this.m_variantActive = variantActive;
        this.m_variantInActive = variantInActive;
    }

    @Override
    protected void initializeUi(Composite parent) {
        Button tabButton = this.getUiEnvironment().getFormToolkit().createButton(parent, "", 2);
        tabButton.setData("org.eclipse.rwt.themeVariant", (Object)this.m_variantInActive);
        this.setUiField((Control)tabButton);
        this.makeButtonActive();
        tabButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                RwtScoutFormButton.this.handleUiSelection();
            }
        });
    }

    @Override
    public void makeButtonActive() {
        Control[] children;
        Control[] controlArray = children = this.getUiField().getParent().getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setData("org.eclipse.rwt.themeVariant", (Object)this.m_variantInActive);
            ++n2;
        }
        this.getUiField().setData("org.eclipse.rwt.themeVariant", (Object)this.m_variantActive);
    }

    @Override
    public void makeButtonInactive() {
        this.getUiField().setData("org.eclipse.rwt.themeVariant", (Object)this.m_variantInActive);
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.updateIconFromScout();
        this.updateTextFromScout();
    }

    @Override
    public Button getUiField() {
        return (Button)super.getUiField();
    }

    protected void handleUiSelection() {
        final boolean selected = this.getUiField().getSelection();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IAction)RwtScoutFormButton.this.getScoutObject()).getUIFacade().setSelectedFromUI(selected);
                ((IAction)RwtScoutFormButton.this.getScoutObject()).getUIFacade().fireActionFromUI();
            }
        };
        this.getUiEnvironment().invokeScoutLater(t, 0L);
    }

    protected void updateIconFromScout() {
        if (this.m_iconVisible) {
            this.getUiField().setImage(this.getUiEnvironment().getIcon(((IAction)this.getScoutObject()).getIconId()));
        }
    }

    protected void updateTextFromScout() {
        if (this.m_textVisible) {
            this.getUiField().setText(((IAction)this.getScoutObject()).getText());
        }
    }

    private void updateEnabledFormScout() {
        this.getUiField().setEnabled(((IAction)this.getScoutObject()).isEnabled());
    }

    private void updateVisibleFromScout() {
        this.getUiField().setVisible(((IAction)this.getScoutObject()).isVisible());
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if ("iconId".equals(name)) {
            this.updateIconFromScout();
        } else if ("text".equals(name)) {
            this.updateTextFromScout();
        } else if ("enabled".equals(name)) {
            this.updateEnabledFormScout();
        } else if ("visible".equals(name)) {
            this.updateVisibleFromScout();
        }
    }
}

