/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.WeakHashMap;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.ui.swing.basic.tree.SwingScoutTree;

public class SwingTreeModel
implements TreeModel {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingTreeModel.class);
    private EventListenerList m_listenerList = new EventListenerList();
    private SwingScoutTree m_swingScoutTree;
    private WeakHashMap<Object, Object[]> m_childMap;
    private WeakHashMap<Object, Integer> m_childIndexMap;

    public SwingTreeModel(SwingScoutTree swingScoutTree) {
        this.m_swingScoutTree = swingScoutTree;
        this.clearCache();
    }

    private void clearCache() {
        this.m_childMap = new WeakHashMap();
        this.m_childIndexMap = new WeakHashMap();
    }

    private Object[] getCachedChildren(Object parent) {
        Object[] children = this.m_childMap.get(parent);
        if (children == null || children.length == 0) {
            ITreeNode scoutNode = (ITreeNode)parent;
            children = scoutNode.getFilteredChildNodes();
            this.m_childMap.put(parent, children);
            int i = 0;
            while (i < children.length) {
                this.m_childIndexMap.put(children[i], i);
                ++i;
            }
        }
        return children;
    }

    private int getCachedChildIndex(Object parent, Object child) {
        this.getCachedChildren(parent);
        Integer index = this.m_childIndexMap.get(child);
        return index != null ? index : -1;
    }

    public void notifyScoutModelChanged() {
        this.fireStructureChanged((ITreeNode)this.getRoot());
    }

    @Override
    public boolean isLeaf(Object node) {
        ITreeNode scoutNode = (ITreeNode)node;
        return scoutNode.isLeaf();
    }

    @Override
    public Object getRoot() {
        ITreeNode root = null;
        if (this.m_swingScoutTree.getScoutObject() != null) {
            root = ((ITree)this.m_swingScoutTree.getScoutObject()).getRootNode();
        }
        return root;
    }

    @Override
    public int getChildCount(Object parent) {
        return this.getCachedChildren(parent).length;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object[] cachedChildren = this.getCachedChildren(parent);
        if (cachedChildren != null && cachedChildren.length > index) {
            return cachedChildren[index];
        }
        return null;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.getCachedChildIndex(parent, child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.m_listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.m_listenerList.remove(TreeModelListener.class, l);
    }

    protected void fireTreeNodesChanged(ITreeNode scoutParent, ITreeNode[] scoutChildren) {
        this.clearCache();
        EventListener[] listeners = this.m_listenerList.getListeners(TreeModelListener.class);
        if (listeners != null && listeners.length > 0) {
            TreeModelEvent e = new TreeModelEvent((Object)this, SwingScoutTree.scoutNodeToTreePath(scoutParent), this.scoutNodesToSwingIndexes(scoutParent, scoutChildren), (Object[])scoutChildren);
            int i = 0;
            while (i < listeners.length) {
                ((TreeModelListener)listeners[i]).treeNodesChanged(e);
                ++i;
            }
        }
    }

    protected void fireTreeNodesInserted(ITreeNode scoutParent, ITreeNode[] scoutChildren) {
        this.clearCache();
        EventListener[] listeners = this.m_listenerList.getListeners(TreeModelListener.class);
        if (listeners != null && listeners.length > 0) {
            TreeModelEvent e = new TreeModelEvent((Object)this, SwingScoutTree.scoutNodeToTreePath(scoutParent), this.scoutNodesToSwingIndexes(scoutParent, scoutChildren), (Object[])scoutChildren);
            int i = 0;
            while (i < listeners.length) {
                ((TreeModelListener)listeners[i]).treeNodesInserted(e);
                ++i;
            }
        }
    }

    protected void fireTreeNodesRemoved(ITreeNode scoutParent, ITreeNode[] scoutChildren) {
        this.clearCache();
        EventListener[] listeners = this.m_listenerList.getListeners(TreeModelListener.class);
        if (listeners != null && listeners.length > 0) {
            TreeModelEvent e = new TreeModelEvent((Object)this, SwingScoutTree.scoutNodeToTreePath(scoutParent), this.scoutNodesToSwingIndexes(scoutParent, scoutChildren), (Object[])scoutChildren);
            int i = 0;
            while (i < listeners.length) {
                ((TreeModelListener)listeners[i]).treeNodesRemoved(e);
                ++i;
            }
        }
    }

    protected void fireStructureChanged(ITreeNode scoutParent) {
        this.clearCache();
        EventListener[] listeners = this.m_listenerList.getListeners(TreeModelListener.class);
        if (listeners != null && listeners.length > 0) {
            TreeModelEvent e = new TreeModelEvent((Object)this, SwingScoutTree.scoutNodeToTreePath(scoutParent));
            int i = 0;
            while (i < listeners.length) {
                ((TreeModelListener)listeners[i]).treeStructureChanged(e);
                ++i;
            }
        }
    }

    public int[] scoutNodesToSwingIndexes(Object scoutParent, Object[] scoutChildren) {
        if (scoutChildren == null || scoutChildren.length == 0) {
            return new int[0];
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>(scoutChildren.length);
        Object[] objectArray = scoutChildren;
        int n = scoutChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Object scoutChild = objectArray[n2];
            int i = this.getCachedChildIndex(scoutParent, scoutChild);
            if (i >= 0) {
                indexList.add(i);
            }
            ++n2;
        }
        int[] a = new int[indexList.size()];
        int i = 0;
        while (i < a.length) {
            a[i] = (Integer)indexList.get(i);
            ++i;
        }
        Arrays.sort(a);
        return a;
    }
}

