/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.tree;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class TreeHtmlLinkDetector {
    private TreePath m_treePath;
    private URL m_hyperlink;

    public boolean detect(JTree tree, Point p) {
        block6: {
            this.m_treePath = null;
            this.m_hyperlink = null;
            TreePath path = tree.getPathForLocation(p.x, p.y);
            if (path != null && path.getPathCount() > 0) {
                String s;
                AttributeSet set;
                Element elem;
                View v;
                TreeCellRenderer renderer = tree.getCellRenderer();
                Component c = renderer.getTreeCellRendererComponent(tree, path.getLastPathComponent(), tree.isPathSelected(path), tree.isExpanded(path), tree.getModel().isLeaf(path.getLastPathComponent()), tree.getRowForPath(path), true);
                if (!(c instanceof JComponent) || (v = (View)((JComponent)c).getClientProperty("html")) == null) break block6;
                HTMLDocument doc = (HTMLDocument)v.getDocument();
                if ((v = v.getView(0)) == null || doc == null) break block6;
                Rectangle r = tree.getPathBounds(path);
                Rectangle allocation = new Rectangle(0, 0, r.width, r.height);
                v.setSize(r.width, r.height);
                int pos = v.viewToModel(p.x - r.x, p.y - r.y, allocation, new Position.Bias[1]);
                if (pos < 0 || (elem = doc.getCharacterElement(pos)) == null || (set = (AttributeSet)elem.getAttributes().getAttribute(HTML.Tag.A)) == null || (s = (String)set.getAttribute(HTML.Attribute.HREF)) == null) break block6;
                try {
                    this.m_hyperlink = new URL(s);
                    this.m_treePath = path;
                    return true;
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        this.m_hyperlink = new URL(new URL("http://local"), s);
                        this.m_treePath = path;
                        return true;
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return false;
    }

    public URL getHyperlink() {
        return this.m_hyperlink;
    }

    public TreePath getTreePath() {
        return this.m_treePath;
    }
}

