/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.calendar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.TreeSet;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.calendar.DateTimeFormatFactory;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.calendar.AbstractCalendarCell;
import org.eclipse.scout.rt.ui.swing.ext.calendar.CalendarItemTransferable;
import org.eclipse.scout.rt.ui.swing.ext.calendar.CalendarModel;
import org.eclipse.scout.rt.ui.swing.ext.calendar.DateChooser;

public class LargeCalendarCell
extends AbstractCalendarCell {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(LargeCalendarCell.class);
    private static final int SWITCH_ITEM_WIDTH = 60;
    private static final int SWITCH_ITEM_HEIGHT = 40;
    private static final int SWITCH_COMPRESSED_HEIGHT = 4;
    private static final long HOUR_MILLIS = 3600000L;
    private static final Border EMPTY_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Dimension MIN_SIZE = new Dimension(10, 10);
    private static final Dimension PREF_SIZE = new Dimension(80, 60);
    private static final Dimension MAX_SIZE = new Dimension(1000, 1000);
    private DateChooser m_dateChooser;
    protected Date m_repDate;
    protected Color m_notMajorColor;
    protected Color m_yesMajorColor;
    protected boolean m_selected;
    private boolean m_isMajor;
    private int m_displayType = 3;
    private int m_startHour = 6;
    private int m_endHour = 19;
    private String m_weekLabel;
    private String m_dateLabel;
    private String m_dayLabel;
    private TreeSet<ItemWrapper> m_itemsCached;
    private int m_countTimeless = 0;
    private boolean m_firstColumn = false;
    private DateFormat m_formatHHMM;

    public LargeCalendarCell(DateChooser dateChooser) {
        this.m_dateChooser = dateChooser;
        this.m_formatHHMM = new DateTimeFormatFactory().getHourMinute();
        this.setLayout(null);
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.m_notMajorColor = new Color(0xEEEEEE);
        this.m_yesMajorColor = this.getBackground();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LargeCalendarCell.this.m_dateChooser.setSelectedItem(LargeCalendarCell.this.getItemAt(e.getPoint()));
            }
        });
        ItemDragGestureListener idgl = new ItemDragGestureListener();
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 2, idgl);
        CellDropTargetAdapter dta = new CellDropTargetAdapter();
        new DropTarget(this, dta);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    protected void onSpacePressed() {
        this.m_dateChooser.setSelectedDate(this.getRepresentedDate());
    }

    @Override
    protected void onFocusGained() {
        this.m_dateChooser.setSelectedDate(this.getRepresentedDate());
    }

    @Override
    public void resetItemCache() {
        this.m_itemsCached = null;
    }

    @Override
    public int getTimelessItemCount() {
        this.getItems();
        return this.m_countTimeless;
    }

    @Override
    public int getTimedItemCount() {
        return this.getItems().size() - this.m_countTimeless;
    }

    public Collection getItems() {
        if (this.m_itemsCached == null) {
            this.m_itemsCached = new TreeSet();
            this.m_countTimeless = 0;
            Collection<Object> items = this.m_dateChooser.getModel().getItemsAt(this.getRepresentedDate());
            if (items != null) {
                try {
                    for (Object item : items) {
                        this.m_itemsCached.add(new ItemWrapper(item));
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    LOG.warn("ConcurrentModificationException on getItems");
                    return this.m_itemsCached;
                }
            }
            if (this.m_itemsCached.size() > 0) {
                ArrayList<ItemBoundsOrganizer> orgs = new ArrayList<ItemBoundsOrganizer>();
                ArrayList<ItemBoundsOrganizer> conflictSet = new ArrayList<ItemBoundsOrganizer>();
                int horizontalSlotCount = 0;
                for (ItemWrapper newItem : this.m_itemsCached) {
                    if (!newItem.isTimed()) continue;
                    ItemBoundsOrganizer newOrg = new ItemBoundsOrganizer(newItem);
                    conflictSet.clear();
                    int minLevel = 0;
                    int i = 0;
                    int n = orgs.size();
                    while (i < n) {
                        ItemBoundsOrganizer existingOrg = (ItemBoundsOrganizer)orgs.get(i);
                        if (existingOrg.getCC().intersects(newOrg.getCC())) {
                            conflictSet.add(existingOrg);
                            minLevel = Math.max(minLevel, existingOrg.getMinLevel() + 1);
                        }
                        ++i;
                    }
                    newOrg.setMinLevel(minLevel);
                    horizontalSlotCount = Math.max(horizontalSlotCount, minLevel + 1);
                    orgs.add(newOrg);
                    for (ItemBoundsOrganizer org : conflictSet) {
                        org.limitMaxLevel(minLevel - 1);
                    }
                }
                for (ItemBoundsOrganizer org : orgs) {
                    org.saveHorizontalExtents(horizontalSlotCount);
                }
                orgs = null;
                for (ItemWrapper cc : this.m_itemsCached) {
                    if (cc.isTimed()) continue;
                    cc.setHorizontalExtents(0.0f, 1.0f);
                    ++this.m_countTimeless;
                }
            }
        }
        return this.m_itemsCached;
    }

    @Override
    public void refresh() {
        this.repaint();
    }

    @Override
    public Dimension getMinimumSize() {
        return MIN_SIZE;
    }

    @Override
    public Dimension getPreferredSize() {
        return PREF_SIZE;
    }

    @Override
    public Dimension getMaximumSize() {
        return MAX_SIZE;
    }

    @Override
    public boolean isSelected() {
        return this.m_selected;
    }

    @Override
    public void setSelected(boolean b) {
        this.m_selected = b;
    }

    @Override
    public Date getRepresentedDate() {
        return this.m_repDate;
    }

    public boolean isFirstColumn() {
        return this.m_firstColumn;
    }

    @Override
    public void setRepresentedState(Calendar c, boolean isMajor, boolean firstColumn, int displayType) {
        Date oldRepDate = this.m_repDate;
        this.m_repDate = new Date(c.getTime().getTime());
        this.m_isMajor = isMajor;
        this.m_displayType = displayType;
        this.m_firstColumn = firstColumn;
        if (oldRepDate == null || !oldRepDate.equals(this.m_repDate)) {
            this.resetItemCache();
        }
        this.m_weekLabel = this.isFirstColumn() && this.m_displayType != 1 ? String.valueOf(SwingUtility.getNlsText("WeekShort", new String[0])) + " " + c.get(3) : "";
        DateFormat fmt = DateFormat.getDateInstance(1);
        if (fmt instanceof SimpleDateFormat) {
            String pattern = ((SimpleDateFormat)fmt).toPattern();
            pattern = pattern.replaceAll("[/\\-,. ]*[y]+[/\\-,.]*", "").trim();
            pattern = pattern.replaceAll("[M]+", "MMM").trim();
            ((SimpleDateFormat)fmt).applyPattern(pattern);
        }
        this.m_dateLabel = fmt.format(this.m_repDate);
        this.m_dayLabel = "" + c.get(5);
        this.repaint();
    }

    @Override
    public Object getItemAt(Point p) {
        Object foundItem = null;
        for (ItemWrapper cc : this.getItems()) {
            if (!cc.contains(p)) continue;
            foundItem = cc.getItem();
        }
        return foundItem;
    }

    public static long getTimeOfDayMillis(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        long timeRel = (((long)c.get(11) * 60L + (long)c.get(12)) * 60L + (long)c.get(13)) * 1000L + (long)c.get(14);
        c.set(10, 0);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        long dayAbs = c.getTimeInMillis();
        return dayAbs + timeRel;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Object item = this.getItemAt(e.getPoint());
        if (item != null) {
            String text = this.m_dateChooser.getModel().getTooltip(item, this.getRepresentedDate());
            return SwingUtility.createHtmlLabelText(text, true);
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_isMajor) {
            this.setBackground(this.m_yesMajorColor);
        } else {
            this.setBackground(this.m_notMajorColor);
        }
        Insets insets = this.getInsets();
        Rectangle view = insets != null ? new Rectangle(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom) : new Rectangle(0, 0, this.getWidth(), this.getHeight());
        Graphics gSub = g.create(view.x, view.y, view.width, view.height);
        gSub.setClip(0, 0, view.width, view.height);
        ArrayList<Rectangle> reservedAreas = new ArrayList<Rectangle>();
        Rectangle subView = this.paintBefore(gSub, reservedAreas);
        Graphics gSubSub = gSub.create(subView.x, subView.y, subView.width, subView.height);
        ArrayList<Rectangle> subReservedAreas = new ArrayList<Rectangle>(reservedAreas.size());
        for (Rectangle r : reservedAreas) {
            r = new Rectangle(r);
            r.translate(-subView.x, -subView.y);
            subReservedAreas.add(r);
        }
        gSubSub.setClip(0, 0, subView.width, subView.height);
        int subSubX = view.x + subView.x;
        int subSubY = view.y + subView.y;
        if (this.m_displayType == 3) {
            this.paintMediumList(gSubSub, subSubX, subSubY, subReservedAreas);
        } else if (this.m_displayType == 2 || this.m_displayType == 4) {
            this.paintLargeList(gSubSub, subSubX, subSubY, subReservedAreas);
        } else {
            this.paintLargeList(gSubSub, subSubX, subSubY, subReservedAreas);
        }
        gSub.setClip(0, 0, view.width, view.height);
        this.paintAfter(gSub);
    }

    protected Rectangle paintBefore(Graphics g, Collection<Rectangle> reservedAreas) {
        Rectangle subView = g.getClipBounds();
        if (this.getWidth() >= 60 && this.getHeight() >= 40) {
            int w = subView.width;
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int ascent = fm.getAscent();
            if (this.m_displayType != 1) {
                g.setColor(this.getForeground());
                String s = this.m_dateLabel;
                int wStr = fm.stringWidth(s);
                int splitx = Math.max(1, w - wStr - 1);
                g.setClip(splitx, 0, w - splitx, fm.getHeight());
                reservedAreas.add(g.getClipBounds());
                g.drawString(s, splitx, ascent);
                if (this.isFirstColumn() && this.m_displayType != 1 && (s = this.m_weekLabel) != null && s.length() > 0 && (wStr = fm.stringWidth(s)) <= splitx - 5) {
                    g.setClip(1, 0, wStr, fm.getHeight());
                    reservedAreas.add(g.getClipBounds());
                    g.drawString(s, 1, ascent);
                }
                int dy = fm.getHeight() + 1;
                subView.y += dy;
                subView.height -= dy;
            }
            if (this.m_displayType == 1 || this.m_displayType == 2 || this.m_displayType == 4) {
                Rectangle timedView = new Rectangle(subView.x, subView.y + this.m_dateChooser.getTimelessSectionHeightHint(), subView.width, subView.height - this.m_dateChooser.getTimelessSectionHeightHint());
                g.setClip(subView);
                boolean drawLabel = this.isFirstColumn();
                Color lineCol = new Color(0xDDDDDD);
                Color darkLineCol = new Color(0xAAAAAA);
                Color textCol = new Color(0xAAAAAA);
                g.setColor(lineCol);
                int maxLabelWidth = 0;
                int step = Math.max(1, ((this.m_endHour - this.m_startHour) * fm.getHeight() + timedView.height - 1) / timedView.height);
                int hour = this.m_startHour;
                while (hour <= this.m_endHour) {
                    boolean majorHour;
                    int y = timedView.y + (hour - this.m_startHour) * timedView.height / (this.m_endHour + 1 - this.m_startHour);
                    boolean bl = majorHour = hour == 12 || hour == 13;
                    if (majorHour) {
                        g.setColor(darkLineCol);
                    } else {
                        g.setColor(lineCol);
                    }
                    g.drawLine(0, y, w, y);
                    if (drawLabel) {
                        String s = hour == this.m_startHour && hour != 0 ? SwingUtility.getNlsText("Calendar_earlier", new String[0]) : (hour == this.m_endHour && hour != 23 ? SwingUtility.getNlsText("Calendar_later", new String[0]) : (hour == 0 ? this.formatHour(0) : (hour < 10 ? this.formatHour(hour) : this.formatHour(hour))));
                        g.setColor(textCol);
                        g.drawString(s, 1, y + ascent);
                        maxLabelWidth = Math.max(maxLabelWidth, fm.stringWidth(s) + 4);
                    }
                    hour += step;
                }
                if (drawLabel) {
                    int dx = maxLabelWidth;
                    subView.x += dx;
                    subView.width -= dx;
                }
            }
        }
        return subView;
    }

    protected void paintAfter(Graphics g) {
        if ((this.getWidth() < 60 || this.getHeight() < 40) && this.m_displayType != 1) {
            int w = g.getClipBounds().width;
            g.setColor(this.getForeground());
            FontMetrics fm = this.getFontMetrics(this.getFont());
            String s = this.m_dayLabel;
            int wStr = fm.stringWidth(s);
            g.setClip((w - wStr) / 2 - 1, 0, wStr, fm.getHeight());
            g.drawString(s, (w - wStr) / 2 - 1, fm.getAscent());
        }
    }

    private String formatHour(int h) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2000, 1, 1, h, 0, 0);
        String s = this.m_formatHHMM.format(cal.getTime());
        if (s.charAt(1) == ':') {
            s = "0" + s;
        }
        return s;
    }

    protected void paintMediumList(Graphics g, int absX, int absY, Collection<Rectangle> reservedAreas) {
        int w = g.getClipBounds().width;
        int h = g.getClipBounds().height;
        int n = this.getItems().size();
        if (n <= 0) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int heightByFont = n * fm.getHeight();
        boolean showLabel = heightByFont <= h && this.getWidth() >= 60;
        boolean showCompressed = h / n < 4;
        boolean showGaps = n > 1;
        int index = 0;
        Rectangle r = new Rectangle();
        int compressedCols = 1;
        int compressedRows = n;
        if (showCompressed) {
            compressedCols = Math.max(1, (int)Math.sqrt(n));
            compressedRows = Math.max(1, (n + compressedCols - 1) / compressedCols);
        }
        for (ItemWrapper cc : this.getItems()) {
            if (showCompressed) {
                int col = index % compressedCols;
                int row = index / compressedCols;
                r.setBounds(col * w / compressedCols, row * h / compressedRows, (col + 1) * w / compressedCols - col * w / compressedCols, (row + 1) * h / compressedRows - row * h / compressedRows);
            } else if (showLabel) {
                r.setBounds(0, index * heightByFont / n, w, (index + 1) * heightByFont / n - index * heightByFont / n);
            } else {
                r.setBounds(0, index * h / n, w, (index + 1) * h / n - index * h / n);
            }
            if (showGaps && r.height >= 4) {
                ++r.y;
                r.height -= 2;
            }
            if (showLabel) {
                r = this.removeReservedAreas(r, reservedAreas);
            }
            cc.setBounds(absX + r.x, absY + r.y, r.width, r.height);
            Color color = cc.getColor();
            if (this.m_dateChooser.getSelectedItem() == cc.getItem()) {
                color = color.darker();
            }
            g.setColor(color);
            g.setClip(r);
            g.fillRect(r.x, r.y, r.width, r.height);
            if (showLabel) {
                g.setColor(this.getForeground());
                String s = this.m_dateChooser.getModel().getLabel(cc.getItem(), this.getRepresentedDate());
                if (s != null) {
                    g.drawString(s, r.x + 1, r.y + r.height - fm.getDescent());
                }
            }
            ++index;
        }
    }

    private Rectangle removeReservedAreas(Rectangle r, Collection<Rectangle> reservedAreas) {
        for (Rectangle res : reservedAreas) {
            Rectangle i = r.intersection(res);
            if (!i.isEmpty()) {
                if (i.x <= r.x) {
                    int dx;
                    r.x = dx = i.x + i.width - r.x;
                    r.width -= dx;
                } else {
                    r.width = i.x - r.x;
                }
            }
            if ((i = r.intersection(res)).isEmpty()) continue;
            if (i.y <= r.y) {
                int dy;
                r.y = dy = i.y + i.height - r.y;
                r.height -= dy;
                continue;
            }
            r.height = i.y - r.y;
        }
        return r;
    }

    protected void paintLargeList(Graphics g, int absX, int absY, Collection<Rectangle> reservedAreas) {
        Rectangle clipRect = g.getClipBounds();
        int w = clipRect.width;
        int hTimeless = Math.max(0, this.m_dateChooser.getTimelessSectionHeightHint() - 1);
        int yTimed = hTimeless + 1;
        int hTimed = clipRect.height - hTimeless;
        if (this.getItems().size() <= 0) {
            return;
        }
        int timelessIndex = 0;
        int timelessItemHeight = 0;
        if (this.m_countTimeless > 0) {
            timelessItemHeight = Math.max(5, hTimeless / this.m_countTimeless);
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Rectangle r = new Rectangle();
        long intervalMillis = (long)(this.m_endHour + 1 - this.m_startHour) * 3600000L;
        for (ItemWrapper cc : this.getItems()) {
            if (cc.isTimed()) {
                r.x = (int)(cc.getX0() * (float)w);
                r.width = (int)(cc.getX1() * (float)w) - r.x;
                r.y = yTimed + (int)(cc.getFromRelative() * (long)hTimed / intervalMillis);
                r.height = yTimed + (int)(cc.getToRelative() * (long)hTimed / intervalMillis) - r.y;
                if (r.height <= 4) {
                    r.height = 4;
                }
            } else {
                r.x = 0;
                r.width = w;
                r.y = 0 + timelessIndex * timelessItemHeight;
                r.height = r.y < hTimeless ? timelessItemHeight : 0;
                ++timelessIndex;
            }
            ++r.x;
            r.width = Math.max(1, r.width - 2);
            ++r.y;
            r.height = Math.max(1, r.height - 2);
            cc.setBounds(r.x + absX, r.y + absY, r.width, r.height);
            Color color = cc.getColor();
            if (this.m_dateChooser.getSelectedItem() == cc.getItem()) {
                color = color.darker();
            }
            g.setColor(color);
            g.setClip(r);
            g.fillRect(r.x, r.y, r.width, r.height);
            cc.setLabeled(true);
            if (!cc.isLabeled()) continue;
            g.setColor(this.getForeground());
            String s = this.m_dateChooser.getModel().getLabel(cc.getItem(), this.getRepresentedDate());
            int centery = Math.max(0, (r.height - fm.getAscent()) / 2);
            g.setClip(r.x, r.y + centery, r.width, fm.getHeight());
            if (s == null) continue;
            g.drawString(s, r.x + 3, r.y + centery + fm.getAscent());
        }
    }

    private class CellDropTargetAdapter
    extends DropTargetAdapter {
        private CellDropTargetAdapter() {
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            Transferable tr = e.getTransferable();
            DataFlavor[] dataFlavorArray = tr.getTransferDataFlavors();
            int n = dataFlavorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataFlavor flavor = dataFlavorArray[n2];
                try {
                    if (flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref") && tr.getTransferData(flavor) instanceof ItemWrapper) {
                        ItemWrapper itemWrapper = (ItemWrapper)tr.getTransferData(flavor);
                        LargeCalendarCell.this.m_dateChooser.getModel().moveItem(itemWrapper.getItem(), LargeCalendarCell.this.getRepresentedDate());
                        break;
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                ++n2;
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            LargeCalendarCell.this.m_dateChooser.setSelectedDate(LargeCalendarCell.this.getRepresentedDate());
        }
    }

    private class ItemBoundsOrganizer {
        private ItemWrapper m_cc;
        private int m_minLevel;
        private int m_maxLevel = 100000;

        public ItemBoundsOrganizer(ItemWrapper cc) {
            this.m_cc = cc;
        }

        public ItemWrapper getCC() {
            return this.m_cc;
        }

        public int getMinLevel() {
            return this.m_minLevel;
        }

        public void setMinLevel(int i) {
            this.m_minLevel = i;
        }

        public void limitMaxLevel(int maximumValue) {
            this.m_maxLevel = Math.min(this.m_maxLevel, maximumValue);
        }

        private void saveHorizontalExtents(int horizontalSlotCount) {
            float x0 = 1.0f * (float)this.m_minLevel / (float)horizontalSlotCount;
            float x1 = 1.0f * (float)Math.min(this.m_maxLevel + 1, horizontalSlotCount) / (float)horizontalSlotCount;
            this.m_cc.setHorizontalExtents(x0, x1);
        }

        public String toString() {
            return "BoundsOrganizer[" + this.m_cc + "]";
        }
    }

    private class ItemDragGestureListener
    implements DragGestureListener {
        private ItemDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            Object item = LargeCalendarCell.this.getItemAt(e.getDragOrigin());
            if (item == null) {
                return;
            }
            if (LargeCalendarCell.this.m_dateChooser.getModel().isDraggable(item)) {
                ItemWrapper cic = new ItemWrapper(item);
                cic.setDragSourceDate(LargeCalendarCell.this.getRepresentedDate());
                CalendarItemTransferable cit = new CalendarItemTransferable(cic);
                e.startDrag(null, cit);
            }
        }
    }

    private class ItemWrapper
    implements Comparable<ItemWrapper> {
        private Object m_item;
        private boolean m_labeled;
        private long m_fromRelative;
        private long m_toRelative;
        private Rectangle m_bounds;
        private boolean m_fullDay;
        private Date m_dragSourceDate;
        private float m_x0;
        private float m_x1;

        public ItemWrapper(Object item) {
            Date d2;
            this.m_item = item;
            this.m_bounds = new Rectangle(1, 2, 3, 4);
            long repTimeOfDayStart = LargeCalendarCell.getTimeOfDayMillis(LargeCalendarCell.this.getRepresentedDate());
            long displayInterval = 3600000L * (long)(LargeCalendarCell.this.m_endHour + 1 - LargeCalendarCell.this.m_startHour);
            CalendarModel model = LargeCalendarCell.this.m_dateChooser.getModel();
            this.m_fullDay = model.isFullDay(item);
            this.m_fromRelative = LargeCalendarCell.getTimeOfDayMillis(model.getFromDate(item)) - repTimeOfDayStart - 3600000L * (long)LargeCalendarCell.this.m_startHour;
            if (this.m_fromRelative < 0L) {
                this.m_fromRelative = 0L;
            }
            if (this.m_fromRelative > displayInterval) {
                this.m_fromRelative = displayInterval;
            }
            this.m_toRelative = (d2 = model.getToDate(item)) == null ? this.m_fromRelative : LargeCalendarCell.getTimeOfDayMillis(d2) - repTimeOfDayStart - 3600000L * (long)LargeCalendarCell.this.m_startHour;
            if (this.m_toRelative < 0L) {
                this.m_toRelative = 0L;
            }
            if (this.m_toRelative > displayInterval) {
                this.m_toRelative = displayInterval;
            }
            if (this.m_fromRelative >= displayInterval - 3600000L && this.m_toRelative >= displayInterval - (long)LargeCalendarCell.this.m_endHour * 3600000L) {
                this.m_fromRelative = displayInterval - 3600000L;
                this.m_toRelative = displayInterval;
            }
            if (this.m_toRelative == this.m_fromRelative) {
                this.m_toRelative = this.m_fromRelative + 3600000L;
            }
        }

        public void setHorizontalExtents(float x0, float x1) {
            this.m_x0 = x0;
            this.m_x1 = x1;
        }

        public float getX0() {
            return this.m_x0;
        }

        public float getX1() {
            return this.m_x1;
        }

        public Object getItem() {
            return this.m_item;
        }

        public void setBounds(int x, int y, int w, int h) {
            this.m_bounds.setBounds(x, y, w, h);
        }

        public boolean contains(Point p) {
            return this.m_bounds.contains(p);
        }

        public void setLabeled(boolean on) {
            this.m_labeled = on;
        }

        public void setDragSourceDate(Date date) {
            this.m_dragSourceDate = date;
        }

        public boolean isLabeled() {
            return this.m_labeled;
        }

        public boolean isTimed() {
            return !this.m_fullDay;
        }

        public String toString() {
            return "Wrapper[" + this.m_item + (this.m_item != null ? "@" + Integer.toHexString(this.m_item.hashCode()) : "") + "]";
        }

        public boolean intersects(ItemWrapper other) {
            if (this.m_fromRelative <= other.m_fromRelative && other.m_fromRelative < this.m_toRelative) {
                return true;
            }
            return this.m_fromRelative < other.m_toRelative && other.m_toRelative <= this.m_toRelative;
        }

        public long getFromRelative() {
            return this.m_fromRelative;
        }

        public long getToRelative() {
            return this.m_toRelative;
        }

        public Date getDragSourceDate() {
            return this.m_dragSourceDate;
        }

        public Color getColor() {
            Color c = LargeCalendarCell.this.m_dateChooser.getModel().getColor(this.m_item);
            if (c == null) {
                c = LargeCalendarCell.this.getBackground();
            }
            return c;
        }

        private Date getCompareDate() {
            return LargeCalendarCell.this.m_dateChooser.getModel().getFromDate(this.m_item);
        }

        private Integer getCompareId() {
            return new Integer(this.m_item.hashCode());
        }

        @Override
        public int compareTo(ItemWrapper o) {
            if (this.m_item instanceof Comparable) {
                return ((Comparable)this.m_item).compareTo(o.getItem());
            }
            int i = this.getCompareDate().compareTo(o.getCompareDate());
            if (i == 0) {
                i = this.getCompareId().compareTo(o.getCompareId());
            }
            return i;
        }

        public boolean equals(Object o) {
            return this.m_item == o;
        }

        public int hashCode() {
            return this.m_item.hashCode();
        }
    }
}

