/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.job;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.ui.swing.ext.job.SwingProgressMonitor;
import org.eclipse.scout.rt.ui.swing.ext.job.SwingProgressProvider;

public class SwingProgressHandler {
    private static SwingProgressHandler instance;
    private final EventListenerList m_listenerList = new EventListenerList();
    private boolean m_jobRunning;
    private String m_taskName;
    private String m_subTaskName;
    private double m_worked;

    public static synchronized void install() {
        if (instance == null) {
            instance = new SwingProgressHandler();
        }
    }

    public static synchronized void uninstall() {
        SwingProgressHandler oldHandler = instance;
        instance = null;
        if (oldHandler != null) {
            oldHandler.dispose();
        }
    }

    public static SwingProgressHandler getInstance() {
        return instance;
    }

    protected SwingProgressHandler() {
        SwingProgressProvider p = new SwingProgressProvider();
        Job.getJobManager().setProgressProvider((ProgressProvider)p);
        p.addPropertyChangeListener("activeMonitor", new PropertyChangeListener(){

            @Override
            public synchronized void propertyChange(PropertyChangeEvent evt) {
                final SwingProgressMonitor monitor = (SwingProgressMonitor)((Object)evt.getNewValue());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SwingProgressHandler.this.propertyChangeInSwing(monitor);
                    }
                });
            }
        });
    }

    private void dispose() {
        Job.getJobManager().setProgressProvider(null);
    }

    private void propertyChangeInSwing(SwingProgressMonitor monitor) {
        if (monitor == null) {
            this.m_jobRunning = false;
            this.m_taskName = null;
            this.m_subTaskName = null;
            this.m_worked = 0.0;
        } else {
            this.m_jobRunning = true;
            this.m_taskName = monitor.getTaskName();
            this.m_subTaskName = monitor.getSubTaskName();
            this.m_worked = monitor.getWorked();
        }
        this.fireStateChanged();
    }

    public void addStateChangeListener(IStateChangeListener listener) {
        this.m_listenerList.add(IStateChangeListener.class, (EventListener)listener);
    }

    public void removeStateChangeListener(IStateChangeListener listener) {
        this.m_listenerList.remove(IStateChangeListener.class, (EventListener)listener);
    }

    private void fireStateChanged() {
        IStateChangeListener[] listeners = (IStateChangeListener[])this.m_listenerList.getListeners(IStateChangeListener.class);
        if (listeners == null || listeners.length == 0) {
            return;
        }
        IStateChangeListener[] iStateChangeListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IStateChangeListener listener = iStateChangeListenerArray[n2];
            listener.stateChanged(this);
            ++n2;
        }
    }

    public boolean isJobRunning() {
        return this.m_jobRunning;
    }

    public double getJobWorked() {
        return this.m_worked;
    }

    public String getJobTaskName() {
        return StringUtility.concatenateTokens((String[])new String[]{this.m_taskName, " - ", this.m_subTaskName});
    }

    public static class CancelJobsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent a) {
            Job[] jobs = Job.getJobManager().find(null);
            if (jobs != null) {
                Job[] jobArray = jobs;
                int n = jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    Job j = jobArray[n2];
                    if (!j.isSystem() && j.getState() == 4) {
                        try {
                            j.cancel();
                        }
                        catch (Throwable throwable) {}
                    }
                    ++n2;
                }
            }
        }
    }

    public static interface IStateChangeListener
    extends EventListener {
        public void stateChanged(SwingProgressHandler var1);
    }
}

