/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.button;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.JHyperlink;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.button.ISwingScoutLink;

public class SwingScoutLink
extends SwingScoutFieldComposite<IButton>
implements ISwingScoutLink {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutLink.class);
    private boolean m_handleActionPending;

    @Override
    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        container.setName(String.valueOf(((IButton)this.getScoutObject()).getClass().getSimpleName()) + ".container");
        JHyperlink swingLink = new JHyperlink();
        swingLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingScoutLink.this.handleSwingAction();
            }
        });
        container.add(swingLink);
        this.setSwingLabel(null);
        this.setSwingField(swingLink);
        LogicalGridData gd = (LogicalGridData)swingLink.getClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME);
        if (((IButton)this.getScoutObject()).isProcessButton() && !gd.useUiHeight) {
            gd.useUiHeight = true;
            gd.heightHint = this.getSwingEnvironment().getProcessButtonHeight();
        }
        this.setSwingContainer(container);
        container.setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 0, 0));
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        this.getSwingField().setEnabled(b);
    }

    @Override
    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        this.getSwingField().setAlignmentX(SwingUtility.createAlignmentX(scoutAlign));
        if (this.getSwingContainer().isShowing()) {
            this.getSwingContainer().revalidate();
        }
    }

    @Override
    protected void setVerticalAlignmentFromScout(int scoutAlign) {
        this.getSwingField().setAlignmentY(SwingUtility.createAlignmentY(scoutAlign));
        if (this.getSwingContainer().isShowing()) {
            this.getSwingContainer().revalidate();
        }
    }

    @Override
    protected void setLabelFromScout(String s) {
        String label = StringUtility.removeMnemonic((String)s);
        if (this.getSwingField() instanceof JTextComponent) {
            JTextComponent comp = (JTextComponent)this.getSwingField();
            comp.setText(label);
        } else if (this.getSwingField() instanceof JLabel) {
            JLabel comp = (JLabel)this.getSwingField();
            comp.setText(label);
        }
        SwingLayoutUtility.invalidateAncestors(this.getSwingField());
    }

    private void handleSwingAction() {
        if (!this.m_handleActionPending) {
            this.m_handleActionPending = true;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        ((IButton)SwingScoutLink.this.getScoutObject()).getUIFacade().fireButtonClickedFromUI();
                    }
                    finally {
                        SwingScoutLink.this.m_handleActionPending = false;
                    }
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }
}

