/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.htmlfield;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlField;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SingleLayout;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JScrollPaneEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JTextPaneEx;
import org.eclipse.scout.rt.ui.swing.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.htmlfield.ISwingScoutHtmlField;

public class SwingScoutHtmlField
extends SwingScoutValueFieldComposite<IHtmlField>
implements ISwingScoutHtmlField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutHtmlField.class);
    private HTMLEditorKit m_htmlKit;
    private HTMLDocument m_htmlDoc;
    private StyleSheet m_styleSheet;
    private JTextPane m_htmlView;
    private JScrollPane m_scrollPane;
    private JPanelEx m_htmlViewPanel;
    private String m_originalText;
    private File m_tempFolder;

    @Override
    protected void initializeSwing() {
        super.initializeSwing();
        JPanelEx container = new JPanelEx();
        container.setName(String.valueOf(((IHtmlField)this.getScoutObject()).getClass().getSimpleName()) + ".container");
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add(label);
        this.m_htmlKit = new HTMLEditorKit();
        this.m_htmlDoc = (HTMLDocument)this.m_htmlKit.createDefaultDocument();
        this.m_styleSheet = this.m_htmlDoc.getStyleSheet();
        this.m_htmlView = new JTextPaneEx();
        this.m_htmlView.setName(String.valueOf(((IHtmlField)this.getScoutObject()).getClass().getSimpleName()) + ".htmlView");
        this.m_htmlView.setEditorKit(this.m_htmlKit);
        this.m_htmlView.setDocument(this.m_htmlDoc);
        this.m_htmlView.setEditable(false);
        this.m_htmlView.setBorder(null);
        this.m_htmlView.setMargin(null);
        this.m_htmlView.setCaretPosition(0);
        if (this.m_htmlView.getCaret() instanceof DefaultCaret) {
            ((DefaultCaret)this.m_htmlView.getCaret()).setUpdatePolicy(1);
        }
        this.m_htmlView.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SwingScoutHtmlField.this.fireHyperlinkActionFromSwing(e.getURL());
                }
            }
        });
        this.m_htmlViewPanel = new JPanelEx(new SingleLayout());
        this.m_htmlView.setName(String.valueOf(((IHtmlField)this.getScoutObject()).getClass().getSimpleName()) + ".htmlViewPanel");
        this.m_htmlViewPanel.putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, LogicalGridDataBuilder.createField(this.getSwingEnvironment(), ((IHtmlField)this.getScoutObject()).getGridData()));
        if (((IHtmlField)this.getScoutObject()).isScrollBarEnabled()) {
            this.m_scrollPane = new JScrollPaneEx(this.m_htmlView);
            this.m_htmlViewPanel.add(this.m_scrollPane);
        } else {
            this.m_htmlViewPanel.add(this.m_htmlView);
        }
        container.add(this.m_htmlViewPanel);
        this.setSwingContainer(container);
        this.setSwingLabel(label);
        this.setSwingField(this.m_htmlView);
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    @Override
    public JTextPane getSwingHtmlField() {
        return this.m_htmlView;
    }

    protected JScrollPane getScrollPane() {
        return this.m_scrollPane;
    }

    protected HTMLEditorKit getHtmlKit() {
        return this.m_htmlKit;
    }

    protected String getOriginalText() {
        return this.m_originalText;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IHtmlField f = (IHtmlField)this.getScoutObject();
        this.setScrollToAnchorFromScout(f.getScrollToAnchor());
    }

    protected void setScrollToAnchorFromScout(String anchorName) {
        if (!StringUtility.isNullOrEmpty((String)anchorName)) {
            this.getSwingHtmlField().scrollToReference(anchorName);
        }
    }

    protected File getTempFolder(boolean autoCreate) {
        if (this.m_tempFolder == null && autoCreate) {
            File folder = null;
            try {
                folder = File.createTempFile("attachements." + this.hashCode(), "");
                folder.delete();
                folder.mkdir();
                folder.deleteOnExit();
            }
            catch (IOException e) {
                LOG.error("could not create temp directory for mail attachement.", (Throwable)e);
            }
            this.m_tempFolder = folder;
        }
        return this.m_tempFolder;
    }

    @Override
    protected void setDisplayTextFromScout(String rawHtml) {
        RemoteFile[] a = ((IHtmlField)this.getScoutObject()).getAttachments();
        if (a != null) {
            RemoteFile[] remoteFileArray = a;
            int n = a.length;
            int n2 = 0;
            while (n2 < n) {
                RemoteFile f = remoteFileArray[n2];
                if (f != null && f.exists()) {
                    try {
                        this.writeTempFile(f.getPath(), new ByteArrayInputStream(f.extractData()));
                    }
                    catch (Exception e1) {
                        LOG.warn("could not read remote file '" + f.getName() + "'", (Throwable)e1);
                    }
                }
                ++n2;
            }
        }
        rawHtml = StringUtility.nvl((Object)rawHtml, (String)"");
        String styledHtml = this.getSwingEnvironment().styleHtmlText(this, rawHtml);
        if (CompareUtility.equals((Object)this.m_originalText, (Object)styledHtml)) {
            return;
        }
        this.m_originalText = styledHtml;
        JTextPane swingField = this.getSwingHtmlField();
        int oldPos = swingField.getCaretPosition();
        this.m_htmlDoc = (HTMLDocument)this.m_htmlKit.createDefaultDocument();
        File tempFolder = this.getTempFolder(false);
        if (tempFolder != null) {
            try {
                this.m_htmlDoc.setBase(tempFolder.toURI().toURL());
            }
            catch (MalformedURLException e) {
                LOG.warn("Setting document base", (Throwable)e);
            }
        }
        this.m_styleSheet = this.m_htmlDoc.getStyleSheet();
        this.m_htmlView.setDocument(this.m_htmlDoc);
        this.m_htmlView.setText(this.m_originalText);
        int newPos = Math.max(0, Math.min(oldPos, swingField.getDocument().getLength()));
        swingField.setCaretPosition(newPos);
        this.ensureContentHeight(this.m_htmlView);
    }

    private void ensureContentHeight(JTextPane textPane) {
        int preferredWidth = textPane.getPreferredSize().width;
        textPane.setSize(preferredWidth, Integer.MAX_VALUE);
    }

    /*
     * Loose catch block
     */
    private File writeTempFile(String relFullName, InputStream content) {
        File file;
        FileOutputStream out;
        block14: {
            int bytesRead;
            if ((relFullName = relFullName.replaceAll("\\\\", "/")) == null || relFullName.length() == 0) {
                return null;
            }
            if (!relFullName.startsWith("/")) {
                relFullName = "/" + relFullName;
            }
            File ioF = new File(this.getTempFolder(true), relFullName);
            ioF.getParentFile().mkdirs();
            out = null;
            out = new FileOutputStream(ioF);
            byte[] buffer = new byte[1026];
            while ((bytesRead = content.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
            ioF.deleteOnExit();
            file = ioF;
            if (out == null) break block14;
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return file;
        catch (IOException e) {
            block15: {
                try {
                    LOG.error("could not create file in temp dir: '" + relFullName + "'", (Throwable)e);
                    if (out == null) break block15;
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.m_htmlView.setEditable(((IHtmlField)this.getScoutObject()).isHtmlEditor());
        if (this.m_htmlView.getCaret() instanceof DefaultCaret) {
            ((DefaultCaret)this.m_htmlView.getCaret()).setUpdatePolicy(((IHtmlField)this.getScoutObject()).isHtmlEditor() ? 0 : 1);
        }
    }

    protected void fireHyperlinkActionFromSwing(final URL url) {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IHtmlField)SwingScoutHtmlField.this.getScoutObject()).getUIFacade().fireHyperlinkActionFromUI(url);
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    @Override
    protected boolean handleSwingInputVerifier() {
        String text;
        String htmlText = this.getSwingHtmlField().getText();
        if (SwingScoutHtmlField.isDefaultHtmlText(htmlText)) {
            htmlText = "";
        }
        if (CompareUtility.equals((Object)(text = htmlText), (Object)((IHtmlField)this.getScoutObject()).getDisplayText()) && ((IHtmlField)this.getScoutObject()).getErrorStatus() == null) {
            return true;
        }
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IHtmlField)SwingScoutHtmlField.this.getScoutObject()).getUIFacade().setTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getSwingEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {}
        this.getSwingEnvironment().dispatchImmediateSwingJobs();
        return true;
    }

    public static boolean isDefaultHtmlText(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        String canonicalText = s.replaceAll("[ \\n\\r\\t]+", "").trim();
        String defaultText = "<html><head></head><body><p></p></body></html>";
        return defaultText.equalsIgnoreCase(canonicalText);
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("scrollToEnd")) {
            this.getSwingHtmlField().setCaretPosition(this.getSwingHtmlField().getDocument().getLength());
        } else if (name.equals("scrollToPosition")) {
            this.setScrollToAnchorFromScout((String)TypeCastUtility.castValue((Object)newValue, String.class));
        }
    }
}

