/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.toolbar;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class HandCursorAdapater {
    private Cursor defaultCursor;
    private JComponent comp;
    private static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);

    public HandCursorAdapater(final JComponent comp) {
        this.comp = comp;
        this.defaultCursor = comp.getCursor();
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!comp.isEnabled()) {
                    return;
                }
                HandCursorAdapater.this.showHandCursor();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!comp.isEnabled()) {
                    return;
                }
                HandCursorAdapater.this.showDefaultCursor();
            }
        });
    }

    public void showDefaultCursor() {
        this.comp.setCursor(this.defaultCursor);
    }

    public void showHandCursor() {
        this.comp.setCursor(HAND_CURSOR);
    }
}

