/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.tray;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.action.SwingScoutAction;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.window.desktop.tray.ISwingScoutTray;

public class SwingScoutTray
extends SwingScoutComposite<IDesktop>
implements ISwingScoutTray {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutTray.class);
    private TrayIcon m_trayIcon;

    @Override
    protected void initializeSwing() {
        Image icon = Activator.getImage("window");
        if (icon == null) {
            icon = Activator.getImage("tray");
        }
        this.m_trayIcon = new TrayIcon(icon);
        PopupMenu pm = new PopupMenu();
        this.updatePopupMenus(pm);
        this.m_trayIcon.setPopupMenu(pm);
        try {
            SystemTray.getSystemTray().add(this.m_trayIcon);
        }
        catch (AWTException e) {
            LOG.warn("Failed attaching tray icon", (Throwable)e);
        }
    }

    protected void updatePopupMenus(PopupMenu pm) {
        pm.removeAll();
        if (this.getScoutObject() != null) {
            final AtomicReference scoutMenusRef = new AtomicReference();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    scoutMenusRef.set(((IDesktop)SwingScoutTray.this.getScoutObject()).getUIFacade().fireTrayPopupFromUI());
                }
            };
            try {
                this.getSwingEnvironment().invokeScoutLater(t, 5678L).join(5678L);
            }
            catch (InterruptedException interruptedException) {}
            if (scoutMenusRef.get() != null && ((IMenu[])scoutMenusRef.get()).length > 0) {
                IAction[] iActionArray = (IAction[])scoutMenusRef.get();
                int n = iActionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAction a = iActionArray[n2];
                    if (a.isSeparator()) {
                        pm.addSeparator();
                    } else if (a instanceof IMenu) {
                        MenuItem mi;
                        IMenu menu = (IMenu)a;
                        SwingScoutAction<IAction> actionComposite = new SwingScoutAction<IAction>();
                        actionComposite.createField(a, this.getSwingEnvironment());
                        if (menu.getChildActionCount() > 0) {
                            mi = new Menu();
                            mi.setLabel(menu.getText());
                            mi.setEnabled(menu.isEnabled());
                            mi.addActionListener(actionComposite.getSwingAction());
                            pm.add(mi);
                        } else {
                            mi = new MenuItem();
                            mi.setLabel(menu.getText());
                            mi.setEnabled(menu.isEnabled());
                            mi.addActionListener(actionComposite.getSwingAction());
                            pm.add(mi);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public TrayIcon getSwingTrayIcon() {
        return this.m_trayIcon;
    }
}

