/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayoutInfo;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.form.fields.AbstractLayoutManager2;

public class LogicalGridLayout
extends AbstractLayoutManager2 {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(LogicalGridLayout.class);
    public static final float EPS = 1.0E-6f;
    private ISwingEnvironment m_env;
    private boolean m_debug;
    private int m_hgap;
    private int m_vgap;
    private LogicalGridLayoutInfo m_info;

    public LogicalGridLayout(ISwingEnvironment env, int hgap, int vgap) {
        this.m_env = env;
        this.m_hgap = hgap;
        this.m_vgap = vgap;
    }

    public void setDebug(boolean b) {
        this.m_debug = b;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, null);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof LogicalGridData) {
            ((JComponent)comp).putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, constraints);
        }
        super.addLayoutComponent(comp, constraints);
    }

    private LogicalGridData getLayoutDataByRef(Component comp) {
        LogicalGridData data = (LogicalGridData)((JComponent)comp).getClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME);
        if (data == null) {
            data = new LogicalGridData();
            LOG.error("missing clientProperty " + LogicalGridData.CLIENT_PROPERTY_NAME + " in " + comp.getName() + "/" + comp.getClass() + " parent is " + comp.getParent().getName() + "/" + comp.getParent().getClass());
        }
        return data;
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.0f;
    }

    @Override
    protected void validateLayout(Container parent) {
        ArrayList<Component> visibleComps = new ArrayList<Component>();
        ArrayList<LogicalGridData> visibleCons = new ArrayList<LogicalGridData>();
        int i = 0;
        while (i < parent.getComponentCount()) {
            Component comp = parent.getComponent(i);
            if (comp.isVisible()) {
                visibleComps.add(comp);
                LogicalGridData cons = this.getLayoutDataByRef(comp);
                cons.validate();
                visibleCons.add(cons);
            }
            ++i;
        }
        this.m_info = new LogicalGridLayoutInfo(this.m_env, visibleComps.toArray(new Component[visibleComps.size()]), visibleCons.toArray(new LogicalGridData[visibleCons.size()]), this.m_hgap, this.m_vgap);
    }

    public void dumpLayoutInfo(Container parent) {
        this.dumpLayoutInfo(parent, new PrintWriter(System.out));
    }

    public void dumpLayoutInfo(Container parent, PrintWriter out) {
        out.println("**************** LogicalGridLayout[" + parent.getName() + "]");
        Component[] c = this.m_info.components;
        String[] names = new String[c.length];
        String[] constraints = new String[c.length];
        int i = 0;
        while (i < c.length) {
            String cls = c[i].getClass().getName();
            int dot = Math.max(cls.lastIndexOf(46), cls.lastIndexOf(62));
            if (dot >= 0) {
                cls = cls.substring(dot + 1);
            }
            names[i] = String.valueOf(cls) + " (" + c[i].getName() + (c[i].isVisible() ? "" : " invisible") + ")";
            constraints[i] = this.m_info.gridDatas[i].toString();
            ++i;
        }
        out.println("Layout Info");
        out.println("  hgap=" + this.m_hgap);
        out.println("  vgap=" + this.m_vgap);
        out.println("  size=" + parent.getSize());
        out.println("  minSize=" + this.getLayoutSize(parent, 0));
        out.println("  prfSize=" + this.getLayoutSize(parent, 1));
        out.println("  maxSize=" + this.getLayoutSize(parent, 2));
        out.println("  insets=" + parent.getInsets());
        out.println("  components=" + LogicalGridLayout.dump(names));
        out.println("  constraints=" + LogicalGridLayout.dump(constraints));
        out.println("  cols=" + this.m_info.cols);
        out.println("  rows=" + this.m_info.rows);
        out.println("  col-width=" + LogicalGridLayout.dump(this.m_info.width));
        out.println("  row-height=" + LogicalGridLayout.dump(this.m_info.height));
        out.println("  col-weightX=" + LogicalGridLayout.dump(this.m_info.weightX));
        out.println("  row-weightY=" + LogicalGridLayout.dump(this.m_info.weightY));
        Rectangle[][] cellBounds = this.m_info.layoutCellBounds(parent.getSize(), parent.getInsets());
        if (cellBounds != null) {
            int row = 0;
            while (row < cellBounds.length) {
                int col = 0;
                while (col < cellBounds[row].length) {
                    out.println("  cell[" + row + "][" + col + "]=" + cellBounds[row][col]);
                    ++col;
                }
                ++row;
            }
            if (cellBounds.length > 0) {
                Rectangle last = cellBounds[cellBounds.length - 1][cellBounds[cellBounds.length - 1].length - 1];
                if (parent.getWidth() > 0 && parent.getHeight() > 0) {
                    if (last.x + last.width > parent.getWidth() - parent.getInsets().left - parent.getInsets().right) {
                        out.println("!!! width too large: " + (last.x + last.width) + " > " + (parent.getWidth() - parent.getInsets().left - parent.getInsets().right));
                    }
                    if (last.y + last.height > parent.getHeight() - parent.getInsets().top - parent.getInsets().bottom) {
                        out.println("!!! height too large: " + (last.y + last.height) + " > " + (parent.getHeight() - parent.getInsets().top - parent.getInsets().bottom));
                    }
                }
            }
        }
        out.flush();
    }

    @Override
    protected Dimension getLayoutSize(Container parent, int sizeflag) {
        Dimension dim = new Dimension();
        int useCount = 0;
        int i = 0;
        while (i < this.m_info.cols) {
            int w = this.m_info.width[i][sizeflag];
            if (useCount > 0) {
                dim.width += this.m_hgap;
            }
            dim.width += w;
            ++useCount;
            ++i;
        }
        useCount = 0;
        i = 0;
        while (i < this.m_info.rows) {
            int h = this.m_info.height[i][sizeflag];
            if (useCount > 0) {
                dim.height += this.m_vgap;
            }
            dim.height += h;
            ++useCount;
            ++i;
        }
        if (dim.width > 0 && dim.height > 0) {
            Insets insets = parent.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
        }
        return dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        this.verifyLayout(parent);
        Object object = parent.getTreeLock();
        synchronized (object) {
            if (this.m_debug || LOG.isDebugEnabled()) {
                this.dumpLayoutInfo(parent);
            }
            Dimension size = parent.getSize();
            Rectangle[][] cellBounds = this.m_info.layoutCellBounds(size, parent.getInsets());
            if (!SwingUtility.IS_JAVA_7_OR_GREATER && SwingUtility.DO_RESET_COMPONENT_BOUNDS) {
                SwingUtility.setZeroBounds(parent.getComponents());
            }
            int n = this.m_info.components.length;
            int i = 0;
            while (i < n) {
                Component comp = this.m_info.components[i];
                LogicalGridData data = this.m_info.gridDatas[i];
                Rectangle r1 = cellBounds[data.gridy][data.gridx];
                Rectangle r2 = cellBounds[data.gridy + data.gridh - 1][data.gridx + data.gridw - 1];
                Rectangle r = r1.union(r2);
                if (data.topInset > 0) {
                    r.y += data.topInset;
                    r.height -= data.topInset;
                }
                if (!data.fillHorizontal || !data.fillVertical) {
                    int delta;
                    Dimension d = comp.getPreferredSize();
                    if (!data.fillHorizontal && d.width < r.width) {
                        delta = r.width - d.width;
                        r.width = d.width;
                        if (data.horizontalAlignment == 0) {
                            r.x = (int)((double)r.x + Math.ceil((double)delta / 2.0));
                        } else if (data.horizontalAlignment > 0) {
                            r.x += delta;
                        }
                    }
                    if (!data.fillVertical && d.height < r.height) {
                        delta = r.height - d.height;
                        r.height = data.heightHint == 0 ? d.height : data.heightHint;
                        if (data.verticalAlignment == 0) {
                            r.y = (int)((double)r.y + Math.ceil((double)delta / 2.0));
                        } else if (data.verticalAlignment > 0) {
                            r.y += delta;
                        }
                    }
                }
                comp.setBounds(r);
                ++i;
            }
        }
    }
}

