/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DesktopManager;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.shared.data.basic.BoundsSpec;
import org.eclipse.scout.rt.ui.swing.SingleLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.SwingScoutAction;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.basic.WidgetPrinter;
import org.eclipse.scout.rt.ui.swing.ext.BorderLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.ComponentSpyAction;
import org.eclipse.scout.rt.ui.swing.ext.JFrameEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JRootPaneEx;
import org.eclipse.scout.rt.ui.swing.focus.SwingScoutFocusTraversalPolicy;
import org.eclipse.scout.rt.ui.swing.window.desktop.ISwingScoutDesktop;
import org.eclipse.scout.rt.ui.swing.window.desktop.ISwingScoutRootFrame;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.MultiSplitDesktopManager;
import org.eclipse.scout.rt.ui.swing.window.desktop.menubar.SwingScoutMenuBar;
import org.eclipse.scout.rt.ui.swing.window.desktop.status.SwingScoutStatusBar;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.SwingScoutHeaderPanel;
import org.eclipse.scout.rt.ui.swing.window.desktop.tray.ISwingScoutTray;

public class SwingScoutRootFrame
extends SwingScoutComposite<IDesktop>
implements ISwingScoutRootFrame {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutRootFrame.class);
    private Frame m_swingFrame;
    private JRootPane m_swingRootPane;
    private P_ScoutDesktopListener m_scoutDesktopListener;
    private ISwingScoutDesktop m_swingScoutDesktop;
    private SwingScoutMenuBar m_menuBarComposite;
    private SwingScoutHeaderPanel m_swingScoutHeaderPanel;
    private SwingScoutStatusBar m_statusBarComposite;
    private String m_title;
    private IKeyStroke[] m_installedScoutKs;

    public SwingScoutRootFrame(Frame frame) {
        this.m_swingFrame = frame;
        if (this.m_swingFrame instanceof RootPaneContainer) {
            this.m_swingRootPane = ((RootPaneContainer)((Object)this.m_swingFrame)).getRootPane();
        } else {
            this.m_swingRootPane = new JRootPaneEx();
            this.m_swingFrame.removeAll();
            this.m_swingFrame.add(this.m_swingRootPane);
        }
        this.m_swingRootPane.putClientProperty("SwingBusyIndicator.busySupported", true);
    }

    @Override
    protected void initializeSwing() {
        if (this.m_swingFrame instanceof JFrame) {
            this.m_swingFrame.setState(0);
            this.m_swingFrame.setResizable(true);
            ((JFrame)this.m_swingFrame).setDefaultCloseOperation(0);
        }
        SwingUtility.installFocusCycleRoot(this.m_swingRootPane, new SwingScoutFocusTraversalPolicy());
        this.m_swingFrame.addWindowListener(new P_SwingWindowListener());
        if (this.isShowMenuBar()) {
            this.m_menuBarComposite = new SwingScoutMenuBar();
            this.m_menuBarComposite.createField((IDesktop)this.getScoutObject(), this.getSwingEnvironment());
            if (!this.m_menuBarComposite.isEmpty()) {
                JMenuBar menuBar = this.m_menuBarComposite.getSwingMenuBar();
                if (this.m_swingFrame instanceof JFrame) {
                    ((JFrame)this.m_swingFrame).setJMenuBar(menuBar);
                } else {
                    this.m_swingRootPane.setJMenuBar(menuBar);
                }
            }
        }
        Container contentPane = this.m_swingRootPane.getContentPane();
        contentPane.removeAll();
        contentPane.setLayout(new BorderLayoutEx(0, 0));
        this.m_swingScoutHeaderPanel = this.createSwingScoutHeaderPanel();
        this.m_swingScoutHeaderPanel.createField((IDesktop)this.getScoutObject(), this.getSwingEnvironment());
        if (!this.m_swingScoutHeaderPanel.isEmpty()) {
            JComponent swingHeaderPanel = this.m_swingScoutHeaderPanel.getSwingField();
            contentPane.add((Component)swingHeaderPanel, "North");
        }
        JPanelEx spacerPanel = new JPanelEx();
        if (!SwingUtility.isSynth()) {
            spacerPanel.setBorder(new EmptyBorder(0, 1, 3, 1));
        }
        spacerPanel.setName("RootFrame.Spacer");
        spacerPanel.setLayout(new SingleLayout());
        if (UIManager.get("desktop") != null) {
            spacerPanel.setBackground(UIManager.getColor("desktop"));
        }
        this.m_swingScoutDesktop = this.getSwingEnvironment().createDesktop(this.m_swingFrame, (IDesktop)this.getScoutObject());
        JDesktopPane desktopPane = this.m_swingScoutDesktop.getSwingDesktopPane();
        desktopPane.setCursor(null);
        spacerPanel.add(desktopPane);
        contentPane.add((Component)spacerPanel, "Center");
        if (this.isShowStatusBar()) {
            this.m_statusBarComposite = new SwingScoutStatusBar(0);
            this.m_statusBarComposite.createField((IDesktop)this.getScoutObject(), this.getSwingEnvironment());
            contentPane.add((Component)this.m_statusBarComposite.getSwingStatusBar(), "South");
        }
        this.m_swingFrame.pack();
        if (this.m_swingFrame instanceof JFrame) {
            JComponent comp = (JComponent)((JFrame)this.m_swingFrame).getContentPane();
            comp.getInputMap(1).put(SwingUtility.createKeystroke("ctrl TAB"), "selectFirstFrame");
            comp.getActionMap().put("selectFirstFrame", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JInternalFrame[] a;
                    if (SwingScoutRootFrame.this.m_swingScoutDesktop != null && (a = SwingScoutRootFrame.this.m_swingScoutDesktop.getSwingDesktopPane().getAllFrames()) != null && a.length > 0) {
                        a[0].getContentPane().transferFocus();
                    }
                }
            });
            ClientUIPreferences prefs = ClientUIPreferences.getInstance((IClientSession)this.getSwingEnvironment().getScoutSession());
            Rectangle r = SwingUtility.createRectangle(prefs.getApplicationWindowBounds());
            if (r != null) {
                r = SwingUtility.validateRectangleOnScreen(r, false, false);
            }
            boolean maximized = prefs.getApplicationWindowMaximized();
            if (r == null) {
                r = SwingUtility.getFullScreenBoundsFor(new Rectangle(0, 0, 1, 1), false);
                r.grow(-120, -80);
            }
            this.m_swingFrame.setBounds(r);
            if (maximized) {
                this.m_swingFrame.setExtendedState(this.m_swingFrame.getExtendedState() | 6);
            }
        }
        if (contentPane instanceof JComponent) {
            ((JComponent)contentPane).getInputMap(1).put(SwingUtility.createKeystroke("shift alt F1"), "componentSpy");
            ((JComponent)contentPane).getActionMap().put("componentSpy", new ComponentSpyAction());
        }
    }

    private boolean isShowMenuBar() {
        String s = UIManager.getString("MenuBar.policy");
        return s == null || s.equals("menubar");
    }

    private boolean isShowStatusBar() {
        Boolean b = (Boolean)UIManager.get("StatusBar.visible");
        return b == null || b != false;
    }

    @Override
    public Frame getSwingFrame() {
        return this.m_swingFrame;
    }

    @Override
    public ISwingScoutDesktop getDesktopComposite() {
        return this.m_swingScoutDesktop;
    }

    public SwingScoutHeaderPanel getSwingScoutHeaderPanel() {
        return this.m_swingScoutHeaderPanel;
    }

    @Override
    public void showSwingFrame() {
        this.m_swingFrame.setVisible(true);
    }

    @Override
    public void setSwingStatus(IProcessingStatus newStatus) {
        if (this.m_statusBarComposite != null) {
            this.m_statusBarComposite.setSwingStatus(newStatus);
        }
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.m_scoutDesktopListener != null) {
            ((IDesktop)this.getScoutObject()).removeDesktopListener((DesktopListener)this.m_scoutDesktopListener);
            this.m_scoutDesktopListener = null;
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.m_scoutDesktopListener == null) {
            this.m_scoutDesktopListener = new P_ScoutDesktopListener();
            ((IDesktop)this.getScoutObject()).addDesktopListener((DesktopListener)this.m_scoutDesktopListener);
        }
        IDesktop f = (IDesktop)this.getScoutObject();
        this.setTitleFromScout(f.getTitle());
        this.setKeyStrokesFromScout();
    }

    protected void setTitleFromScout(String s) {
        this.m_title = s == null ? "" : s;
        this.m_swingFrame.setTitle(this.m_title);
    }

    protected void setKeyStrokesFromScout() {
        JComponent component = (JComponent)this.m_swingRootPane.getContentPane();
        if (component != null) {
            IKeyStroke[] scoutKeyStrokes;
            IKeyStroke scoutKs;
            if (this.m_installedScoutKs != null) {
                int i = 0;
                while (i < this.m_installedScoutKs.length) {
                    scoutKs = this.m_installedScoutKs[i];
                    KeyStroke swingKs = SwingUtility.createKeystroke(scoutKs);
                    InputMap imap = component.getInputMap(2);
                    imap.remove(swingKs);
                    ActionMap amap = component.getActionMap();
                    amap.remove(scoutKs.getActionId());
                    ++i;
                }
            }
            this.m_installedScoutKs = null;
            IKeyStroke[] iKeyStrokeArray = scoutKeyStrokes = ((IDesktop)this.getScoutObject()).getKeyStrokes();
            int n = scoutKeyStrokes.length;
            int n2 = 0;
            while (n2 < n) {
                scoutKs = iKeyStrokeArray[n2];
                int swingWhen = 2;
                KeyStroke swingKs = SwingUtility.createKeystroke(scoutKs);
                SwingScoutAction<IKeyStroke> action = new SwingScoutAction<IKeyStroke>();
                action.createField(scoutKs, this.getSwingEnvironment());
                InputMap imap = component.getInputMap(swingWhen);
                imap.put(swingKs, scoutKs.getActionId());
                ActionMap amap = component.getActionMap();
                amap.put(scoutKs.getActionId(), action.getSwingAction());
                ++n2;
            }
            this.m_installedScoutKs = scoutKeyStrokes;
        }
    }

    protected void setStatusFromScout() {
        if (this.getScoutObject() != null) {
            IProcessingStatus newStatus = ((IDesktop)this.getScoutObject()).getStatus();
            TrayIcon trayItem = null;
            ISwingScoutTray trayComposite = this.getSwingEnvironment().getTrayComposite();
            if (trayComposite != null) {
                trayItem = trayComposite.getSwingTrayIcon();
            }
            if (trayItem != null) {
                String text;
                String title = newStatus != null ? newStatus.getTitle() : null;
                String string = text = newStatus != null ? newStatus.getMessage() : null;
                if (newStatus != null && text != null) {
                    TrayIcon.MessageType iconId;
                    switch (newStatus.getSeverity()) {
                        case 4: 
                        case 16: {
                            iconId = TrayIcon.MessageType.ERROR;
                            break;
                        }
                        case 2: {
                            iconId = TrayIcon.MessageType.WARNING;
                            break;
                        }
                        case 1: {
                            iconId = TrayIcon.MessageType.INFO;
                            break;
                        }
                        default: {
                            iconId = TrayIcon.MessageType.NONE;
                        }
                    }
                    trayItem.displayMessage(title, text, iconId);
                }
            } else {
                this.setSwingStatus(newStatus);
            }
        }
    }

    protected void handleSwingWindowOpened(WindowEvent e) {
        DesktopManager dm;
        if (this.getDesktopComposite() != null && (dm = this.getDesktopComposite().getSwingDesktopPane().getDesktopManager()) instanceof MultiSplitDesktopManager) {
            ((MultiSplitDesktopManager)dm).fitFrames(this.getDesktopComposite().getSwingDesktopPane().getAllFrames());
        }
    }

    protected void handleSwingWindowActivated(WindowEvent e) {
    }

    protected void handleSwingWindowClosing(WindowEvent e) {
        boolean ok;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner != null && focusOwner instanceof JComponent && ((JComponent)focusOwner).getInputVerifier() != null && !(ok = ((JComponent)focusOwner).getInputVerifier().verify((JComponent)focusOwner))) {
            return;
        }
        boolean maximized = (this.m_swingFrame.getExtendedState() & 6) != 0;
        Rectangle r = this.m_swingFrame.getBounds();
        if (maximized) {
            if (this.m_swingFrame instanceof JFrameEx) {
                r = ((JFrameEx)this.m_swingFrame).getNonMaximizedBounds();
                if (r == null) {
                    r = this.m_swingFrame.getBounds();
                }
            } else {
                this.m_swingFrame.setExtendedState(0);
                r = this.m_swingFrame.getBounds();
            }
        }
        ClientUIPreferences.getInstance((IClientSession)this.getSwingEnvironment().getScoutSession()).setApplicationWindowPreferences(r != null ? new BoundsSpec(r.x, r.y, r.width, r.height) : null, maximized);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IDesktop)SwingScoutRootFrame.this.getScoutObject()).getUIFacade().fireDesktopClosingFromUI();
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    protected void handleScoutDesktopClosedInSwing(DesktopEvent e) {
        this.disconnectFromScout();
        this.m_swingFrame.dispose();
    }

    protected void handleScoutPrintInSwing(DesktopEvent e) {
        block5: {
            WidgetPrinter cp = new WidgetPrinter(this.getSwingFrame());
            try {
                try {
                    cp.print(e.getPrintDevice(), e.getPrintParameters());
                }
                catch (Throwable ex) {
                    LOG.error(null, ex);
                    Runnable r = new Runnable(cp){
                        private final /* synthetic */ WidgetPrinter val$cp;
                        {
                            this.val$cp = widgetPrinter;
                        }

                        @Override
                        public void run() {
                            ((IDesktop)SwingScoutRootFrame.this.getScoutObject()).getUIFacade().fireDesktopPrintedFromUI(this.val$cp.getOutputFile());
                        }
                    };
                    this.getSwingEnvironment().invokeScoutLater(r, 0L);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Runnable r = new /* invalid duplicate definition of identical inner class */;
                this.getSwingEnvironment().invokeScoutLater(r, 0L);
                throw throwable;
            }
            Runnable r = new /* invalid duplicate definition of identical inner class */;
            this.getSwingEnvironment().invokeScoutLater(r, 0L);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if ("title".equals(name)) {
            this.setTitleFromScout((String)newValue);
        } else if ("keyStrokes".equals(name)) {
            this.setKeyStrokesFromScout();
        } else if ("status".equals(name)) {
            this.setStatusFromScout();
        }
    }

    protected SwingScoutHeaderPanel createSwingScoutHeaderPanel() {
        return new SwingScoutHeaderPanel();
    }

    private class P_ScoutDesktopListener
    implements DesktopListener {
        private P_ScoutDesktopListener() {
        }

        public void desktopChanged(final DesktopEvent e) {
            switch (e.getType()) {
                case 100: 
                case 900: {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            switch (e.getType()) {
                                case 900: {
                                    SwingScoutRootFrame.this.handleScoutPrintInSwing(e);
                                    break;
                                }
                                case 100: {
                                    SwingScoutRootFrame.this.handleScoutDesktopClosedInSwing(e);
                                }
                            }
                        }
                    };
                    SwingScoutRootFrame.this.getSwingEnvironment().invokeSwingLater(t);
                }
            }
        }
    }

    private class P_SwingWindowListener
    extends WindowAdapter {
        private P_SwingWindowListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            SwingScoutRootFrame.this.handleSwingWindowOpened(e);
        }

        @Override
        public void windowActivated(WindowEvent e) {
            SwingScoutRootFrame.this.handleSwingWindowActivated(e);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SwingScoutRootFrame.this.handleSwingWindowClosing(e);
        }
    }
}

