/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.widgets;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.scout.rt.client.ui.basic.calendar.DateTimeFormatFactory;
import org.eclipse.scout.rt.ui.swt.basic.calendar.layout.MonthCellData;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.AbstractCell;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.SwtCalendar;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class MonthCell
extends AbstractCell
implements TraverseListener {
    public MonthCell(Composite parent, int style, SwtCalendar calendar, Date cellDate, boolean isFirstColumn, boolean isCurrentMonth) {
        super(parent, style);
        this.setCalendar(calendar);
        this.setDate(Calendar.getInstance());
        this.getDate().setTime(cellDate);
        this.setFirstColumn(isFirstColumn);
        this.setCurrentPeriod(isCurrentMonth);
        this.setSelectedInternal(false);
        this.createControls();
        this.setVisualState();
        this.addCalendarItems();
        this.hookListeners();
    }

    public void keyTraversed(TraverseEvent e) {
    }

    protected void createControls() {
        int vertSpan = 2;
        int day = this.getDate().get(7);
        int firstDay = this.getCalendar().getFirstDayOfWeek();
        int weekEndDay1 = (firstDay - 1 + 5) % 7 + 1;
        int weekEndDay2 = (firstDay - 1 + 6) % 7 + 1;
        if (this.getCalendar().getCondensedMode() && (day == weekEndDay1 || day == weekEndDay2)) {
            vertSpan = 1;
        }
        MonthCellData cd = new MonthCellData();
        cd.setVerticalSpan(vertSpan);
        this.setLayoutData(cd);
        GridLayout layout = new GridLayout();
        layout.marginTop = 12;
        layout.marginWidth = 2;
        layout.marginHeight = 3;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 1;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
    }

    @Override
    protected void drawLabels(PaintEvent e) {
        if (this.isFirstColumn()) {
            this.drawWeekLabel(e);
        }
        this.drawDayLabel(e);
    }

    @Override
    public String toString() {
        SimpleDateFormat weekDayFmt = new SimpleDateFormat("EEEEE", Locale.getDefault());
        DateFormat dateFmt = new DateTimeFormatFactory().getDayMonthYear(1);
        return "MonthCell {" + weekDayFmt.format(this.getDate().getTime()) + " " + dateFmt.format(this.getDate().getTime()) + "}";
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

