/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.tabbox;

import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.form.fields.groupbox.SwtScoutGroupBox;
import org.eclipse.scout.rt.ui.swt.form.fields.tabbox.ISwtScoutTabItem;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SwtScoutTabItem
extends SwtScoutGroupBox
implements ISwtScoutTabItem {
    private CTabItem m_tabItem;
    private Image m_tabImage;
    private boolean m_uiFocus;

    private int getVisibleIndex() {
        int res = -1;
        IGroupBox groupBox = (IGroupBox)this.getScoutObject();
        if (groupBox != null && groupBox.getParentField() != null) {
            IFormField[] iFormFieldArray = groupBox.getParentField().getFields();
            int n = iFormFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField box = iFormFieldArray[n2];
                if (box.isVisible()) {
                    ++res;
                    if (box == groupBox) break;
                }
                ++n2;
            }
        }
        return res;
    }

    @Override
    protected void initializeSwt(Composite parent) {
        CTabFolder folder = (CTabFolder)parent;
        folder.setLayout((Layout)new FillLayout());
        int tabItemCount = folder.getItemCount();
        int index = this.getVisibleIndex();
        this.m_tabItem = index >= 0 && index <= tabItemCount ? new CTabItem(folder, 0, index) : new CTabItem(folder, 0, tabItemCount);
        this.m_tabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SwtScoutTabItem.this.freeResources();
            }
        });
        super.initializeSwt((Composite)folder);
        this.m_tabItem.setControl((Control)this.getSwtContainer());
        this.updateImage();
    }

    protected void freeResources() {
        if (this.m_tabImage != null && !this.m_tabImage.isDisposed()) {
            this.m_tabImage.dispose();
            this.m_tabImage = null;
        }
    }

    protected CTabItem getTabItem() {
        return this.m_tabItem;
    }

    @Override
    protected void setSaveNeededFromScout(boolean b) {
        this.updateImage();
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        this.updateImage();
    }

    protected void setEmptyFromScout(boolean b) {
        this.updateImage();
    }

    @Override
    protected void setLabelFromScout(String s) {
        this.updateImage();
    }

    @Override
    protected void setFontFromScout(FontSpec scoutFont) {
        super.setFontFromScout(scoutFont);
        this.m_tabItem.setFont(this.getEnvironment().getFont(scoutFont, this.m_tabItem.getFont()));
    }

    public void setUiFocus(boolean b) {
        if (this.isDisposed() || this.getTabItem().isDisposed()) {
            return;
        }
        this.m_uiFocus = b;
        this.updateImage();
    }

    private void updateImage() {
        GC gc = null;
        Point imageSize = new Point(15, 100);
        String label = ((IGroupBox)this.getScoutObject()).getLabel();
        if (label == null) {
            label = "";
        }
        try {
            gc = new GC((Drawable)this.getSwtContainer());
            gc.setFont(this.getEnvironment().getFont(((IGroupBox)this.getScoutObject()).getFont(), this.getTabItem().getFont()));
            Point stringSize = gc.stringExtent(label);
            imageSize.x = stringSize.x + 10;
            imageSize.y = stringSize.y + 3;
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        Image img = new Image((Device)this.getTabItem().getDisplay(), imageSize.x, imageSize.y);
        ImageData data = img.getImageData();
        data.transparentPixel = data.palette.getPixel(new RGB(255, 255, 255));
        try {
            gc = new GC((Drawable)img);
            gc.setAdvanced(true);
            gc.setBackground(this.getSwtContainer().getDisplay().getSystemColor(1));
            gc.fillRectangle(0, 0, imageSize.x, imageSize.y);
            if (this.m_uiFocus) {
                gc.setBackground(this.getSwtContainer().getDisplay().getSystemColor(17));
                gc.setLineDash(new int[]{2, 1});
                gc.drawRoundRectangle(0, 0, imageSize.x - 1, imageSize.y - 1, 2, 2);
            }
            boolean isUnderline = false;
            if (((IGroupBox)this.getScoutObject()).getParentField() instanceof ITabBox) {
                if (((ITabBox)((IGroupBox)this.getScoutObject()).getParentField()).getMarkStrategy() == 1 && ((IGroupBox)this.getScoutObject()).isSaveNeeded()) {
                    isUnderline = true;
                } else if (((ITabBox)((IGroupBox)this.getScoutObject()).getParentField()).getMarkStrategy() == 0 && !((IGroupBox)this.getScoutObject()).isEmpty()) {
                    isUnderline = true;
                }
            } else if (((IGroupBox)this.getScoutObject()).getForm() instanceof ISearchForm && ((IGroupBox)this.getScoutObject()).isSaveNeeded()) {
                isUnderline = true;
            } else if (!(((IGroupBox)this.getScoutObject()).getForm() instanceof ISearchForm) && !((IGroupBox)this.getScoutObject()).isEmpty()) {
                isUnderline = true;
            }
            if (isUnderline) {
                gc.setForeground(this.getSwtContainer().getDisplay().getSystemColor(1));
                gc.setBackground(this.getSwtContainer().getDisplay().getSystemColor(8));
                gc.fillGradientRectangle(4, imageSize.y - 5, imageSize.x - 8, imageSize.y, true);
            }
            gc.setFont(this.getEnvironment().getFont(((IGroupBox)this.getScoutObject()).getFont(), this.getTabItem().getFont()));
            if (((IGroupBox)this.getScoutObject()).isEnabled()) {
                gc.setForeground(this.getSwtContainer().getDisplay().getSystemColor(2));
            } else {
                String colorDisabled = UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled();
                gc.setForeground(this.getEnvironment().getColor(colorDisabled));
            }
            gc.drawText(label, 5, 0, true);
        }
        finally {
            if (gc != null && !gc.isDisposed()) {
                gc.dispose();
            }
        }
        this.getTabItem().setImage(img);
        if (this.m_tabImage != null && !this.m_tabImage.isDisposed()) {
            this.m_tabImage.dispose();
        }
        this.m_tabImage = img;
    }
}

