/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.widgets;

import org.eclipse.scout.rt.ui.swt.basic.calendar.CalendarItemContainer;
import org.eclipse.scout.rt.ui.swt.basic.calendar.SwtColors;
import org.eclipse.scout.rt.ui.swt.basic.calendar.layout.WeekItemData;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.AbstractCalendarItem;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.AbstractCell;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.WeekCell;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Rectangle;

public class WeekCalendarItem
extends AbstractCalendarItem {
    private int m_timelessIndex = -1;

    public WeekCalendarItem(AbstractCell parent, int style, CalendarItemContainer item) {
        super(parent, style, item);
    }

    public void setLayoutData() {
        int timelessIndex = 0;
        if (!this.getItem().isTimed()) {
            timelessIndex = ((WeekCell)this.getCell()).getNextTimelessCounter();
        }
        WeekItemData wid = new WeekItemData();
        wid.setItem(this.getItem());
        wid.setTimelessCount(this.getCell().getCountTimelessItems());
        wid.setTimelessMaxCount(this.getCell().getCalendar().getCentralPanel().getTimelessMaxCount());
        wid.setTimelessIndex(timelessIndex);
        wid.setOffsetCellHeader(this.getCell().getCalendar().getDisplayMode() == 1 ? 0 : 13);
        this.setLayoutData(wid);
    }

    @Override
    protected void createControls() {
    }

    @Override
    protected void setLayout() {
    }

    @Override
    protected void hookListeners() {
        super.hookListeners();
    }

    protected void drawLabel(PaintEvent e) {
        Rectangle bounds = this.getBounds();
        Rectangle rlabel = new Rectangle(0, 0, bounds.width, bounds.height);
        this.getItem().setLabeled(true);
        FontMetrics fm = e.gc.getFontMetrics();
        if (this.getItem().isLabeled()) {
            String s = this.getCell().getCalendar().getModel().getLabel(this.getItem().getItem(), this.getCell().getDate().getTime());
            int centery = Math.max(0, (rlabel.height - fm.getAscent()) / 2 - 3);
            e.gc.drawString(s, rlabel.x + 3, rlabel.y + centery);
        }
    }

    @Override
    public void paintControl(PaintEvent e) {
        Color color = new Color((Device)SwtColors.getStandardDisplay(), this.getItem().getColor().getRed(), this.getItem().getColor().getGreen(), this.getItem().getColor().getBlue());
        if (this.getItem().getItem().equals(this.getCell().getCalendar().getSelectedItem())) {
            color = SwtColors.getInstance().getDarker(color);
        }
        this.setBackground(color);
        this.drawLabel(e);
    }
}

