/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.scout.rt.ui.swt.util.listener.DndAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;

public class StyledTextEx
extends StyledText {
    private Listener m_traversHandlingListener = new P_TraverseHandlingListener();
    private Menu m_copyPasteMenu;
    private MenuItem m_cutItem;
    private MenuItem m_copyItem;
    private MenuItem m_pasteItem;

    public StyledTextEx(Composite parent, int style) {
        super(parent, style);
        if ((style & 0x200) != 0) {
            this.addListener(24, this.m_traversHandlingListener);
            this.updateVerticalScrollbarVisibility();
        }
        if ((style & 2) != 0) {
            this.attachListeners();
        }
        this.m_copyPasteMenu = new Menu((Decorations)this.getShell(), 8);
        this.m_copyPasteMenu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                if (StyledTextEx.this.isEnabled()) {
                    StyledTextEx.this.m_cutItem.setEnabled(StringUtility.hasText((String)StyledTextEx.this.getSelectionText()) && StyledTextEx.this.getEditable());
                    StyledTextEx.this.m_pasteItem.setEnabled(StyledTextEx.this.getEditable());
                }
            }
        });
        this.m_cutItem = new MenuItem(this.m_copyPasteMenu, 8);
        this.m_cutItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyledTextEx.this.cut();
            }
        });
        this.m_cutItem.setText(SwtUtility.getNlsText(Display.getCurrent(), "Cut", new String[0]));
        this.m_copyItem = new MenuItem(this.m_copyPasteMenu, 8);
        this.m_copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StyledTextEx.this.isEnabled()) {
                    StyledTextEx.this.copy();
                } else {
                    boolean hasSelection = StringUtility.hasText((String)StyledTextEx.this.getSelectionText());
                    if (hasSelection) {
                        StyledTextEx.this.copy();
                    } else {
                        StyledTextEx.this.setSelection(0, StyledTextEx.this.getText().length());
                        StyledTextEx.this.copy();
                        StyledTextEx.this.setCaretOffset(0);
                    }
                }
            }
        });
        this.m_copyItem.setText(SwtUtility.getNlsText(Display.getCurrent(), "Copy", new String[0]));
        this.m_pasteItem = new MenuItem(this.m_copyPasteMenu, 8);
        this.m_pasteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyledTextEx.this.paste();
            }
        });
        this.m_pasteItem.setText(SwtUtility.getNlsText(Display.getCurrent(), "Paste", new String[0]));
        P_DndListener dndListener = new P_DndListener();
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 7;
        DropTarget dropTarget = new DropTarget((Control)this, operations);
        dropTarget.getTransfer();
        dropTarget.setTransfer(types);
        dropTarget.addDropListener((DropTargetListener)dndListener);
        DragSource dragSource = new DragSource((Control)this, operations);
        dragSource.setTransfer(types);
        dragSource.addDragListener((DragSourceListener)dndListener);
        this.setEnabled(true);
    }

    protected void checkSubclass() {
    }

    public void setEnabled(boolean enabled) {
        Composite parent;
        super.setEnabled(enabled);
        if (!this.isDisposed()) {
            if (enabled) {
                this.m_cutItem.setEnabled(true);
                this.m_copyItem.setEnabled(true);
                this.m_pasteItem.setEnabled(true);
                this.setMenu(this.m_copyPasteMenu);
            } else {
                this.setMenu(null);
            }
        }
        if ((parent = this.getParent()) != null && !parent.isDisposed()) {
            if (enabled) {
                parent.setMenu(null);
            } else {
                this.m_cutItem.setEnabled(false);
                this.m_copyItem.setEnabled(true);
                this.m_pasteItem.setEnabled(false);
                parent.setMenu(this.m_copyPasteMenu);
            }
        }
    }

    protected void attachListeners() {
        this.addListener(31, this.m_traversHandlingListener);
        this.addListener(25, this.m_traversHandlingListener);
    }

    protected void dettachListeners() {
        this.removeListener(31, this.m_traversHandlingListener);
        this.removeListener(25, this.m_traversHandlingListener);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.updateVerticalScrollbarVisibility();
    }

    protected void updateVerticalScrollbarVisibility() {
        Rectangle clientArea = this.getClientArea();
        Point size = this.computeSize(clientArea.width, -1, false);
        ScrollBar vBar = this.getVerticalBar();
        if (vBar != null && !vBar.isDisposed()) {
            vBar.setVisible(size.y > clientArea.height);
        }
    }

    private class P_DndListener
    extends DndAdapter {
        private P_DndListener() {
        }

        @Override
        public void drop(DropTargetEvent event) {
            String text;
            if (StyledTextEx.this.getEnabled() && StyledTextEx.this.getEditable() && TextTransfer.getInstance().isSupportedType(event.currentDataType) && (text = (String)event.data) != null) {
                StyledTextEx.this.insert(text);
            }
        }

        @Override
        public void dragSetData(DragSourceEvent event) {
            event.data = StyledTextEx.this.getSelectionText();
        }
    }

    private class P_TraverseHandlingListener
    implements Listener {
        private long m_timestamp;

        private P_TraverseHandlingListener() {
        }

        public void handleEvent(Event event) {
            if (StyledTextEx.this.isDisposed()) {
                return;
            }
            if ((long)event.time == this.m_timestamp) {
                return;
            }
            switch (event.type) {
                case 31: {
                    if (event.keyCode != 9 || event.stateMask != 262144) break;
                    this.m_timestamp = event.time;
                    event.doit = false;
                    break;
                }
                case 25: {
                    if (!event.text.equals("\t") || event.stateMask != 0) break;
                    this.m_timestamp = event.time;
                    event.doit = false;
                    StyledTextEx.this.traverse(16);
                    break;
                }
                case 24: {
                    StyledTextEx.this.updateVerticalScrollbarVisibility();
                    break;
                }
            }
        }
    }
}

