/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.compatibility.v36.internal;

import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.scout.sdk.compatibility.License;
import org.eclipse.scout.sdk.compatibility.internal.ScoutCompatibilityActivator;
import org.eclipse.scout.sdk.compatibility.internal.service.IP2CompatService;

public class P2CompatService
implements IP2CompatService {
    public String getLatestVersion(String rootIU, URI p2RepositoryURI, IProgressMonitor monitor) throws CoreException {
        String[] latestVersions = this.getLatestVersions(new String[]{rootIU}, p2RepositoryURI, monitor);
        if (latestVersions != null && latestVersions.length > 0) {
            return latestVersions[0];
        }
        return null;
    }

    public void promptForRestart() {
        Job dummy = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        ProvisioningUI.getDefaultUI().manageJob(dummy, 3);
        dummy.schedule();
    }

    public void installUnit(String rootIU, URI p2RepositoryURI, IProgressMonitor monitor) throws CoreException {
        IInstallableUnit[] units = this.getInstallableUnits(new String[]{rootIU}, this.getMetadataRepository(p2RepositoryURI, monitor), monitor);
        ArrayList<IInstallableUnit> toInstall = new ArrayList<IInstallableUnit>(units.length);
        IInstallableUnit[] iInstallableUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit iu = iInstallableUnitArray[n2];
            toInstall.add(iu);
            ++n2;
        }
        ProvisioningUI ui = ProvisioningUI.getDefaultUI();
        InstallOperation op = ui.getInstallOperation(toInstall, new URI[]{p2RepositoryURI});
        ProvisioningJob resJob = op.getResolveJob(monitor);
        IStatus resResult = resJob.runModal(monitor);
        if (resResult.isOK()) {
            ProvisioningJob provJob = op.getProvisioningJob(monitor);
            resResult = provJob.runModal(monitor);
            if (!resResult.isOK()) {
                throw new CoreException(resResult);
            }
        } else {
            throw new CoreException(resResult);
        }
    }

    public Map<String, License[]> getLicense(String rootIU, URI p2RepositoryURI, IProgressMonitor monitor) throws CoreException {
        IInstallableUnit[] units = this.getInstallableUnits(new String[]{rootIU}, this.getMetadataRepository(p2RepositoryURI, monitor), monitor);
        HashMap<String, License[]> ret = new HashMap<String, License[]>(units.length);
        IInstallableUnit[] iInstallableUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit iu = iInstallableUnitArray[n2];
            Collection licenses = iu.getLicenses(null);
            ArrayList<License> licList = new ArrayList<License>(licenses.size());
            for (ILicense l : licenses) {
                if (l.getBody() == null || l.getBody().trim().length() <= 0) continue;
                License lic = new License(l.getBody(), iu.getId());
                licList.add(lic);
            }
            ret.put(iu.getId(), licList.toArray(new License[licList.size()]));
            ++n2;
        }
        return ret;
    }

    private String[] getLatestVersions(String[] rootIUs, URI p2RepositoryURI, IProgressMonitor monitor) throws CoreException {
        String[] result = this.getLatestVersions(rootIUs, this.getMetadataRepository(p2RepositoryURI, monitor), monitor);
        return result;
    }

    private IMetadataRepository getMetadataRepository(URI p2RepositoryURI, IProgressMonitor monitor) throws CoreException {
        IProvisioningAgent agent = this.getAgent();
        IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IMetadataRepository metadataRepository = this.loadRepository(p2RepositoryURI, repoManager, monitor);
        return metadataRepository;
    }

    private IProvisioningAgent getAgent() throws CoreException {
        IPath stateLocation = ScoutCompatibilityActivator.getDefault().getStateLocation();
        URI stateLocationURI = stateLocation.toFile().toURI();
        IProvisioningAgentProvider agentProvider = (IProvisioningAgentProvider)ScoutCompatibilityActivator.getDefault().acquireService(IProvisioningAgentProvider.SERVICE_NAME);
        if (agentProvider == null) {
            Status status = new Status(4, "org.eclipse.scout.sdk.compatibility", "Agent provider service not available");
            throw new CoreException((IStatus)status);
        }
        return agentProvider.createAgent(stateLocationURI);
    }

    private IMetadataRepository loadRepository(URI p2RepositoryURI, IMetadataRepositoryManager repoManager, IProgressMonitor monitor) throws CoreException {
        IMetadataRepository result;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            SubMonitor repositoryMonitor = subMonitor.newChild(1);
            result = repoManager.loadRepository(p2RepositoryURI, (IProgressMonitor)repositoryMonitor);
        }
        catch (ProvisionException e) {
            String message = "Failed to load repository <{0}>";
            Object[] arguments = new Object[]{p2RepositoryURI};
            String fmtMessage = MessageFormat.format(message, arguments);
            Status status = new Status(4, "org.eclipse.scout.sdk.compatibility", fmtMessage, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        return result;
    }

    private IInstallableUnit[] getInstallableUnits(String[] rootIUs, IMetadataRepository metadataRepository, IProgressMonitor monitor) throws CoreException {
        IInstallableUnit[] result = new IInstallableUnit[rootIUs.length];
        int i = 0;
        while (i < rootIUs.length) {
            IInstallableUnit iu;
            String rootIuId = rootIUs[i];
            IQuery latestQuery = QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)rootIuId));
            IQueryResult queryResult = metadataRepository.query(latestQuery, monitor);
            if (queryResult.isEmpty()) {
                String messag = "Feature <{0}> not found";
                Object[] arguments = new Object[]{rootIuId};
                String fmtMessage = MessageFormat.format(messag, arguments);
                Status status = new Status(4, "org.eclipse.scout.sdk.compatibility", fmtMessage);
                throw new CoreException((IStatus)status);
            }
            Iterator iterator = queryResult.iterator();
            result[i] = iu = (IInstallableUnit)iterator.next();
            ++i;
        }
        return result;
    }

    private String[] getLatestVersions(String[] rootIUs, IMetadataRepository metadataRepository, IProgressMonitor monitor) throws CoreException {
        IInstallableUnit[] units = this.getInstallableUnits(rootIUs, metadataRepository, monitor);
        String[] result = new String[units.length];
        int i = 0;
        while (i < result.length) {
            result[i] = units[i].getVersion().toString();
            ++i;
        }
        return result;
    }
}

