/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.rap.ui.internal.extensions.bundle;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.compatibility.internal.PlatformVersionUtility;
import org.eclipse.scout.sdk.rap.ui.internal.wizard.project.RapTargetPlatformWizardPage;
import org.eclipse.scout.sdk.ui.extensions.bundle.IScoutBundleProvider;
import org.eclipse.scout.sdk.ui.extensions.project.IScoutBundleExtension;
import org.eclipse.scout.sdk.ui.wizard.project.IScoutProjectWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.osgi.framework.Version;

public class RapScoutBundleExtension
implements IScoutBundleProvider {
    private boolean m_rapUiSelected = true;
    public static final String ID = "org.eclipse.scout.sdk.ui.UiRapBundle";

    public void init(IScoutProjectWizard wizard, IScoutProject project) {
        IScoutBundle[] rapUi = project.getAllBundles(8);
        boolean available = rapUi == null || rapUi.length == 0;
        wizard.getProjectWizardPage().setBundleNodeAvailable(available, new String[]{ID});
    }

    public IStatus getStatus(IScoutProjectWizard wizard) {
        if (!wizard.getProjectWizardPage().hasSelectedBundle(new IScoutBundleExtension.BundleTypes[]{IScoutBundleExtension.BundleTypes.Client_Bundle})) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoRapWithoutClient"));
        }
        if (this.m_rapUiSelected && PlatformVersionUtility.getPlatformVersion().compareTo((Object)new Version(3, 6, 0)) < 0) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoRapBeforeHelios"));
        }
        return Status.OK_STATUS;
    }

    public void bundleSelectionChanged(IScoutProjectWizard wizard, boolean selected) {
        this.m_rapUiSelected = selected;
        Object page = wizard.getPage(RapTargetPlatformWizardPage.class.getName());
        if (page == null) {
            page = new RapTargetPlatformWizardPage();
            wizard.addPage((IWizardPage)page);
        }
        page.setExcludePage(!selected);
    }
}

