/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.rap.ui.internal.extensions.export;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.sdk.operation.export.ExportServerWarOperation;
import org.eclipse.scout.sdk.rap.ui.internal.wizard.export.ExportRapWizardPage;
import org.eclipse.scout.sdk.ui.extensions.export.IExportScoutProjectEntryHandler;
import org.eclipse.scout.sdk.ui.wizard.export.IExportScoutProjectWizard;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class RapExportEntryHandler
implements IExportScoutProjectEntryHandler {
    public static final String ID = "ui.rap";

    public IStatus getStatus(IExportScoutProjectWizard wizard) {
        return Status.OK_STATUS;
    }

    public boolean isAvailable(IExportScoutProjectWizard wizard) {
        IScoutBundle[] rapBundles = wizard.getProject().getAllBundles(8);
        return rapBundles != null && rapBundles.length > 0;
    }

    public boolean getDefaultSelection() {
        return true;
    }

    public File createModule(IExportScoutProjectWizard wizard, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        try {
            ExportRapWizardPage rapPage = (ExportRapWizardPage)wizard.getPage(ExportRapWizardPage.class.getName());
            File tmpFolder = IOUtility.createTempDirectory((String)"earExportRapBuildDir");
            ExportServerWarOperation op = new ExportServerWarOperation(rapPage.getProductFile());
            op.setWarFileName(new File(tmpFolder, rapPage.getWarName()).getAbsolutePath());
            op.validate();
            op.run(monitor, workingCopyManager);
            return op.getResultingWarFile();
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.scout.sdk.ui", "could not export server war file", (Throwable)e));
        }
    }

    public void selectionChanged(IExportScoutProjectWizard wizard, boolean selected) {
        Object page = wizard.getPage(ExportRapWizardPage.class.getName());
        if (page == null) {
            page = new ExportRapWizardPage(wizard.getProject());
            wizard.addPage((IWizardPage)page);
        }
        page.setExcludePage(!selected);
    }
}

