/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.action.rename.AbstractRenameAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.scout.sdk.util.ScoutSourceUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class FormFieldRenameAction
extends AbstractRenameAction {
    private IType m_formField;

    @Override
    protected void fillTransaction(JdtRenameTransaction transaction, String newName) throws CoreException {
        transaction.add(this.getFormField(), newName);
        IMethod getter = ScoutTypeUtility.getFormFieldGetterMethod((IType)this.getFormField());
        if (TypeUtility.exists((IJavaElement)getter)) {
            transaction.add(getter, "get" + Character.toUpperCase(newName.charAt(0)) + newName.substring(1));
        }
    }

    @Override
    protected IStatus validate(String newName) {
        IStatus inheritedStatus = this.getJavaNameStatus(newName);
        if (inheritedStatus.matches(4)) {
            return inheritedStatus;
        }
        try {
            if (ScoutSourceUtility.findInnerType((IType)this.getFormField().getCompilationUnit().getAllTypes()[0], (String)newName, (boolean)true) != null) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "Name already in use.");
            }
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("error during finding already existing types in form.", e);
            return new Status(4, "org.eclipse.scout.sdk.ui", "Exception in validation (see logfile).");
        }
        return inheritedStatus;
    }

    public IType getFormField() {
        return this.m_formField;
    }

    public void setFormField(IType formField) {
        this.m_formField = formField;
    }
}

