/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.extensions.technology;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.sdk.ui.extensions.technology.IScoutTechnologyHandler;
import org.eclipse.scout.sdk.ui.extensions.technology.IScoutTechnologyResource;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class ScoutTechnologyResource
implements IScoutTechnologyResource {
    private final IScoutBundle m_bundle;
    private final IFile m_resource;
    private IScoutTechnologyHandler m_handler;
    private final boolean m_defaultSelection;

    public ScoutTechnologyResource(IScoutBundle bundle, IFile resource) {
        this(bundle, resource, true);
    }

    public ScoutTechnologyResource(IScoutBundle bundle, IFile resource, boolean defaultSelection) {
        this.m_bundle = bundle;
        this.m_resource = resource;
        this.m_defaultSelection = defaultSelection;
    }

    @Override
    public boolean getDefaultSelection() {
        return this.m_defaultSelection;
    }

    @Override
    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    @Override
    public ImageDescriptor getBundleImage() {
        switch (this.getBundle().getType()) {
            case 3: {
                return ScoutSdkUi.getImageDescriptor("clientBundle.png");
            }
            case 5: {
                return ScoutSdkUi.getImageDescriptor("serverBundle.png");
            }
            case 4: {
                return ScoutSdkUi.getImageDescriptor("sharedBundle.png");
            }
        }
        return ScoutSdkUi.getImageDescriptor("uiBundle.png");
    }

    @Override
    public void setHandler(IScoutTechnologyHandler handler) {
        this.m_handler = handler;
    }

    @Override
    public IScoutTechnologyHandler getHandler() {
        return this.m_handler;
    }

    @Override
    public IFile getResource() {
        return this.m_resource;
    }
}

