/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ResourceServletFolderTree {
    public static int NODE_TYPE_FOLDER = 129;
    private ITreeNode m_rootNode;

    public ResourceServletFolderTree(IScoutProject project) {
        this.m_rootNode = TreeUtility.createBundleTree(project);
        this.initTree(this.m_rootNode);
    }

    public ITreeNode getRootNode() {
        return this.m_rootNode;
    }

    private void initTree(ITreeNode rootNode) {
        ArrayList<P_ResourceServletExtension> extensions = new ArrayList<P_ResourceServletExtension>();
        this.findServletExtensions(rootNode, extensions);
        TreeUtility.findNodes(rootNode, new P_FolderTreeBuilder(extensions.toArray(new P_ResourceServletExtension[extensions.size()])));
    }

    private void findServletExtensions(ITreeNode curentNode, ArrayList<P_ResourceServletExtension> extensions) {
        IPluginExtension[] exs;
        IScoutBundle bundle;
        IPluginModelBase pluginModel;
        IPluginBase pluginBase;
        if (curentNode.getType() > 2 && curentNode.getType() < 8 && (pluginBase = (pluginModel = PluginRegistry.findModel((IProject)(bundle = (IScoutBundle)curentNode.getData()).getProject())).getPluginBase(false)) != null && (exs = pluginBase.getExtensions()) != null && exs.length > 0) {
            IPluginExtension[] iPluginExtensionArray = exs;
            int n = exs.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginExtension e = iPluginExtensionArray[n2];
                if (CompareUtility.equals((Object)"org.eclipse.equinox.http.registry.servlets", (Object)e.getPoint()) && e.getChildCount() > 0) {
                    IPluginObject[] iPluginObjectArray = e.getChildren();
                    int n3 = iPluginObjectArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPluginElement pe;
                        IPluginObject po = iPluginObjectArray[n4];
                        if (po instanceof IPluginElement && CompareUtility.equals((Object)"org.eclipse.scout.rt.server.ResourceServlet", (Object)(pe = (IPluginElement)po).getAttribute("class").getValue()) && pe.getChildCount() > 0) {
                            P_ResourceServletExtension ext = new P_ResourceServletExtension();
                            IPluginObject[] iPluginObjectArray2 = pe.getChildren();
                            int n5 = iPluginObjectArray2.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IPluginElement resourceServletPe;
                                IPluginAttribute[] atts;
                                IPluginObject resourceServletPo = iPluginObjectArray2[n6];
                                if (resourceServletPo instanceof IPluginElement && CompareUtility.equals((Object)resourceServletPo.getName(), (Object)"init-param") && (atts = (resourceServletPe = (IPluginElement)resourceServletPo).getAttributes()) != null) {
                                    HashMap<String, String> props = new HashMap<String, String>(2);
                                    IPluginAttribute[] iPluginAttributeArray = atts;
                                    int n7 = atts.length;
                                    int n8 = 0;
                                    while (n8 < n7) {
                                        IPluginAttribute at = iPluginAttributeArray[n8];
                                        props.put(at.getName(), at.getValue());
                                        ++n8;
                                    }
                                    String name = (String)props.get("name");
                                    String value = (String)props.get("value");
                                    if (!StringUtility.isNullOrEmpty((String)name) && !StringUtility.isNullOrEmpty((String)value)) {
                                        if (CompareUtility.equals((Object)name, (Object)"bundle-name")) {
                                            ext.bundleName = value;
                                        }
                                        if (CompareUtility.equals((Object)name, (Object)"bundle-path")) {
                                            ext.bundlePath = value;
                                        }
                                    }
                                }
                                ++n6;
                            }
                            if (ext.isValid()) {
                                extensions.add(ext);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        for (ITreeNode cn : curentNode.getChildren()) {
            this.findServletExtensions(cn, extensions);
        }
    }

    private class P_FolderTreeBuilder
    implements ITreeNodeFilter {
        private HashMap<String, P_ResourceServletExtension> m_extensions = new HashMap();

        public P_FolderTreeBuilder(P_ResourceServletExtension[] extensions) {
            P_ResourceServletExtension[] p_ResourceServletExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                P_ResourceServletExtension e = p_ResourceServletExtensionArray[n2];
                this.m_extensions.put(e.bundleName, e);
                ++n2;
            }
        }

        @Override
        public boolean accept(ITreeNode node) {
            switch (node.getType()) {
                case 3: 
                case 6: 
                case 7: {
                    node.setVisible(false);
                    break;
                }
                case 4: 
                case 5: {
                    IScoutBundle bundle = (IScoutBundle)node.getData();
                    P_ResourceServletExtension ext = this.m_extensions.get(bundle.getBundleName());
                    if (ext != null) {
                        this.createChildNodes(node, ext);
                        break;
                    }
                    node.setVisible(false);
                    break;
                }
            }
            return true;
        }

        private void createChildNodes(ITreeNode node, P_ResourceServletExtension ext) {
            this.setPathVisible(node);
            IScoutBundle scoutBundle = (IScoutBundle)node.getData();
            IFolder folder = scoutBundle.getProject().getFolder((IPath)new Path(ext.bundlePath));
            this.createNodeForFolder(node, folder);
        }

        private void setPathVisible(ITreeNode node) {
            if (node != null && node.getType() != -1) {
                node.setVisible(true);
                this.setPathVisible(node.getParent());
            }
        }

        private void createNodeForFolder(ITreeNode parentNode, IFolder folder) {
            if (folder.exists()) {
                TreeNode folderNode = new TreeNode(NODE_TYPE_FOLDER, folder.getProjectRelativePath().toString(), folder);
                folderNode.setCheckable(false);
                folderNode.setBold(true);
                ImageDescriptor img = ScoutSdkUi.getImageDescriptor("folder_open.png");
                IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)folder.getAdapter(IWorkbenchAdapter.class);
                if (wbAdapter != null) {
                    img = wbAdapter.getImageDescriptor((Object)folder);
                }
                folderNode.setImage(img);
                parentNode.addChild(folderNode);
                try {
                    IResource[] iResourceArray = folder.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        if (resource.getType() == 2) {
                            this.createNodeForFolder(parentNode, (IFolder)resource);
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    ScoutSdkUi.logError("could not get subfolders of '" + folder.getLocationURI() + "'.", e);
                }
            }
        }
    }

    private class P_ResourceServletExtension {
        private String bundleName;
        private String bundlePath;

        private P_ResourceServletExtension() {
        }

        boolean isValid() {
            return this.bundleName != null && this.bundlePath != null;
        }
    }
}

