/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.javacode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.sdk.ui.fields.javacode.JavaCodeFieldContentAdapter;
import org.eclipse.scout.sdk.ui.fields.javacode.JavaCodeFieldContentProvider;
import org.eclipse.scout.sdk.ui.fields.javacode.JavaCodeFieldLabelProvider;
import org.eclipse.scout.sdk.ui.fields.javacode.JavaCodeRange;
import org.eclipse.scout.sdk.ui.fields.javacode.JavaTypeProposal;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class JavaCodeField
extends Composite {
    private static final String REGEX_WORD = "([a-zA-Z._$]+)";
    private StyledText m_text;
    private JavaCodeFieldContentProvider m_contentProvider;
    private ContentProposalAdapter m_proposalAdapter;
    private HashMap<String, JavaCodeRange> m_ranges = new HashMap();
    private P_Popup m_popup = new P_Popup();

    public JavaCodeField(Composite parent, IJavaSearchScope scope) {
        super(parent, 0);
        this.m_text = new StyledText((Composite)this, 2052);
        this.m_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaCodeField.this.handleTextModified(false);
            }
        });
        P_PopupListener popupListener = new P_PopupListener();
        this.m_text.addListener(7, (Listener)popupListener);
        this.m_text.addListener(12, (Listener)popupListener);
        this.m_text.addListener(1, (Listener)popupListener);
        this.m_text.addListener(3, (Listener)popupListener);
        this.m_text.addListener(5, (Listener)popupListener);
        this.m_text.addListener(32, (Listener)popupListener);
        this.m_text.addListener(16, (Listener)popupListener);
        ControlDecoration deco = new ControlDecoration((Control)this.m_text, 16512);
        deco.setImage(ScoutSdkUi.getImage("content_assist_clu.gif"));
        this.m_contentProvider = new JavaCodeFieldContentProvider(scope);
        this.m_proposalAdapter = new ContentProposalAdapter((Control)this.m_text, (IControlContentAdapter)new JavaCodeFieldContentAdapter(), (IContentProposalProvider)this.m_contentProvider, null, new char[]{' '});
        this.m_proposalAdapter.setLabelProvider((ILabelProvider)new JavaCodeFieldLabelProvider());
        this.m_proposalAdapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                JavaTypeProposal tp = (JavaTypeProposal)proposal;
                JavaCodeRange codeRange = new JavaCodeRange(tp.getContent());
                codeRange.setFullyQuallifiedName(tp.getType().getFullyQualifiedName());
                codeRange.setType(3);
                JavaCodeField.this.m_ranges.put(proposal.getContent(), codeRange);
                JavaCodeField.this.handleTextModified(true);
            }
        });
        this.m_proposalAdapter.setProposalAcceptanceStyle(2);
        this.setLayout((Layout)new FillLayout());
    }

    public String getText() {
        return this.m_text.getText();
    }

    public void setText(String type) {
        this.m_text.setText(type);
        this.handleTextModified(true);
    }

    public void addFocusListener(FocusListener listener) {
        this.m_text.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.m_text.removeFocusListener(listener);
    }

    public String[] getAllImports() {
        ArrayList<String> imports = new ArrayList<String>();
        for (JavaCodeRange range : this.m_ranges.values()) {
            if (range.getType() != 3) continue;
            imports.add(range.getFullyQuallifiedName());
        }
        return imports.toArray(new String[imports.size()]);
    }

    private void handleTextModified(boolean fullInput) {
        int cursorPosition = this.m_text.getCaretOffset();
        HashMap<String, JavaCodeRange> oldRanges = new HashMap<String, JavaCodeRange>(this.m_ranges);
        this.m_ranges.clear();
        Matcher m = Pattern.compile(REGEX_WORD, 32).matcher(this.m_text.getText());
        while (m.find()) {
            String word = m.group(1);
            int offset = m.start(1);
            int lenght = m.end(1) - offset;
            if (!fullInput && cursorPosition >= offset && cursorPosition <= offset + lenght) continue;
            JavaCodeRange range = oldRanges.get(word);
            if (range != null) {
                range.offset = offset;
                range.lenght = lenght;
            } else {
                range = new JavaCodeRange(word);
                range.offset = offset;
                range.lenght = lenght;
                IContentProposal[] pros = this.m_contentProvider.findExactMatch(word);
                if (pros.length == 1) {
                    JavaTypeProposal proposal = (JavaTypeProposal)pros[0];
                    if (!proposal.isPrimitive()) {
                        range.setFullyQuallifiedName(proposal.getType().getFullyQualifiedName());
                        range.setType(3);
                    } else {
                        range.setType(2);
                    }
                } else {
                    range.setType(1);
                }
            }
            this.m_ranges.put(word, range);
        }
        if (!oldRanges.equals(this.m_ranges)) {
            this.updateStyles();
        }
    }

    private void updateStyles() {
        TreeMap<CompositeObject, StyleRange> ranges = new TreeMap<CompositeObject, StyleRange>();
        for (JavaCodeRange range : this.m_ranges.values()) {
            StyleRange stRange = null;
            switch (range.getType()) {
                case 1: {
                    stRange = new StyleRange(range.offset, range.lenght, null, null);
                    stRange.underlineColor = this.m_text.getDisplay().getSystemColor(3);
                    stRange.underlineStyle = 3;
                    stRange.underline = true;
                    break;
                }
                case 2: 
                case 3: {
                    stRange = new StyleRange(range.offset, range.lenght, null, null);
                    stRange.fontStyle = 1;
                }
            }
            ranges.put(new CompositeObject(new Object[]{range.offset, range.offset + range.lenght, range.getText()}), stRange);
        }
        this.m_text.setStyleRanges(ranges.values().toArray(new StyleRange[ranges.size()]));
    }

    private JavaCodeRange getCodeRangeFor(int x, int y) {
        String text = this.m_text.getText();
        try {
            int offset = this.m_text.getOffsetAtLocation(new Point(x, y));
            if (offset < text.length()) {
                String before = text.substring(0, offset);
                String after = text.substring(offset);
                Matcher m = Pattern.compile("([a-zA-Z0-9$.]*)$").matcher(before);
                if (m.find()) {
                    before = m.group(1);
                    m = Pattern.compile("^([a-zA-Z0-9$.]*)").matcher(after);
                    if (m.find()) {
                        return this.m_ranges.get(String.valueOf(before) + m.group(1));
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return null;
    }

    private class P_Popup {
        private Shell m_shell;
        private Object m_lock = new Object();
        private JavaCodeRange m_range;

        private P_Popup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void showFor(JavaCodeRange range, int x, int y) {
            if (range == null) {
                this.close();
            } else if (!range.equals(this.m_range) || this.m_shell == null) {
                if (this.m_shell != null) {
                    this.close();
                }
                Object object = this.m_lock;
                synchronized (object) {
                    this.m_shell = new Shell(JavaCodeField.this.m_text.getShell(), 16388);
                    this.m_shell.setBackground(JavaCodeField.this.m_text.getDisplay().getSystemColor(29));
                    this.m_shell.setLayout((Layout)new FormLayout());
                    Label l = new Label((Composite)this.m_shell, 4);
                    l.setBackground(this.m_shell.getBackground());
                    l.setText(range.getFullyQuallifiedName());
                    FormData data = new FormData();
                    data.top = new FormAttachment(0, 5);
                    data.left = new FormAttachment(0, 5);
                    data.right = new FormAttachment(100, -5);
                    data.bottom = new FormAttachment(100, -5);
                    l.setLayoutData((Object)data);
                    Rectangle rect = JavaCodeField.this.m_text.getDisplay().map((Control)JavaCodeField.this.m_text, null, new Rectangle(x + 10, y, 0, 0));
                    this.m_shell.setLocation(rect.x, rect.y);
                    this.m_shell.pack();
                    this.m_shell.open();
                }
            }
            this.m_range = range;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_lock;
            synchronized (object) {
                if (this.m_shell != null && !this.m_shell.isDisposed()) {
                    this.m_shell.close();
                }
                this.m_shell = null;
            }
        }
    }

    private class P_PopupListener
    implements Listener {
        private P_PopupListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 32: {
                    JavaCodeField.this.m_popup.showFor(JavaCodeField.this.getCodeRangeFor(event.x, event.y), event.x, event.y);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 12: {
                    JavaCodeField.this.m_popup.close();
                }
            }
        }
    }
}

