/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalProvider;

public class ResourcesContentProvider
extends ContentProposalProvider
implements IStructuredContentProvider {
    private final ILabelProvider m_labelProvider;
    private List<Object> m_elements;

    public ResourcesContentProvider(ILabelProvider labelProvider) {
        this(labelProvider, null);
    }

    public ResourcesContentProvider(ILabelProvider labelProvider, Object[] elements) {
        this.m_labelProvider = labelProvider;
        this.m_elements = new ArrayList<Object>();
        if (elements != null) {
            this.m_elements.addAll(Arrays.asList(elements));
        }
    }

    @Override
    public Object[] getProposals(String searchPattern, IProgressMonitor monitor) {
        searchPattern = !StringUtility.hasText((String)searchPattern) ? "*" : String.valueOf(searchPattern.replaceAll("\\*$", "")) + "*";
        char[] pattern = CharOperation.toLowerCase((char[])searchPattern.toCharArray());
        ArrayList<Object> collector = new ArrayList<Object>();
        Object[] objectArray = this.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object proposal = objectArray[n2];
            if (CharOperation.match((char[])pattern, (char[])this.getLabelProvider().getText(proposal).toCharArray(), (boolean)false)) {
                collector.add(proposal);
            }
            ++n2;
        }
        return collector.toArray(new Object[collector.size()]);
    }

    public ILabelProvider getLabelProvider() {
        return this.m_labelProvider;
    }

    public final Object[] getElements(Object inputElement) {
        return this.getElements();
    }

    public Object[] getElements() {
        return this.m_elements.toArray(new Object[this.m_elements.size()]);
    }

    public void setElements(Object[] resources) {
        this.m_elements.clear();
        this.m_elements.addAll(Arrays.asList(resources));
    }

    public boolean remove(Object element) {
        return this.m_elements.remove(element);
    }

    public boolean add(Object element) {
        return this.m_elements.add(element);
    }
}

