/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.dialog;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.table.FilteredTable;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.dialog.FontSpec;
import org.eclipse.scout.sdk.ui.internal.dialog.SystemFonts;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FontDialog
extends TitleAreaDialog {
    private SystemFonts m_fonts;
    private FontSpec m_fontSpec;
    private FilteredTable m_fontNameTable;
    private FilteredTable m_fontStyleTable;
    private Button m_defaultFontStyleButton;
    private Button m_defaultFontNameButton;
    private Label m_preview;
    private Font m_defaultFont;
    private Font m_currentPreviewFont;
    private Composite m_rootArea;
    private Button m_defaultFontSizeButton;
    private Text m_sizeField;
    private final String m_title;
    private final String m_message;

    public FontDialog(Shell parentShell, FontSpec initialSpec) {
        this(parentShell, initialSpec, Texts.get((String)"Font"), Texts.get((String)"FontDialogHelpMsg"));
    }

    public FontDialog(Shell parentShell, FontSpec initialSpec, String title, String message) {
        super(parentShell);
        this.m_title = title;
        this.m_message = message;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_fontSpec = initialSpec == null ? new FontSpec() : new FontSpec(initialSpec);
    }

    protected Control createDialogArea(Composite parent) {
        if (!StringUtility.isNullOrEmpty((String)this.m_title)) {
            this.setTitle(this.m_title);
        }
        if (!StringUtility.isNullOrEmpty((String)this.m_message)) {
            this.setMessage(this.m_message);
        }
        this.m_fonts = new SystemFonts(this.getShell().getDisplay().getFontList(null, true));
        this.m_rootArea = new Composite(parent, 0);
        Control nameArea = this.createFontNameArea(this.m_rootArea);
        Control styleArea = this.createFontStyleArea(this.m_rootArea);
        Control sizeAndPreviewArea = this.createSizeAndPreview(this.m_rootArea);
        this.m_rootArea.setLayout((Layout)new GridLayout(3, true));
        GridData nameAreaData = new GridData(1808);
        nameAreaData.heightHint = 250;
        nameArea.setLayoutData((Object)nameAreaData);
        GridData sizeAreaData = new GridData(1808);
        sizeAreaData.heightHint = 250;
        styleArea.setLayoutData((Object)sizeAreaData);
        GridData sizeAndPreviewAreaData = new GridData(1808);
        sizeAndPreviewAreaData.heightHint = 250;
        sizeAndPreviewArea.setLayoutData((Object)sizeAndPreviewAreaData);
        if (parent.getLayout() instanceof GridLayout) {
            this.m_rootArea.setLayoutData((Object)new GridData(1808));
        }
        this.updateFontSpec();
        return this.m_rootArea;
    }

    private Control createFontNameArea(Composite parent) {
        Group nameGroup = new Group(parent, 16);
        nameGroup.setText(Texts.get((String)"Name"));
        this.m_defaultFontNameButton = new Button((Composite)nameGroup, 32);
        String fontName = this.m_fontSpec.getName();
        this.m_defaultFontNameButton.setSelection(fontName == null);
        this.m_defaultFontNameButton.setText(Texts.get((String)"UseDefault"));
        this.m_defaultFontNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontDialog.this.m_fontNameTable.setEnabled(!((Button)e.widget).getSelection());
                FontDialog.this.updateFontSpec();
            }
        });
        this.m_fontNameTable = new FilteredTable((Composite)nameGroup, 68356);
        this.m_fontNameTable.setEnabled(fontName != null);
        P_FontNameProvider provider = new P_FontNameProvider((Device)this.m_fontNameTable.getDisplay());
        this.m_fontNameTable.getViewer().setLabelProvider((IBaseLabelProvider)provider);
        this.m_fontNameTable.getViewer().setContentProvider((IContentProvider)provider);
        this.m_fontNameTable.getViewer().setInput((Object)provider);
        if (fontName != null) {
            this.m_fontNameTable.getViewer().setSelection((ISelection)new StructuredSelection((Object)fontName));
            this.m_fontNameTable.getViewer().reveal((Object)fontName);
        }
        this.m_fontNameTable.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FontDialog.this.updateFontSpec();
            }
        });
        nameGroup.setLayout((Layout)new GridLayout(1, true));
        this.m_defaultFontNameButton.setLayoutData((Object)new GridData(768));
        this.m_fontNameTable.setLayoutData(new GridData(1808));
        return nameGroup;
    }

    private Control createFontStyleArea(Composite parent) {
        Group styleGroup = new Group(parent, 16);
        styleGroup.setText("Style");
        this.m_defaultFontStyleButton = new Button((Composite)styleGroup, 32);
        this.m_defaultFontStyleButton.setSelection(this.m_fontSpec.getStyle() == null);
        this.m_defaultFontStyleButton.setText(Texts.get((String)"UseDefault"));
        this.m_defaultFontStyleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontDialog.this.m_fontStyleTable.setEnabled(!((Button)e.widget).getSelection());
                FontDialog.this.updateFontSpec();
            }
        });
        this.m_fontStyleTable = new FilteredTable((Composite)styleGroup, 68356);
        this.m_fontStyleTable.setEnabled(this.m_fontSpec.getStyle() != null);
        P_FontSizeProvider provider = new P_FontSizeProvider();
        this.m_fontStyleTable.getViewer().setLabelProvider((IBaseLabelProvider)provider);
        this.m_fontStyleTable.getViewer().setContentProvider((IContentProvider)provider);
        this.m_fontStyleTable.getViewer().setInput((Object)provider);
        if (this.m_fontSpec.getStyle() != null) {
            this.m_fontStyleTable.getViewer().setSelection((ISelection)new StructuredSelection((Object)this.m_fontSpec.getStyle()));
        }
        this.m_fontStyleTable.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FontDialog.this.updateFontSpec();
            }
        });
        styleGroup.setLayout((Layout)new GridLayout(1, true));
        this.m_defaultFontStyleButton.setLayoutData((Object)new GridData(768));
        this.m_fontStyleTable.setLayoutData(new GridData(1808));
        return styleGroup;
    }

    private Control createSizeAndPreview(Composite parent) {
        Composite area = new Composite(parent, 0);
        Group sizeGroup = new Group(area, 16);
        sizeGroup.setText("Size");
        this.m_defaultFontSizeButton = new Button((Composite)sizeGroup, 32);
        this.m_defaultFontSizeButton.setSelection(this.m_fontSpec.getHeight() == null);
        this.m_defaultFontSizeButton.setText(Texts.get((String)"UseDefault"));
        this.m_defaultFontSizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontDialog.this.m_sizeField.setEnabled(!((Button)e.widget).getSelection());
                FontDialog.this.updateFontSpec();
            }
        });
        this.m_sizeField = new Text((Composite)sizeGroup, 133120);
        this.m_sizeField.setEnabled(this.m_fontSpec.getHeight() != null);
        if (this.m_fontSpec.getHeight() != null) {
            this.m_sizeField.setText("" + this.m_fontSpec.getHeight());
        }
        this.m_sizeField.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                switch (e.keyCode) {
                    case 8: 
                    case 127: {
                        return;
                    }
                }
                if (FontDialog.this.m_sizeField.getText().length() > 2) {
                    e.doit = false;
                }
                String regexp = "[0-9]";
                char c = e.character;
                if (!("" + c).matches(regexp)) {
                    e.doit = false;
                }
            }
        });
        this.m_sizeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FontDialog.this.updateFontSpec();
            }
        });
        Group previewGroup = new Group(area, 16);
        previewGroup.setText(Texts.get((String)"Preview"));
        this.m_preview = new Label((Composite)previewGroup, 64);
        this.m_preview.setText("ABCDEFGHIJklmnopqrs 123456789");
        this.m_defaultFont = this.m_preview.getFont();
        this.m_preview.setBackground(this.m_preview.getDisplay().getSystemColor(1));
        GridLayout areaLayout = new GridLayout(1, true);
        areaLayout.horizontalSpacing = 0;
        areaLayout.marginHeight = 0;
        areaLayout.marginWidth = 0;
        areaLayout.verticalSpacing = 0;
        area.setLayout((Layout)areaLayout);
        sizeGroup.setLayoutData((Object)new GridData(768));
        sizeGroup.setLayout((Layout)new GridLayout(1, true));
        this.m_defaultFontSizeButton.setLayoutData((Object)new GridData(768));
        this.m_sizeField.setLayoutData((Object)new GridData(768));
        previewGroup.setLayoutData((Object)new GridData(1808));
        previewGroup.setLayout((Layout)new GridLayout(1, true));
        GridData previewFieldData = new GridData(1808);
        this.m_preview.setLayoutData((Object)previewFieldData);
        return area;
    }

    private void updateFontSpec() {
        IStructuredSelection selection;
        if (this.m_defaultFontNameButton.getSelection()) {
            this.m_fontSpec.setName(null);
        } else {
            selection = (IStructuredSelection)this.m_fontNameTable.getViewer().getSelection();
            String fontName = null;
            if (!selection.isEmpty()) {
                fontName = (String)selection.getFirstElement();
            }
            this.m_fontSpec.setName(fontName);
        }
        if (this.m_defaultFontStyleButton.getSelection()) {
            this.m_fontSpec.setStyle(null);
        } else {
            selection = (IStructuredSelection)this.m_fontStyleTable.getViewer().getSelection();
            Integer style = null;
            if (!selection.isEmpty()) {
                style = (Integer)selection.getFirstElement();
            }
            this.m_fontSpec.setStyle(style);
        }
        if (this.m_defaultFontSizeButton.getSelection()) {
            this.m_fontSpec.setHeight(null);
        } else {
            String text = this.m_sizeField.getText();
            if (!StringUtility.isNullOrEmpty((String)text)) {
                try {
                    int size = Integer.parseInt(text);
                    this.m_fontSpec.setHeight(size);
                }
                catch (Exception e) {
                    ScoutSdkUi.logWarning("could not parse '" + text + "' to integer.", e);
                }
            }
        }
        FontData fd = this.m_defaultFont.getFontData()[0];
        if (!StringUtility.isNullOrEmpty((String)this.m_fontSpec.getName())) {
            fd.setName(this.m_fontSpec.getName());
        }
        if (this.m_fontSpec.getHeight() != null) {
            fd.setHeight(this.m_fontSpec.getHeight().intValue());
        }
        if (this.m_fontSpec.getStyle() != null) {
            fd.setStyle(this.m_fontSpec.getStyle().intValue());
        }
        if (this.m_currentPreviewFont != null) {
            this.m_currentPreviewFont.dispose();
        }
        this.m_currentPreviewFont = new Font((Device)this.m_preview.getDisplay(), fd);
        this.m_preview.setFont(this.m_currentPreviewFont);
        this.m_rootArea.layout(true);
    }

    public FontSpec openDialog() {
        if (this.open() == 0) {
            return this.m_fontSpec;
        }
        return null;
    }

    public int open() {
        return super.open();
    }

    private class P_FontNameProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        public P_FontNameProvider(Device device) {
        }

        public Object[] getElements(Object inputElement) {
            return FontDialog.this.m_fonts.getAllFontNames();
        }

        public String getColumnText(Object element, int columnIndex) {
            return (String)element;
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class P_FontSizeProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        private P_FontSizeProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new Integer[]{new Integer(1), new Integer(2), new Integer(3), new Integer(0)};
        }

        public String getColumnText(Object element, int columnIndex) {
            Integer style = (Integer)element;
            StringBuilder styleBuilder = new StringBuilder();
            if (style != null) {
                if ((style & 1) != 0) {
                    styleBuilder.append("BOLD");
                }
                if ((style & 2) != 0) {
                    if (styleBuilder.length() > 0) {
                        styleBuilder.append(" ");
                    }
                    styleBuilder.append("ITALIC");
                }
                if (styleBuilder.length() == 0) {
                    styleBuilder.append("NORMAL");
                }
            }
            return styleBuilder.toString();
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

