/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.fields.code;

import java.util.EventListener;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.sdk.operation.service.ParameterArgument;
import org.eclipse.scout.sdk.ui.fields.javacode.JavaCodeField;
import org.eclipse.scout.sdk.ui.internal.fields.code.IParameterFieldListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ParameterField
extends Composite {
    private Label m_label;
    private Text m_parameterName;
    private Label m_labelType;
    private JavaCodeField m_parameterType;
    private ParameterArgument m_parameter = new ParameterArgument();
    private EventListenerList m_eventListeners = new EventListenerList();
    private final IJavaSearchScope m_scope;

    public ParameterField(Composite parent, ParameterArgument a, IJavaSearchScope scope) {
        super(parent, 0);
        this.m_scope = scope;
        this.createContent(this, a);
    }

    protected void createContent(Composite parent, ParameterArgument a) {
        this.m_label = new Label(parent, 0);
        this.m_parameterName = new Text(parent, 2048);
        if (a != null) {
            this.m_parameterName.setText(a.getName());
            this.m_parameter.setName(a.getName());
        }
        this.m_parameterName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterField.this.m_parameter.setName(ParameterField.this.m_parameterName.getText());
                ParameterField.this.notifyParameterChanged();
            }
        });
        this.m_labelType = new Label(parent, 0);
        this.m_parameterType = new JavaCodeField(parent, this.m_scope);
        if (a != null) {
            this.m_parameterType.setText(a.getType());
            this.m_parameter.setType(a.getType());
        }
        this.m_parameterType.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ParameterField.this.m_parameter.setType(ParameterField.this.m_parameterType.getText());
                ParameterField.this.m_parameter.setFullyQuallifiedImports(ParameterField.this.m_parameterType.getAllImports());
                ParameterField.this.notifyParameterChanged();
            }
        });
        parent.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(20, 0);
        data.bottom = new FormAttachment(100, 0);
        this.m_label.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment((Control)this.m_label, 5);
        data.right = new FormAttachment(55, 0);
        data.bottom = new FormAttachment(100, 0);
        this.m_parameterName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment((Control)this.m_parameterName, 5);
        data.right = new FormAttachment(65, 0);
        data.bottom = new FormAttachment(100, 0);
        this.m_labelType.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment((Control)this.m_labelType, 5);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.m_parameterType.setLayoutData(data);
    }

    public void setLabelParameterName(String label) {
        this.m_label.setText(label);
    }

    public void setLabelParameterType(String label) {
        this.m_labelType.setText(label);
    }

    private void notifyParameterChanged() {
        IParameterFieldListener[] iParameterFieldListenerArray = (IParameterFieldListener[])this.m_eventListeners.getListeners(IParameterFieldListener.class);
        int n = iParameterFieldListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParameterFieldListener listener = iParameterFieldListenerArray[n2];
            listener.parameterChanged(this.m_parameter);
            ++n2;
        }
    }

    public void addParameterFieldListener(IParameterFieldListener listener) {
        this.m_eventListeners.add(IParameterFieldListener.class, (EventListener)listener);
    }

    public void removeParameterFieldListener(IParameterFieldListener listener) {
        this.m_eventListeners.remove(IParameterFieldListener.class, (EventListener)listener);
    }

    public ParameterArgument getParameter() {
        return this.m_parameter;
    }

    public String getLabel() {
        return this.m_label.getText();
    }
}

