/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.ScoutExplorerPart;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPageFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class ViewLabelProvider
extends LabelProvider
implements IColorProvider,
IFontProvider {
    private Composite m_parent;
    private Font m_fontPlain;
    private Font m_fontPlainItalic;
    private Font m_fontBold;
    private Font m_fontBoldItalic;
    private final ScoutExplorerPart m_explorerPart;

    public ViewLabelProvider(Composite parent, ScoutExplorerPart explorerPart) {
        this.m_parent = parent;
        this.m_explorerPart = explorerPart;
    }

    public String getText(Object obj) {
        if (obj instanceof IPage) {
            IPage p = (IPage)obj;
            IPageFilter filter = this.m_explorerPart.getPageFilter(p);
            if (filter == null || filter.isEmpty()) {
                return p.getName();
            }
            return String.valueOf(p.getName()) + " [" + filter.getFilterExpression() + "]";
        }
        return obj.toString();
    }

    public Image getImage(Object obj) {
        if (obj instanceof AbstractPage) {
            AbstractPage m = (AbstractPage)obj;
            return m.getImage();
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Font getFont(Object element) {
        this.ensureFontCache();
        if (element instanceof IPage) {
            IPage p = (IPage)element;
            IPageFilter filter = this.m_explorerPart.getPageFilter(p);
            if (p.isFolder()) {
                if (filter == null || filter.isEmpty()) {
                    return this.m_fontPlain;
                }
                return this.m_fontPlainItalic;
            }
            if (filter == null || filter.isEmpty()) {
                return this.m_fontBold;
            }
            return this.m_fontBoldItalic;
        }
        return null;
    }

    private void ensureFontCache() {
        if (this.m_fontBold == null || this.m_fontBoldItalic == null || this.m_fontPlainItalic == null) {
            try {
                FontData[] d;
                Font f = this.m_parent.getFont();
                if (f != null && (d = f.getFontData()) != null && d.length > 0) {
                    if (this.m_fontBold == null) {
                        this.m_fontBold = new Font(f.getDevice(), d[0].getName(), d[0].getHeight(), 1);
                    }
                    if (this.m_fontBoldItalic == null) {
                        this.m_fontBoldItalic = new Font(f.getDevice(), d[0].getName(), d[0].getHeight(), 3);
                    }
                    if (this.m_fontPlainItalic == null) {
                        this.m_fontPlainItalic = new Font(f.getDevice(), d[0].getName(), d[0].getHeight(), 2);
                    }
                }
            }
            catch (Throwable t) {
                ScoutSdkUi.logWarning(t);
            }
        }
    }
}

