/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformSharedBundleOperation;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.library.LibrariesTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.CodeTypeTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.IconNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.LookupCallTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.PermissionTablePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class SharedNodePage
extends AbstractPage {
    final IType abstractIcons = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.AbstractIcons");
    private final IScoutBundle m_sharedProject;

    public SharedNodePage(IPage parent, IScoutBundle sharedProject) {
        this.setParent(parent);
        this.m_sharedProject = sharedProject;
        this.setName(this.getScoutResource().getSimpleName());
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("sharedBundle.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.SharedNodePage";
    }

    @Override
    public int getOrder() {
        return 200;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return this.m_sharedProject;
    }

    @Override
    public boolean isInitiallyLoaded() {
        return true;
    }

    @Override
    public void loadChildrenImpl() {
        IPrimaryTypeTypeHierarchy iconHierarchy;
        IType[] iconTypes;
        if (this.getScoutResource().getScoutProject().getIconProvider() != null && (iconTypes = (iconHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.abstractIcons)).getAllSubtypes(this.abstractIcons, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()), null)).length > 0) {
            new IconNodePage(this, iconTypes[0]);
        }
        new PermissionTablePage(this);
        new CodeTypeTablePage(this);
        try {
            new LookupCallTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("could not create LookupCallTablePage in project '" + this.getScoutResource().getRootPackageName() + "'", e);
        }
        try {
            new LibrariesTablePage(this, this.getScoutResource());
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured while loading '" + LibrariesTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutResource().getBundleName() + "'.", e);
        }
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        WellformAction action = (WellformAction)menu;
        action.setLabel(Texts.get((String)"WellformSharedBundle"));
        action.setOperation((IOperation)new WellformSharedBundleOperation(this.getScoutResource()));
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{WellformAction.class};
    }
}

