/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.StaticContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.styled.SearchRangeStyledLabelProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractProposalPresenter;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class ButtonSystemTypePresenter
extends AbstractProposalPresenter<SystemType> {
    public ButtonSystemTypePresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected void createProposalFieldProviders(ProposalTextField proposalField) {
        SearchRangeStyledLabelProvider labelProvider = new SearchRangeStyledLabelProvider(){

            public String getText(Object element) {
                SystemType value = (SystemType)((Object)element);
                switch (value) {
                    case SaveWithoutMarkerChange: {
                        return "Save without marker change";
                    }
                }
                return value.toString();
            }

            public Image getImage(Object element) {
                return ScoutSdkUi.getImage("default.gif");
            }
        };
        this.getProposalField().setLabelProvider((IBaseLabelProvider)labelProvider);
        StaticContentProvider provider = new StaticContentProvider((Object[])SystemType.values(), labelProvider);
        this.getProposalField().setContentProvider(provider);
    }

    @Override
    protected SystemType parseInput(String input) throws CoreException {
        int parsedInt = PropertyMethodSourceUtility.parseReturnParameterInteger((String)input, (IMethod)this.getMethod().peekMethod(), (ITypeHierarchy)this.getMethod().getSuperTypeHierarchy());
        switch (parsedInt) {
            case 0: {
                return SystemType.None;
            }
            case 1: {
                return SystemType.Cancel;
            }
            case 2: {
                return SystemType.Close;
            }
            case 3: {
                return SystemType.Ok;
            }
            case 4: {
                return SystemType.Reset;
            }
            case 5: {
                return SystemType.Save;
            }
            case 6: {
                return SystemType.SaveWithoutMarkerChange;
            }
        }
        return null;
    }

    @Override
    protected synchronized void storeValue(SystemType value) {
        ScoutMethodDeleteOperation op = null;
        if (UiUtility.equals((SystemType)((Object)this.getDefaultValue()), value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            String sourceValue = null;
            switch (value) {
                case Cancel: {
                    sourceValue = "SYSTEM_TYPE_CANCEL";
                    break;
                }
                case Close: {
                    sourceValue = "SYSTEM_TYPE_CLOSE";
                    break;
                }
                case None: {
                    sourceValue = "SYSTEM_TYPE_NONE";
                    break;
                }
                case Ok: {
                    sourceValue = "SYSTEM_TYPE_OK";
                    break;
                }
                case Reset: {
                    sourceValue = "SYSTEM_TYPE_RESET";
                    break;
                }
                case Save: {
                    sourceValue = "SYSTEM_TYPE_SAVE";
                    break;
                }
                case SaveWithoutMarkerChange: {
                    sourceValue = "SYSTEM_TYPE_SAVE_WITHOUT_MARKER_CHANGE";
                    break;
                }
            }
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), "  return " + sourceValue + ";", true);
        }
        if (op != null) {
            new OperationJob(new IOperation[]{op}).schedule();
        }
    }

    protected static enum SystemType {
        Cancel,
        Close,
        None,
        Ok,
        Reset,
        Save,
        SaveWithoutMarkerChange;

    }
}

