/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.export;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.FileSelectionField;
import org.eclipse.scout.sdk.ui.fields.IFileSelectionListener;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.bundletree.CheckableTree;
import org.eclipse.scout.sdk.ui.fields.bundletree.ICheckStateListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.export.ExportScoutProjectEntry;
import org.eclipse.scout.sdk.ui.internal.extensions.export.ExportScoutProjectEntryExtensionPoint;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.export.IExportScoutProjectWizard;
import org.eclipse.scout.sdk.ui.wizard.export.IExportScoutProjectWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ExportScoutProjectWizardPage
extends AbstractWorkspaceWizardPage
implements IExportScoutProjectWizardPage {
    private static final String PROP_SELECTED_ENTRIES = "selectedEntries";
    private static final String PROP_TARGET_DIR = "targetDir";
    private static final String PROP_EXPORT_EAR = "exportEAR";
    private static final String PROP_EAR_FILE_NAME = "earFileName";
    private static final String SETTINGS_SELECTED_ENTRIES = "selectedEntriesSetting";
    private static final String SETTINGS_TARGET_DIR = "targetDirSetting";
    private static final String SETTINGS_EXPORT_EAR = "exportEARSetting";
    private static final String SETTINGS_EAR_FILE_NAME = "earFileNameSetting";
    private static final int TYPE_EXPORT_ENTRY = 101;
    private final BasicPropertySupport m_propertySupport;
    private FileSelectionField m_destDirFileField;
    private Button m_exportAsEarButton;
    private StyledTextField m_earFileName;
    private CheckableTree m_entryTree;
    private ITreeNode m_invisibleRootNode;

    public ExportScoutProjectWizardPage(IScoutProject scoutProject) {
        super(ExportScoutProjectWizardPage.class.getName());
        this.setTitle(Texts.get((String)"ExportScoutProject"));
        this.setDescription(Texts.get((String)"ExportScoutProjectMessage"));
        this.m_propertySupport = new BasicPropertySupport((Object)this);
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusTargetDirectoryField());
        multiStatus.add(this.getStatusEarFileName());
        multiStatus.add(this.getStatusEntryTree());
        if (this.m_invisibleRootNode != null) {
            ITreeNode[] iTreeNodeArray = TreeUtility.findNodes(this.m_invisibleRootNode, NodeFilters.getVisible());
            int n = iTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus status;
                ExportScoutProjectEntry entry;
                ITreeNode node = iTreeNodeArray[n2];
                if (this.m_entryTree.isChecked(node) && (entry = (ExportScoutProjectEntry)node.getData()) != null && (status = entry.getHandler().getStatus(this.getWizard())) != null) {
                    multiStatus.add(status);
                }
                ++n2;
            }
        }
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_destDirFileField = new FileSelectionField(parent);
        this.m_destDirFileField.setLabelText(Texts.get((String)"TargetDirectory"));
        this.m_destDirFileField.setFolderMode(true);
        this.m_destDirFileField.addProductSelectionListener(new IFileSelectionListener(){

            @Override
            public void fileSelected(File file) {
                ExportScoutProjectWizardPage.this.setTargetDirectoryInternal(file);
                ExportScoutProjectWizardPage.this.pingStateChanging();
            }
        });
        String defaultSelection = this.getDialogSettings().get(SETTINGS_TARGET_DIR);
        if (defaultSelection != null) {
            File file = new File(defaultSelection);
            this.m_destDirFileField.setFile(file);
            this.setTargetDirectoryInternal(file);
            this.pingStateChanging();
        }
        Control exportAsEarGroup = this.createExportAsEarBox(parent);
        this.m_invisibleRootNode = this.buildBundleTree();
        this.m_entryTree = new CheckableTree(parent, this.m_invisibleRootNode);
        this.m_entryTree.addCheckSelectionListener(new ICheckStateListener(){

            @Override
            public void fireNodeCheckStateChanged(ITreeNode node, boolean checkState) {
                ExportScoutProjectWizardPage.this.m_propertySupport.setProperty(ExportScoutProjectWizardPage.PROP_SELECTED_ENTRIES, (Object)ExportScoutProjectWizardPage.this.m_entryTree.getCheckedNodes());
                ExportScoutProjectWizardPage.this.saveTreeSelection();
                ExportScoutProjectEntry ext = (ExportScoutProjectEntry)node.getData();
                if (ext != null) {
                    ext.getHandler().selectionChanged(ExportScoutProjectWizardPage.this.getWizard(), checkState);
                }
                ExportScoutProjectWizardPage.this.pingStateChanging();
            }
        });
        this.m_entryTree.setChecked(this.getInitiallyCheckedNodes());
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_destDirFileField.setLayoutData(new GridData(768));
        exportAsEarGroup.setLayoutData((Object)new GridData(1808));
        this.m_entryTree.setLayoutData(new GridData(1808));
    }

    protected Control createExportAsEarBox(Composite parent) {
        Group group = new Group(parent, 16);
        this.m_exportAsEarButton = new Button((Composite)group, 32);
        this.m_exportAsEarButton.setText(Texts.get((String)"ExportAsEar"));
        this.m_exportAsEarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportScoutProjectWizardPage.this.setExportEarInternal(ExportScoutProjectWizardPage.this.m_exportAsEarButton.getSelection());
                ExportScoutProjectWizardPage.this.m_earFileName.setEnabled(ExportScoutProjectWizardPage.this.m_exportAsEarButton.getSelection());
                ExportScoutProjectWizardPage.this.pingStateChanging();
            }
        });
        this.m_exportAsEarButton.setSelection(this.getDialogSettings().getBoolean(SETTINGS_EXPORT_EAR));
        this.setExportEarInternal(this.m_exportAsEarButton.getSelection());
        this.m_earFileName = this.getFieldToolkit().createStyledTextField((Composite)group, Texts.get((String)"EarFileName"));
        this.m_earFileName.setReadOnlySuffix(".ear");
        this.m_earFileName.setEnabled(this.m_exportAsEarButton.getSelection());
        this.m_earFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportScoutProjectWizardPage.this.setEarNameInternal(ExportScoutProjectWizardPage.this.m_earFileName.getText());
                ExportScoutProjectWizardPage.this.pingStateChanging();
            }
        });
        String defaultValue = this.getDialogSettings().get(SETTINGS_EAR_FILE_NAME);
        if (StringUtility.hasText((String)defaultValue) && !this.m_earFileName.getReadOnlySuffix().equals(defaultValue)) {
            this.m_earFileName.setText(defaultValue);
        } else {
            this.m_earFileName.setText(this.getWizard().getProjectAlias());
        }
        group.setLayout((Layout)new GridLayout(1, true));
        this.m_exportAsEarButton.setLayoutData((Object)new GridData(768));
        this.m_earFileName.setLayoutData(new GridData(768));
        return group;
    }

    public IExportScoutProjectWizard getWizard() {
        return (IExportScoutProjectWizard)super.getWizard();
    }

    private ITreeNode[] getNodes(String ... entryIds) {
        return TreeUtility.findNodes(this.m_invisibleRootNode, new P_NodeByIdFilter(entryIds));
    }

    private ITreeNode[] getInitiallyCheckedNodes() {
        String[] ids = this.getDialogSettings().getArray(SETTINGS_SELECTED_ENTRIES);
        if (ids == null) {
            ITreeNode[] nodes;
            ArrayList<String> defaultSelection = new ArrayList<String>();
            ITreeNode[] iTreeNodeArray = nodes = TreeUtility.findNodes(this.m_invisibleRootNode, NodeFilters.getVisible());
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode n3 = iTreeNodeArray[n2];
                ExportScoutProjectEntry e = (ExportScoutProjectEntry)n3.getData();
                if (e.getHandler().getDefaultSelection()) {
                    defaultSelection.add(e.getId());
                }
                ++n2;
            }
            ids = defaultSelection.toArray(new String[defaultSelection.size()]);
        }
        return this.getNodes(ids);
    }

    private void saveTreeSelection() {
        ITreeNode[] checked = this.m_entryTree.getCheckedNodes();
        ArrayList<String> ids = new ArrayList<String>(checked.length);
        ITreeNode[] iTreeNodeArray = checked;
        int n = checked.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode n3 = iTreeNodeArray[n2];
            ExportScoutProjectEntry e = (ExportScoutProjectEntry)n3.getData();
            ids.add(e.getId());
            ++n2;
        }
        this.getDialogSettings().put(SETTINGS_SELECTED_ENTRIES, ids.toArray(new String[ids.size()]));
    }

    @Override
    public boolean isNodesSelected(String ... entryIds) {
        ITreeNode[] nodes;
        ITreeNode[] iTreeNodeArray = nodes = this.getNodes(entryIds);
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode n3 = iTreeNodeArray[n2];
            if (this.m_entryTree.isChecked(n3)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public ExportScoutProjectEntry[] getSelectedEntries() {
        ITreeNode[] nodes;
        if (this.m_invisibleRootNode == null) {
            return new ExportScoutProjectEntry[0];
        }
        ArrayList<ExportScoutProjectEntry> selectedEntries = new ArrayList<ExportScoutProjectEntry>();
        ITreeNode[] iTreeNodeArray = nodes = TreeUtility.findNodes(this.m_invisibleRootNode, NodeFilters.getVisible());
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode n3 = iTreeNodeArray[n2];
            if (this.m_entryTree.isChecked(n3)) {
                ExportScoutProjectEntry entry = (ExportScoutProjectEntry)n3.getData();
                selectedEntries.add(entry);
            }
            ++n2;
        }
        return selectedEntries.toArray(new ExportScoutProjectEntry[selectedEntries.size()]);
    }

    public File getTargetDirectory() {
        return (File)this.getProperty(PROP_TARGET_DIR);
    }

    public void setTargetDirectory(File dir) {
        try {
            this.setStateChanging(true);
            this.setTargetDirectoryInternal(dir);
            if (this.isControlCreated()) {
                this.m_destDirFileField.setFile(dir);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTargetDirectoryInternal(File f) {
        this.setProperty(PROP_TARGET_DIR, f);
        String path = null;
        if (f != null) {
            path = f.getAbsolutePath();
        }
        this.getDialogSettings().put(SETTINGS_TARGET_DIR, path);
    }

    public boolean isExportEar() {
        return this.getPropertyBool(PROP_EXPORT_EAR);
    }

    public void setExportEar(boolean exportEar) {
        try {
            this.setStateChanging(true);
            this.setExportEarInternal(exportEar);
            if (this.isControlCreated()) {
                this.m_exportAsEarButton.setSelection(exportEar);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setExportEarInternal(boolean exportEar) {
        this.setPropertyBool(PROP_EXPORT_EAR, exportEar);
        this.getDialogSettings().put(SETTINGS_EXPORT_EAR, exportEar);
    }

    public String getEarName() {
        return (String)this.getProperty(PROP_EAR_FILE_NAME);
    }

    public void setEarName(String name) {
        try {
            this.setStateChanging(true);
            this.setEarNameInternal(name);
            if (this.isControlCreated()) {
                this.m_earFileName.setText(name);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setEarNameInternal(String name) {
        this.setProperty(PROP_EAR_FILE_NAME, name);
        this.getDialogSettings().put(SETTINGS_EAR_FILE_NAME, name);
    }

    protected IStatus getStatusTargetDirectoryField() {
        if (this.getTargetDirectory() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoTargetSpecified"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusEarFileName() {
        if (this.isExportEar() && !StringUtility.hasText((String)this.m_earFileName.getModifiableText())) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"SelectEarFileName"));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusEntryTree() {
        ExportScoutProjectEntry[] entries = this.getSelectedEntries();
        if (entries == null || entries.length < 1) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"PleaseSelectEntry"));
        }
        return Status.OK_STATUS;
    }

    private ITreeNode buildBundleTree() {
        TreeNode rootNode = new TreeNode(-1, "root");
        rootNode.setVisible(false);
        ExportScoutProjectEntry[] exportScoutProjectEntryArray = ExportScoutProjectEntryExtensionPoint.getEntries();
        int n = exportScoutProjectEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExportScoutProjectEntry e = exportScoutProjectEntryArray[n2];
            if (e.getHandler().isAvailable(this.getWizard())) {
                TreeUtility.createNode(rootNode, 101, e.getName(), ScoutSdkUi.getImageDescriptor(e.getIcon()), e.getOrder(), e);
            }
            ++n2;
        }
        return rootNode;
    }

    private class P_NodeByIdFilter
    implements ITreeNodeFilter {
        private final HashSet<String> m_ids = new HashSet();

        public P_NodeByIdFilter(String ... ids) {
            if (ids != null) {
                String[] stringArray = ids;
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    this.m_ids.add(s);
                    ++n2;
                }
            }
        }

        @Override
        public boolean accept(ITreeNode node) {
            ExportScoutProjectEntry entry = (ExportScoutProjectEntry)node.getData();
            if (entry != null) {
                return this.m_ids.contains(entry.getId());
            }
            return false;
        }
    }
}

