/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.newbundle;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.internal.extensions.bundle.ScoutBundleExtension;
import org.eclipse.scout.sdk.ui.internal.extensions.bundle.ScoutBundleExtensionPoint;
import org.eclipse.scout.sdk.ui.internal.wizard.newproject.ScoutProjectNewWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.swt.widgets.Composite;

public class ScoutBundleNewWizardPage
extends ScoutProjectNewWizardPage {
    private static final Pattern PROJECT_NAME_REGEX = Pattern.compile("(.*)\\s*\\((.*)\\).*");
    private final IScoutProject m_project;
    private final String m_name;
    private final String m_postfix;

    public ScoutBundleNewWizardPage(IScoutProject project) {
        this.m_project = project;
        this.setTitle(Texts.get((String)"CreateNewScoutBundles"));
        this.setDescription(Texts.get((String)"NewScoutBundlesDesc"));
        String[] parts = ScoutBundleNewWizardPage.getProjectNameParts(project.getProjectName());
        this.m_name = parts[0];
        this.m_postfix = parts[1];
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.m_projectNameField.setText(this.m_name);
        this.m_postFixField.setText(this.m_postfix);
        ScoutBundleExtension[] scoutBundleExtensionArray = ScoutBundleExtensionPoint.getExtensions();
        int n = scoutBundleExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScoutBundleExtension e = scoutBundleExtensionArray[n2];
            e.getBundleExtention().init(this.getWizard(), this.getProject());
            ++n2;
        }
        ITreeNode[] backup = this.m_bundleTree.getCheckedNodes();
        this.m_bundleTree.setChecked(new ITreeNode[0]);
        this.m_bundleTree.setChecked(backup);
    }

    public IScoutProject getProject() {
        return this.m_project;
    }

    private static String[] getProjectNameParts(String name) {
        if (name.contains("(")) {
            Matcher m = PROJECT_NAME_REGEX.matcher(name);
            if (m.find()) {
                return new String[]{m.group(1).trim(), m.group(2).trim()};
            }
            return new String[]{"", ""};
        }
        return new String[]{name, ""};
    }
}

