/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.create;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.AbstractWizardAction;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.form.SearchFormNewWizard;
import org.eclipse.scout.sdk.util.ScoutMethodUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class SearchFormNewAction
extends AbstractWizardAction {
    private IType m_type;
    private IScoutBundle m_scoutRes;

    public SearchFormNewAction() {
        super(Texts.get((String)"CreateSearchForm"), ScoutSdkUi.getImageDescriptor("searchForm_add.png"), null, false, IScoutHandler.Category.NEW);
    }

    public void init(IScoutBundle scoutRes) {
        this.init(null, scoutRes);
    }

    public void init(IType type, IScoutBundle scoutRes) {
        this.m_type = type;
        this.m_scoutRes = scoutRes;
    }

    @Override
    protected IWizard getNewWizardInstance() {
        SearchFormNewWizard wizard = new SearchFormNewWizard(this.m_scoutRes);
        if (this.m_type != null) {
            wizard.setTablePage(this.m_type);
            IMethod titleMethod = TypeUtility.getMethod((IType)this.m_type, (String)"getConfiguredTitle");
            if (TypeUtility.exists((IJavaElement)titleMethod)) {
                try {
                    wizard.setNlsEntry(ScoutMethodUtility.getReturnNlsEntry((IMethod)titleMethod));
                }
                catch (CoreException e) {
                    ScoutSdkUi.logWarning("could not parse nls entry for method '" + titleMethod.getElementName() + "'.", e);
                }
            }
        }
        return wizard;
    }
}

