/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class WizardStepDeleteAction
extends AbstractScoutHandler {
    private LinkedList<IType> m_wizardSteps = new LinkedList();

    public WizardStepDeleteAction() {
        super(Texts.get((String)"DeleteWithPopup"), ScoutSdkUi.getImageDescriptor("wizzardStep_remove.png"), "Delete", true, IScoutHandler.Category.DELETE);
    }

    @Override
    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        MessageBox box = new MessageBox(shell, 292);
        if (this.m_wizardSteps.size() == 1) {
            box.setMessage(Texts.get((String)"StepDeleteConfirmationMessage"));
        } else {
            box.setMessage(Texts.get((String)"StepDeleteConfirmationMessagePlural"));
        }
        if (box.open() == 32) {
            JavaElementDeleteOperation delOp = new JavaElementDeleteOperation();
            for (IType stepToDelete : this.m_wizardSteps) {
                delOp.addMember((IJavaElement)stepToDelete);
                IMethod getter = ScoutTypeUtility.getWizardStepGetterMethod((IType)stepToDelete);
                if (!TypeUtility.exists((IJavaElement)getter)) continue;
                delOp.addMember((IJavaElement)getter);
            }
            OperationJob job = new OperationJob(new IOperation[]{delOp});
            job.schedule();
        }
        return null;
    }

    public void addWizardStep(IType wizardStep) {
        this.m_wizardSteps.add(wizardStep);
    }
}

