/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal.nls;

import java.util.regex.Pattern;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.styled.SearchRangeStyledLabelProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.swt.graphics.Image;

public class NlsTextLabelProvider
extends SearchRangeStyledLabelProvider {
    private final INlsProject m_nlsProject;
    private static final Pattern REGEX_CR = Pattern.compile("\r", 16);
    private static final Pattern REGEX_LF = Pattern.compile("\n", 16);

    public NlsTextLabelProvider(INlsProject nlsProject) {
        this.m_nlsProject = nlsProject;
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        if (NlsTextContentProvider.NLS_NEW_PROPOSAL == element) {
            return Texts.get((String)"Nls_newProposal_name");
        }
        if (element instanceof INlsEntry) {
            INlsEntry entry = (INlsEntry)element;
            String text = entry.getTranslation(this.getNlsProject().getDevelopmentLanguage(), true);
            if (StringUtility.isNullOrEmpty((String)text)) {
                text = entry.getKey();
            }
            text = REGEX_CR.matcher(text).replaceAll("");
            text = REGEX_LF.matcher(text).replaceAll(" ");
            return text;
        }
        throw new IllegalArgumentException("expected instanceof INlsEntry, got '" + element + "'");
    }

    @Override
    public String getTextSelected(Object element) {
        if (element == NlsTextContentProvider.NLS_NEW_PROPOSAL) {
            return this.getText(element);
        }
        if (element == null) {
            return "";
        }
        StringBuilder textBuilder = new StringBuilder();
        textBuilder.append(this.getText(element));
        INlsEntry entry = (INlsEntry)element;
        textBuilder.append("  (").append(entry.getKey()).append(")");
        return textBuilder.toString();
    }

    public Image getImage(Object element) {
        if (NlsTextContentProvider.NLS_NEW_PROPOSAL == element) {
            return ScoutSdkUi.getImage("text_add.png");
        }
        return ScoutSdkUi.getImage("text.png");
    }

    @Override
    public Image getImageSelected(Object element) {
        return this.getImage(element);
    }

    public INlsProject getNlsProject() {
        return this.m_nlsProject;
    }
}

