/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.KeyStrokeNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.KeyStrokeNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypePageDirtyListener;
import org.eclipse.scout.sdk.util.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.TypeCacheAccessor;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class KeyStrokeTablePage
extends AbstractPage {
    final IType iKeyStrokeType = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke");
    private final IType m_declaringType;
    private InnerTypePageDirtyListener m_keystrokeChangedListener;

    public KeyStrokeTablePage(IPage parentPage, IType declaringType) {
        this.m_declaringType = declaringType;
        this.setName(Texts.get((String)"KeyStrokesTablePage"));
        this.setParent(parentPage);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("keystrokes.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.KeyStrokeTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public void unloadPage() {
        super.unloadPage();
        if (this.m_keystrokeChangedListener != null) {
            TypeCacheAccessor.getJavaResourceChangedEmitter().removeInnerTypeChangedListener(this.getDeclaringType(), (IJavaResourceChangedListener)this.m_keystrokeChangedListener);
            this.m_keystrokeChangedListener = null;
        }
    }

    @Override
    public void loadChildrenImpl() {
        if (this.m_keystrokeChangedListener == null) {
            this.m_keystrokeChangedListener = new InnerTypePageDirtyListener(this, this.iKeyStrokeType);
            TypeCacheAccessor.getJavaResourceChangedEmitter().addInnerTypeChangedListener(this.getDeclaringType(), (IJavaResourceChangedListener)this.m_keystrokeChangedListener);
        }
        IType[] iTypeArray = ScoutTypeUtility.getKeyStrokes((IType)this.getDeclaringType());
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType keyStroke = iTypeArray[n2];
            KeyStrokeNodePage childPage = new KeyStrokeNodePage();
            childPage.setParent(this);
            childPage.setType(keyStroke);
            ++n2;
        }
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{KeyStrokeNewAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        ((KeyStrokeNewAction)menu).setType(this.getDeclaringType());
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }
}

