/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformServerBundleOperation;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.validation.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.action.validation.ITypeResolver;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.library.LibrariesTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.ServerSessionNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.common.CommonServicesNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.custom.CustomServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.lookup.LookupServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.outline.OutlineServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.process.ProcessServiceTablePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class ServerNodePage
extends AbstractPage {
    final IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
    final IType iServerSession = TypeUtility.getType((String)"org.eclipse.scout.rt.server.IServerSession");
    private final IScoutBundle m_serverBundle;
    private ICachedTypeHierarchy m_serverSessionHierarchy;

    public ServerNodePage(IPage parent, IScoutBundle serverBundle) {
        this.setParent(parent);
        this.m_serverBundle = serverBundle;
        this.setName(this.getScoutResource().getSimpleName());
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("serverBundle.png"));
        this.m_serverSessionHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iServerSession);
        this.m_serverSessionHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ServerNodePage";
    }

    @Override
    public int getOrder() {
        return 300;
    }

    @Override
    public void unloadPage() {
        this.m_serverSessionHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
    }

    @Override
    public boolean isInitiallyLoaded() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return this.m_serverBundle;
    }

    @Override
    public void loadChildrenImpl() {
        try {
            ITypeFilter filter = TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject());
            IType[] serverSessions = this.m_serverSessionHierarchy.getAllSubtypes(this.iServerSession, filter, TypeComparators.getTypeNameComparator());
            if (serverSessions.length > 1) {
                ScoutSdkUi.logError("The server bundle '" + this.getScoutResource().getBundleName() + "' can have in maximum 1 server session.");
            } else if (serverSessions.length == 1) {
                new ServerSessionNodePage(this, serverSessions[0]);
            } else {
                ScoutSdkUi.logInfo("No server session found in server bundle '" + this.getScoutResource().getBundleName() + "'.");
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + ServerSessionNodePage.class.getSimpleName() + "' node in bundle '" + this.getScoutResource().getBundleName() + "'.", e);
        }
        try {
            new LookupServiceTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + LookupServiceTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutResource().getBundleName() + "'.", e);
        }
        try {
            new OutlineServiceTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + OutlineServiceTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutResource().getBundleName() + "'.", e);
        }
        try {
            new ProcessServiceTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + ProcessServiceTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutResource().getBundleName() + "'.", e);
        }
        try {
            new CommonServicesNodePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + CommonServicesNodePage.class.getSimpleName() + "' node in bundle '" + this.getScoutResource().getBundleName() + "'.", e);
        }
        try {
            new CustomServiceTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + CustomServiceTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutResource().getBundleName() + "'.", e);
        }
        try {
            new LibrariesTablePage(this, this.getScoutResource());
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured while loading '" + LibrariesTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutResource().getBundleName() + "'.", e);
        }
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    protected IType[] resolveServices() {
        IPrimaryTypeTypeHierarchy serviceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)this.iService);
        IType[] services = serviceHierarchy.getAllSubtypes(this.iService, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()));
        return services;
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{WellformAction.class, FormDataSqlBindingValidateAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof WellformAction) {
            ((WellformAction)menu).setOperation((IOperation)new WellformServerBundleOperation(this.getScoutResource()));
        } else if (menu instanceof FormDataSqlBindingValidateAction) {
            ((FormDataSqlBindingValidateAction)menu).setTyperesolver(new ITypeResolver(){

                @Override
                public IType[] getTypes() {
                    return ServerNodePage.this.resolveServices();
                }
            });
        }
    }
}

